/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif.makernotes;

import com.drew.lang.Rational;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.makernotes.NikonType2MakernoteDirectory;
import java.text.DecimalFormat;

public class NikonType2MakernoteDescriptor
extends TagDescriptor<NikonType2MakernoteDirectory> {
    public NikonType2MakernoteDescriptor(@NotNull NikonType2MakernoteDirectory nikonType2MakernoteDirectory) {
        super(nikonType2MakernoteDirectory);
    }

    @Override
    @Nullable
    public String getDescription(int n) {
        switch (n) {
            case 13: {
                return this.getProgramShiftDescription();
            }
            case 14: {
                return this.getExposureDifferenceDescription();
            }
            case 132: {
                return this.getLensDescription();
            }
            case 146: {
                return this.getHueAdjustmentDescription();
            }
            case 141: {
                return this.getColorModeDescription();
            }
            case 18: {
                return this.getAutoFlashCompensationDescription();
            }
            case 23: {
                return this.getFlashExposureCompensationDescription();
            }
            case 24: {
                return this.getFlashBracketCompensationDescription();
            }
            case 28: {
                return this.getExposureTuningDescription();
            }
            case 139: {
                return this.getLensStopsDescription();
            }
            case 30: {
                return this.getColorSpaceDescription();
            }
            case 34: {
                return this.getActiveDLightingDescription();
            }
            case 42: {
                return this.getVignetteControlDescription();
            }
            case 2: {
                return this.getIsoSettingDescription();
            }
            case 134: {
                return this.getDigitalZoomDescription();
            }
            case 135: {
                return this.getFlashUsedDescription();
            }
            case 136: {
                return this.getAutoFocusPositionDescription();
            }
            case 1: {
                return this.getFirmwareVersionDescription();
            }
            case 131: {
                return this.getLensTypeDescription();
            }
            case 137: {
                return this.getShootingModeDescription();
            }
            case 147: {
                return this.getNEFCompressionDescription();
            }
            case 177: {
                return this.getHighISONoiseReductionDescription();
            }
            case 182: {
                return this.getPowerUpTimeDescription();
            }
        }
        return super.getDescription(n);
    }

    @Nullable
    public String getPowerUpTimeDescription() {
        return this.getEpochTimeDescription(182);
    }

    @Nullable
    public String getHighISONoiseReductionDescription() {
        return this.getIndexedDescription(177, "Off", "Minimal", "Low", null, "Normal", null, "High");
    }

    @Nullable
    public String getFlashUsedDescription() {
        return this.getIndexedDescription(135, "Flash Not Used", "Manual Flash", null, "Flash Not Ready", null, null, null, "External Flash", "Fired, Commander Mode", "Fired, TTL Mode");
    }

    @Nullable
    public String getNEFCompressionDescription() {
        return this.getIndexedDescription(147, 1, "Lossy (Type 1)", null, "Uncompressed", null, null, null, "Lossless", "Lossy (Type 2)");
    }

    @Nullable
    public String getShootingModeDescription() {
        return this.getBitFlagDescription(137, new String[]{"Single Frame", "Continuous"}, "Delay", null, "PC Control", "Exposure Bracketing", "Auto ISO", "White-Balance Bracketing", "IR Control");
    }

    @Nullable
    public String getLensTypeDescription() {
        return this.getBitFlagDescription(131, new String[]{"AF", "MF"}, "D", "G", "VR");
    }

    @Nullable
    public String getColorSpaceDescription() {
        return this.getIndexedDescription(30, 1, "sRGB", "Adobe RGB");
    }

    @Nullable
    public String getActiveDLightingDescription() {
        Integer n = ((NikonType2MakernoteDirectory)this._directory).getInteger(34);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "Light";
            }
            case 3: {
                return "Normal";
            }
            case 5: {
                return "High";
            }
            case 7: {
                return "Extra High";
            }
            case 65535: {
                return "Auto";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getVignetteControlDescription() {
        Integer n = ((NikonType2MakernoteDirectory)this._directory).getInteger(42);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "Low";
            }
            case 3: {
                return "Normal";
            }
            case 5: {
                return "High";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getAutoFocusPositionDescription() {
        int[] nArray = ((NikonType2MakernoteDirectory)this._directory).getIntArray(136);
        if (nArray == null) {
            return null;
        }
        if (nArray.length != 4 || nArray[0] != 0 || nArray[2] != 0 || nArray[3] != 0) {
            return "Unknown (" + ((NikonType2MakernoteDirectory)this._directory).getString(136) + ")";
        }
        switch (nArray[1]) {
            case 0: {
                return "Centre";
            }
            case 1: {
                return "Top";
            }
            case 2: {
                return "Bottom";
            }
            case 3: {
                return "Left";
            }
            case 4: {
                return "Right";
            }
        }
        return "Unknown (" + nArray[1] + ")";
    }

    @Nullable
    public String getDigitalZoomDescription() {
        Rational rational = ((NikonType2MakernoteDirectory)this._directory).getRational(134);
        if (rational == null) {
            return null;
        }
        return rational.intValue() == 1 ? "No digital zoom" : rational.toSimpleString(true) + "x digital zoom";
    }

    @Nullable
    public String getProgramShiftDescription() {
        return this.getEVDescription(13);
    }

    @Nullable
    public String getExposureDifferenceDescription() {
        return this.getEVDescription(14);
    }

    @Nullable
    public String getAutoFlashCompensationDescription() {
        return this.getEVDescription(18);
    }

    @Nullable
    public String getFlashExposureCompensationDescription() {
        return this.getEVDescription(23);
    }

    @Nullable
    public String getFlashBracketCompensationDescription() {
        return this.getEVDescription(24);
    }

    @Nullable
    public String getExposureTuningDescription() {
        return this.getEVDescription(28);
    }

    @Nullable
    public String getLensStopsDescription() {
        return this.getEVDescription(139);
    }

    @Nullable
    private String getEVDescription(int n) {
        int[] nArray = ((NikonType2MakernoteDirectory)this._directory).getIntArray(n);
        if (nArray == null || nArray.length < 2) {
            return null;
        }
        if (nArray.length < 3 || nArray[2] == 0) {
            return null;
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.##");
        double d = (double)(nArray[0] * nArray[1]) / (double)nArray[2];
        return decimalFormat.format(d) + " EV";
    }

    @Nullable
    public String getIsoSettingDescription() {
        int[] nArray = ((NikonType2MakernoteDirectory)this._directory).getIntArray(2);
        if (nArray == null) {
            return null;
        }
        if (nArray[0] != 0 || nArray[1] == 0) {
            return "Unknown (" + ((NikonType2MakernoteDirectory)this._directory).getString(2) + ")";
        }
        return "ISO " + nArray[1];
    }

    @Nullable
    public String getLensDescription() {
        return this.getLensSpecificationDescription(132);
    }

    @Nullable
    public String getHueAdjustmentDescription() {
        return this.getFormattedString(146, "%s degrees");
    }

    @Nullable
    public String getColorModeDescription() {
        String string = ((NikonType2MakernoteDirectory)this._directory).getString(141);
        return string == null ? null : (string.startsWith("MODE1") ? "Mode I (sRGB)" : string);
    }

    @Nullable
    public String getFirmwareVersionDescription() {
        return this.getVersionBytesDescription(1, 2);
    }
}

