/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.util.Objects;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictDecisionType;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class RelationMemberConflictDecision {
    private final Relation relation;
    private final int pos;
    private final OsmPrimitive originalPrimitive;
    private String role;
    private RelationMemberConflictDecisionType decision;

    public RelationMemberConflictDecision(Relation relation, int n) {
        CheckParameterUtil.ensureParameterNotNull(relation, "relation");
        RelationMember relationMember = relation.getMember(n);
        if (relationMember == null) {
            throw new IndexOutOfBoundsException(I18n.tr("Position {0} is out of range. Current number of members is {1}.", n, relation.getMembersCount()));
        }
        this.relation = relation;
        this.pos = n;
        this.originalPrimitive = relationMember.getMember();
        this.role = relationMember.hasRole() ? relationMember.getRole() : "";
        this.decision = RelationMemberConflictDecisionType.UNDECIDED;
    }

    public Relation getRelation() {
        return this.relation;
    }

    public int getPos() {
        return this.pos;
    }

    public OsmPrimitive getOriginalPrimitive() {
        return this.originalPrimitive;
    }

    public String getRole() {
        return this.role;
    }

    public RelationMemberConflictDecisionType getDecision() {
        return this.decision;
    }

    public void setRole(String string) {
        this.role = string == null ? "" : string;
    }

    public void decide(RelationMemberConflictDecisionType relationMemberConflictDecisionType) {
        if (relationMemberConflictDecisionType == null) {
            relationMemberConflictDecisionType = RelationMemberConflictDecisionType.UNDECIDED;
        }
        this.decision = relationMemberConflictDecisionType;
    }

    public boolean isDecided() {
        return !RelationMemberConflictDecisionType.UNDECIDED.equals((Object)this.decision);
    }

    public boolean matches(Relation relation, int n) {
        return this.relation == relation && this.pos == n;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.relation, this.pos, this.originalPrimitive, this.role, this.decision});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RelationMemberConflictDecision relationMemberConflictDecision = (RelationMemberConflictDecision)object;
        return this.pos == relationMemberConflictDecision.pos && this.decision == relationMemberConflictDecision.decision && Objects.equals(this.relation, relationMemberConflictDecision.relation) && Objects.equals(this.originalPrimitive, relationMemberConflictDecision.originalPrimitive) && Objects.equals(this.role, relationMemberConflictDecision.role);
    }

    public String toString() {
        return this.originalPrimitive.getPrimitiveId() + " at index " + this.pos + " with role " + this.role + " in " + this.relation.getUniqueId() + " => " + (Object)((Object)this.decision);
    }
}

