/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rubinius;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.jruby.truffle.algorithms.Randomizer;
import org.jruby.truffle.core.basicobject.BasicObjectLayoutImpl;
import org.jruby.truffle.core.rubinius.RandomizerLayout;

@GeneratedBy(value=RandomizerLayout.class)
public class RandomizerLayoutImpl
extends BasicObjectLayoutImpl
implements RandomizerLayout {
    public static final RandomizerLayout INSTANCE = new RandomizerLayoutImpl();
    protected static final Shape.Allocator RANDOMIZER_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey RANDOMIZER_IDENTIFIER = new HiddenKey("randomizer");
    protected static final Property RANDOMIZER_PROPERTY = Property.create(RANDOMIZER_IDENTIFIER, RANDOMIZER_ALLOCATOR.locationForType(Randomizer.class, EnumSet.of(LocationModifier.NonNull)), 0);

    protected RandomizerLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createRandomizerShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape(new RandomizerType(logicalClass, metaClass)).addProperty(RANDOMIZER_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createRandomizer(DynamicObjectFactory factory, Randomizer randomizer) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant(factory);
        assert (RandomizerLayoutImpl.createsRandomizer(factory));
        assert (factory.getShape().hasProperty(RANDOMIZER_IDENTIFIER));
        assert (randomizer != null);
        return factory.newInstance(randomizer);
    }

    private static boolean isRandomizer(DynamicObject object) {
        return RandomizerLayoutImpl.isRandomizer(object.getShape().getObjectType());
    }

    private static boolean isRandomizer(ObjectType objectType) {
        return objectType instanceof RandomizerType;
    }

    private static boolean createsRandomizer(DynamicObjectFactory factory) {
        return RandomizerLayoutImpl.isRandomizer(factory.getShape().getObjectType());
    }

    @Override
    public Randomizer getRandomizer(DynamicObject object) {
        assert (RandomizerLayoutImpl.isRandomizer(object));
        assert (object.getShape().hasProperty(RANDOMIZER_IDENTIFIER));
        return (Randomizer)RANDOMIZER_PROPERTY.get(object, RandomizerLayoutImpl.isRandomizer(object));
    }

    @Override
    public void setRandomizer(DynamicObject object, Randomizer value) {
        assert (RandomizerLayoutImpl.isRandomizer(object));
        assert (object.getShape().hasProperty(RANDOMIZER_IDENTIFIER));
        assert (value != null);
        try {
            RANDOMIZER_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static class RandomizerType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public RandomizerType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public RandomizerType setLogicalClass(DynamicObject logicalClass) {
            return new RandomizerType(logicalClass, this.metaClass);
        }

        @Override
        public RandomizerType setMetaClass(DynamicObject metaClass) {
            return new RandomizerType(this.logicalClass, metaClass);
        }
    }
}

