/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.ShortDoubleHashMap;

public class ShortDoubleScatterMap
extends ShortDoubleHashMap {
    public ShortDoubleScatterMap() {
        this(4);
    }

    public ShortDoubleScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ShortDoubleScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(short key) {
        return BitMixer.mixPhi(key);
    }

    public static ShortDoubleScatterMap from(short[] keys, double[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ShortDoubleScatterMap map = new ShortDoubleScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

