/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.WizardController;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;

public class WizardPane
extends JOptionPane
implements DialogView {
    private final UserPreferences preferences;
    private final WizardController controller;
    private JButton backOptionButton;
    private JButton nextFinishOptionButton;
    private String defaultTitle;
    private JDialog dialog;

    public WizardPane(UserPreferences userPreferences, final WizardController wizardController) {
        this.preferences = userPreferences;
        this.controller = wizardController;
        this.defaultTitle = userPreferences.getLocalizedString(WizardPane.class, "wizard.title", new Object[0]);
        this.setMessage(new JPanel(new BorderLayout(10, 0)));
        this.createOptionButtons(userPreferences, wizardController);
        this.setOptionType(-1);
        String string = userPreferences.getLocalizedString(WizardPane.class, "cancelOption", new Object[0]);
        if (UIManager.getBoolean("OptionPane.isYesLast") || OperatingSystem.isMacOSX()) {
            this.setOptions(new Object[]{this.nextFinishOptionButton, this.backOptionButton, string});
        } else {
            this.setOptions(new Object[]{this.backOptionButton, this.nextFinishOptionButton, string});
        }
        this.setInitialValue(this.nextFinishOptionButton);
        this.updateStepView(wizardController);
        wizardController.addPropertyChangeListener(WizardController.Property.STEP_VIEW, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WizardPane.this.updateStepView(wizardController);
            }
        });
        this.updateStepIcon(wizardController);
        wizardController.addPropertyChangeListener(WizardController.Property.STEP_ICON, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WizardPane.this.updateStepIcon(wizardController);
            }
        });
    }

    private void createOptionButtons(UserPreferences userPreferences, final WizardController wizardController) {
        this.backOptionButton = new JButton(SwingTools.getLocalizedLabelText(userPreferences, WizardPane.class, "backOptionButton.text", new Object[0]));
        this.backOptionButton.setEnabled(wizardController.isBackStepEnabled());
        wizardController.addPropertyChangeListener(WizardController.Property.BACK_STEP_ENABLED, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WizardPane.this.backOptionButton.setEnabled(wizardController.isBackStepEnabled());
            }
        });
        if (!OperatingSystem.isMacOSX()) {
            this.backOptionButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(WizardPane.class, "backOptionButton.mnemonic", new Object[0])).getKeyCode());
        }
        this.nextFinishOptionButton = new JButton();
        this.nextFinishOptionButton.setEnabled(wizardController.isNextStepEnabled());
        wizardController.addPropertyChangeListener(WizardController.Property.NEXT_STEP_ENABLED, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WizardPane.this.nextFinishOptionButton.setEnabled(wizardController.isNextStepEnabled());
            }
        });
        this.updateNextFinishOptionButton(wizardController);
        wizardController.addPropertyChangeListener(WizardController.Property.LAST_STEP, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WizardPane.this.updateNextFinishOptionButton(wizardController);
            }
        });
        this.backOptionButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                wizardController.goBackToPreviousStep();
            }
        });
        this.nextFinishOptionButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (wizardController.isLastStep()) {
                    wizardController.finish();
                    WizardPane.this.setValue(WizardPane.this.nextFinishOptionButton);
                    if (WizardPane.this.dialog != null) {
                        WizardPane.this.dialog.setVisible(false);
                    }
                } else {
                    wizardController.goToNextStep();
                }
            }
        });
    }

    private void updateNextFinishOptionButton(WizardController wizardController) {
        this.nextFinishOptionButton.setText(SwingTools.getLocalizedLabelText(this.preferences, WizardPane.class, wizardController.isLastStep() ? "finishOptionButton.text" : "nextOptionButton.text", new Object[0]));
        if (!OperatingSystem.isMacOSX()) {
            this.nextFinishOptionButton.setMnemonic(KeyStroke.getKeyStroke(this.preferences.getLocalizedString(WizardPane.class, wizardController.isLastStep() ? "finishOptionButton.mnemonic" : "nextOptionButton.mnemonic", new Object[0])).getKeyCode());
        }
    }

    private void updateStepView(WizardController wizardController) {
        View view;
        JPanel jPanel = (JPanel)this.getMessage();
        Component component = ((BorderLayout)jPanel.getLayout()).getLayoutComponent("Center");
        if (component != null) {
            jPanel.remove(component);
        }
        if ((view = wizardController.getStepView()) != null) {
            jPanel.add((Component)((JComponent)((Object)view)), "Center");
        }
        if (this.dialog != null && !this.controller.isResizable()) {
            this.dialog.pack();
        }
    }

    private void updateStepIcon(WizardController wizardController) {
        URL uRL;
        JPanel jPanel = (JPanel)this.getMessage();
        Component component = ((BorderLayout)jPanel.getLayout()).getLayoutComponent("West");
        if (component != null) {
            jPanel.remove(component);
        }
        if ((uRL = wizardController.getStepIcon()) != null) {
            String[] stringArray;
            Object object = new Color(163, 168, 226);
            Object object2 = new Color(80, 86, 158);
            try {
                stringArray = this.preferences.getLocalizedString(WizardPane.class, "stepIconBackgroundColors", new Object[0]).trim().split(" ");
                object = new Color(Integer.decode(stringArray[0]));
                if (stringArray.length == 1) {
                    object2 = object;
                } else if (stringArray.length == 2) {
                    object2 = new Color(Integer.decode(stringArray[1]));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            stringArray = object;
            Object object3 = object2;
            JLabel jLabel = new JLabel(new ImageIcon(uRL), (Color)stringArray, (Color)object3){
                final /* synthetic */ Color val$gradientColor1;
                final /* synthetic */ Color val$gradientColor2;
                {
                    this.val$gradientColor1 = color;
                    this.val$gradientColor2 = color2;
                    super(icon);
                }

                protected void paintComponent(Graphics graphics) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, this.val$gradientColor1, 0.0f, this.getHeight(), this.val$gradientColor2));
                    graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                    super.paintComponent(graphics);
                }
            };
            jLabel.setBorder(new BevelBorder(1){

                public Insets getBorderInsets(Component component) {
                    return new Insets(1, 1, 1, 1);
                }

                protected void paintLoweredBevel(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                    Color color = graphics.getColor();
                    graphics.translate(n, n2);
                    graphics.setColor(this.getShadowInnerColor(component));
                    graphics.drawLine(0, 0, 0, n4 - 1);
                    graphics.drawLine(0, 0, n3 - 1, 0);
                    graphics.setColor(this.getHighlightInnerColor(component));
                    graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
                    graphics.drawLine(n3 - 1, 1, n3 - 1, n4 - 2);
                    graphics.translate(-n, -n2);
                    graphics.setColor(color);
                }
            });
            jPanel.add((Component)jLabel, "Before");
        }
    }

    public void displayView(View view) {
        this.dialog = this.createDialog(SwingUtilities.getRootPane((JComponent)((Object)view)), this.controller.getTitle() != null ? this.controller.getTitle() : this.defaultTitle);
        this.controller.addPropertyChangeListener(WizardController.Property.TITLE, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WizardPane.this.dialog.setTitle(WizardPane.this.controller.getTitle() != null ? WizardPane.this.controller.getTitle() : WizardPane.this.defaultTitle);
            }
        });
        this.dialog.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        this.dialog.setResizable(this.controller.isResizable());
        this.controller.addPropertyChangeListener(WizardController.Property.RESIZABLE, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WizardPane.this.dialog.setResizable(WizardPane.this.controller.isResizable());
            }
        });
        this.dialog.pack();
        this.dialog.setMinimumSize(this.getSize());
        this.dialog.setVisible(true);
        this.dialog.dispose();
    }
}

