/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository.email;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.RepositoryUtilities;
import org.pentaho.reporting.libraries.repository.email.EmailContentLocation;
import org.pentaho.reporting.libraries.repository.email.EmailEntryOutputStream;
import org.pentaho.reporting.libraries.repository.email.EmailRepository;

public class EmailContentItem
implements ContentItem {
    private boolean newItem;
    private String name;
    private String contentId;
    private EmailRepository repository;
    private EmailContentLocation parent;
    private String contentType;

    public EmailContentItem(String name, EmailRepository repository, EmailContentLocation parent) {
        this.name = name;
        this.repository = repository;
        this.parent = parent;
        this.contentId = RepositoryUtilities.buildName(this, "/");
        this.newItem = true;
    }

    public String getMimeType() throws ContentIOException {
        return this.getRepository().getMimeRegistry().getMimeType(this);
    }

    public OutputStream getOutputStream() throws ContentIOException, IOException {
        if (!this.newItem) {
            throw new ContentIOException("This item is no longer writeable.");
        }
        this.newItem = false;
        return new EmailEntryOutputStream(this);
    }

    public InputStream getInputStream() throws ContentIOException, IOException {
        throw new ContentIOException("This item is not readable.");
    }

    public boolean isReadable() {
        return false;
    }

    public boolean isWriteable() {
        return this.newItem;
    }

    public String getName() {
        return this.name;
    }

    public Object getContentId() {
        return this.contentId;
    }

    public Object getAttribute(String domain, String key) {
        if ("org.jfree.repository".equals(domain) && "content-type".equals(key)) {
            return this.contentType;
        }
        return null;
    }

    public boolean setAttribute(String domain, String key, Object value) {
        if ("org.jfree.repository".equals(domain) && "content-type".equals(key)) {
            this.contentType = (String)value;
            return true;
        }
        return false;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public ContentLocation getParent() {
        return this.parent;
    }

    public boolean delete() {
        return false;
    }
}

