/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.protocols.urp;

import com.sun.star.bridge.InvalidProtocolChangeException;
import com.sun.star.bridge.ProtocolProperty;
import com.sun.star.bridge.XProtocolProperties;
import com.sun.star.lang.DisposedException;
import com.sun.star.lib.uno.environments.remote.IProtocol;
import com.sun.star.lib.uno.environments.remote.Message;
import com.sun.star.lib.uno.environments.remote.ThreadId;
import com.sun.star.lib.uno.protocols.urp.Marshal;
import com.sun.star.lib.uno.protocols.urp.PendingRequests;
import com.sun.star.lib.uno.protocols.urp.Unmarshal;
import com.sun.star.lib.uno.protocols.urp.UrpMessage;
import com.sun.star.lib.uno.typedesc.TypeDescription;
import com.sun.star.uno.Any;
import com.sun.star.uno.IBridge;
import com.sun.star.uno.IMethodDescription;
import com.sun.star.uno.ITypeDescription;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.TypeClass;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XCurrentContext;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Random;
import java.util.StringTokenizer;

public final class urp
implements IProtocol {
    private static final String PROPERTIES_OID = "UrpProtocolProperties";
    private static final int PROPERTIES_FID_REQUEST_CHANGE = 4;
    private static final String PROPERTIES_FUN_REQUEST_CHANGE = "requestChange";
    private static final int PROPERTIES_FID_COMMIT_CHANGE = 5;
    private static final String PROPERTIES_FUN_COMMIT_CHANGE = "commitChange";
    private static final String PROPERTY_CURRENT_CONTEXT = "CurrentContext";
    private static final short CACHE_SIZE = 256;
    private static final int HEADER_LONGHEADER = 128;
    private static final int HEADER_REQUEST = 64;
    private static final int HEADER_NEWTYPE = 32;
    private static final int HEADER_NEWOID = 16;
    private static final int HEADER_NEWTID = 8;
    private static final int HEADER_FUNCTIONID16 = 4;
    private static final int HEADER_MOREFLAGS = 1;
    private static final int HEADER_MUSTREPLY = 128;
    private static final int HEADER_SYNCHRONOUS = 64;
    private static final int HEADER_FUNCTIONID14 = 64;
    private static final int HEADER_FUNCTIONID = 63;
    private static final int HEADER_EXCEPTION = 32;
    private static final int MAX_FUNCTIONID16 = 65535;
    private static final int MAX_FUNCTIONID14 = 16383;
    private static final int MAX_FUNCTIONID8 = 255;
    private static final int STATE_INITIAL0 = 0;
    private static final int STATE_INITIAL = 1;
    private static final int STATE_REQUESTED = 2;
    private static final int STATE_COMMITTED = 3;
    private static final int STATE_WAIT = 4;
    private static final int STATE_TERMINATED = 5;
    private static final int MAX_RELEASE_QUEUE_SIZE = 100;
    private static final Random randomGenerator = new Random();
    private final DataInput input;
    private final DataOutputStream output;
    private final Marshal marshal;
    private final Unmarshal unmarshal;
    private final boolean forceSynchronous;
    private final PendingRequests pendingIn = new PendingRequests();
    private final PendingRequests pendingOut = new PendingRequests();
    private final Object monitor = new Object();
    private int state = 0;
    private boolean initialized = false;
    private ThreadId propertiesTid = null;
    private int random;
    private boolean currentContext = false;
    private ThreadId inL1Tid = null;
    private String inL1Oid = null;
    private TypeDescription inL1Type = null;
    private ThreadId outL1Tid = null;
    private String outL1Oid = null;
    private ITypeDescription outL1Type = null;
    private final ArrayList<QueuedRelease> releaseQueue = new ArrayList();

    public urp(IBridge bridge, String attributes, InputStream input, OutputStream output) {
        this.input = new DataInputStream(input);
        this.output = new DataOutputStream(output);
        this.marshal = new Marshal(bridge, 256);
        this.unmarshal = new Unmarshal(bridge, 256);
        this.forceSynchronous = urp.parseAttributes(attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws IOException {
        Object object = this.monitor;
        synchronized (object) {
            if (this.state == 0) {
                this.sendRequestChange();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        Object object = this.monitor;
        synchronized (object) {
            this.state = 5;
            this.initialized = true;
            this.monitor.notifyAll();
        }
    }

    public Message readMessage() throws IOException {
        UrpMessage msg;
        while (true) {
            int header;
            if (!this.unmarshal.hasMore()) {
                this.unmarshal.reset(this.readBlock());
                if (!this.unmarshal.hasMore()) {
                    throw new IOException("closeConnection message received");
                }
            }
            msg = ((header = this.unmarshal.read8Bit()) & 0x80) != 0 ? ((header & 0x40) != 0 ? this.readLongRequest(header) : this.readReply(header)) : this.readShortRequest(header);
            if (!msg.isInternal()) break;
            this.handleInternalMessage(msg);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeRequest(String oid, TypeDescription type, String function, ThreadId tid, Object[] arguments) throws IOException {
        if (oid.equals(PROPERTIES_OID)) {
            throw new IllegalArgumentException("illegal OID " + oid);
        }
        Object object = this.monitor;
        synchronized (object) {
            while (!this.initialized) {
                try {
                    this.monitor.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new java.lang.RuntimeException(e);
                }
            }
            if (this.state == 5) {
                throw new DisposedException();
            }
            return this.writeRequest(false, oid, type, function, tid, arguments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeReply(boolean exception, ThreadId tid, Object result) throws IOException {
        DataOutputStream dataOutputStream = this.output;
        synchronized (dataOutputStream) {
            Object[] args;
            ITypeDescription[] argTypes;
            TypeDescription resultType;
            this.writeQueuedReleases();
            int header = 128;
            PendingRequests.Item pending = this.pendingIn.pop(tid);
            if (exception) {
                header |= 0x20;
                resultType = TypeDescription.getTypeDescription(TypeClass.ANY);
                argTypes = null;
                args = null;
            } else {
                resultType = (TypeDescription)pending.function.getReturnSignature();
                argTypes = pending.function.getOutSignature();
                args = pending.arguments;
            }
            if (!tid.equals(this.outL1Tid)) {
                header |= 8;
                this.outL1Tid = tid;
            } else {
                tid = null;
            }
            this.marshal.write8Bit(header);
            if (tid != null) {
                this.marshal.writeThreadId(tid);
            }
            this.marshal.writeValue(resultType, result);
            if (argTypes != null) {
                for (int i = 0; i < argTypes.length; ++i) {
                    if (argTypes[i] == null) continue;
                    this.marshal.writeValue((TypeDescription)argTypes[i].getComponentType(), Array.get(args[i], 0));
                }
            }
            this.writeBlock(true);
        }
    }

    private void sendRequestChange() throws IOException {
        if (this.propertiesTid == null) {
            this.propertiesTid = ThreadId.createFresh();
        }
        this.random = randomGenerator.nextInt();
        this.writeRequest(true, PROPERTIES_OID, TypeDescription.getTypeDescription(XProtocolProperties.class), PROPERTIES_FUN_REQUEST_CHANGE, this.propertiesTid, new Object[]{this.random});
        this.state = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleInternalMessage(Message message) throws IOException {
        if (message.isRequest()) {
            String t = message.getType().getTypeName();
            if (!t.equals("com.sun.star.bridge.XProtocolProperties")) {
                throw new IOException("read URP protocol properties request with unsupported type " + t);
            }
            int fid = message.getMethod().getIndex();
            switch (fid) {
                case 4: {
                    this.checkSynchronousPropertyRequest(message);
                    Object object = this.monitor;
                    synchronized (object) {
                        switch (this.state) {
                            case 0: 
                            case 1: {
                                this.writeReply(false, message.getThreadId(), 1);
                                this.state = 4;
                                break;
                            }
                            case 2: {
                                int n = (Integer)message.getArguments()[0];
                                if (this.random < n) {
                                    this.writeReply(false, message.getThreadId(), 1);
                                    this.state = 4;
                                    break;
                                }
                                if (this.random == n) {
                                    this.writeReply(false, message.getThreadId(), -1);
                                    this.state = 1;
                                    this.sendRequestChange();
                                    break;
                                }
                                this.writeReply(false, message.getThreadId(), 0);
                                break;
                            }
                            default: {
                                this.writeReply(true, message.getThreadId(), new RuntimeException("read URP protocol properties requestChange request in illegal state"));
                            }
                        }
                        break;
                    }
                }
                case 5: {
                    this.checkSynchronousPropertyRequest(message);
                    Object object = this.monitor;
                    synchronized (object) {
                        if (this.state == 4) {
                            int i;
                            ProtocolProperty[] p = (ProtocolProperty[])message.getArguments()[0];
                            boolean ok = true;
                            boolean cc = false;
                            for (i = 0; i < p.length; ++i) {
                                if (!p[i].Name.equals(PROPERTY_CURRENT_CONTEXT)) {
                                    ok = false;
                                    break;
                                }
                                cc = true;
                            }
                            if (ok) {
                                this.writeReply(false, message.getThreadId(), null);
                            } else {
                                this.writeReply(true, message.getThreadId(), new InvalidProtocolChangeException("", null, p[i], 1));
                            }
                            this.state = 1;
                            if (!this.initialized) {
                                if (cc) {
                                    this.currentContext = true;
                                    this.initialized = true;
                                    this.monitor.notifyAll();
                                } else {
                                    this.sendRequestChange();
                                }
                            }
                        } else {
                            this.writeReply(true, message.getThreadId(), new RuntimeException("read URP protocol properties commitChange request in illegal state"));
                        }
                        break;
                    }
                }
                default: {
                    throw new IOException("read URP protocol properties request with unsupported function ID " + fid);
                }
            }
        } else {
            Object object = this.monitor;
            synchronized (object) {
                if (this.state == 3) {
                    if (!message.isAbnormalTermination()) {
                        this.currentContext = true;
                    }
                    this.state = 1;
                    this.initialized = true;
                    this.monitor.notifyAll();
                } else if (message.isAbnormalTermination()) {
                    this.state = 1;
                    this.initialized = true;
                    this.monitor.notifyAll();
                } else {
                    int n = (Integer)message.getResult();
                    switch (n) {
                        case -1: 
                        case 0: {
                            break;
                        }
                        case 1: {
                            this.writeRequest(true, PROPERTIES_OID, TypeDescription.getTypeDescription(XProtocolProperties.class), PROPERTIES_FUN_COMMIT_CHANGE, this.propertiesTid, new Object[]{new ProtocolProperty[]{new ProtocolProperty(PROPERTY_CURRENT_CONTEXT, Any.VOID)}});
                            this.state = 3;
                            break;
                        }
                        default: {
                            throw new IOException("read URP protocol properties requestChange reply with illegal return value " + n);
                        }
                    }
                }
            }
        }
    }

    private void checkSynchronousPropertyRequest(Message message) throws IOException {
        if (!message.isSynchronous()) {
            throw new IOException("read URP protocol properties request for synchronous function marked as not SYNCHRONOUS");
        }
    }

    private byte[] readBlock() throws IOException {
        int size = this.input.readInt();
        this.input.readInt();
        byte[] bytes = new byte[size];
        this.input.readFully(bytes);
        return bytes;
    }

    private UrpMessage readLongRequest(int header) throws IOException {
        int funId;
        boolean sync = false;
        if ((header & 1) != 0) {
            if (this.unmarshal.read8Bit() != 192) {
                throw new IOException("read URP request with bad MUSTREPLY/SYNCHRONOUS byte");
            }
            sync = true;
        }
        int n = funId = (header & 4) != 0 ? this.unmarshal.read16Bit() : this.unmarshal.read8Bit();
        if ((header & 0x20) != 0) {
            this.inL1Type = this.unmarshal.readType();
            if (this.inL1Type.getTypeClass() != TypeClass.INTERFACE) {
                throw new IOException("read URP request with non-interface type " + this.inL1Type);
            }
        }
        if ((header & 0x10) != 0) {
            this.inL1Oid = this.unmarshal.readObjectId();
        }
        if ((header & 8) != 0) {
            this.inL1Tid = this.unmarshal.readThreadId();
        }
        return this.readRequest(funId, sync);
    }

    private UrpMessage readShortRequest(int header) throws IOException {
        int funId = (header & 0x40) != 0 ? (header & 0x3F) << 8 | this.unmarshal.read8Bit() : header & 0x3F;
        return this.readRequest(funId, false);
    }

    private UrpMessage readRequest(int functionId, boolean forcedSynchronous) throws IOException {
        boolean sync;
        boolean internal = PROPERTIES_OID.equals(this.inL1Oid);
        XCurrentContext cc = this.currentContext && !internal && functionId != 2 ? (XCurrentContext)this.unmarshal.readInterface(new Type(XCurrentContext.class)) : null;
        IMethodDescription desc = this.inL1Type.getMethodDescription(functionId);
        if (desc == null) {
            throw new IOException("read URP request with unsupported function ID " + functionId);
        }
        ITypeDescription[] inSig = desc.getInSignature();
        ITypeDescription[] outSig = desc.getOutSignature();
        Object[] args = new Object[inSig.length];
        for (int i = 0; i < args.length; ++i) {
            if (inSig[i] != null) {
                if (outSig[i] != null) {
                    Object inout = Array.newInstance(outSig[i].getComponentType().getZClass(), 1);
                    Array.set(inout, 0, this.unmarshal.readValue((TypeDescription)outSig[i].getComponentType()));
                    args[i] = inout;
                    continue;
                }
                args[i] = this.unmarshal.readValue((TypeDescription)inSig[i]);
                continue;
            }
            args[i] = Array.newInstance(outSig[i].getComponentType().getZClass(), 1);
        }
        boolean bl = sync = forcedSynchronous || !desc.isOneway();
        if (sync) {
            this.pendingIn.push(this.inL1Tid, new PendingRequests.Item(internal, desc, args));
        }
        return new UrpMessage(this.inL1Tid, true, this.inL1Oid, this.inL1Type, desc, sync, cc, false, null, args, internal);
    }

    private UrpMessage readReply(int header) {
        Object result;
        Object[] args;
        ITypeDescription[] argTypes;
        TypeDescription resultType;
        boolean exception;
        if ((header & 8) != 0) {
            this.inL1Tid = this.unmarshal.readThreadId();
        }
        PendingRequests.Item pending = this.pendingOut.pop(this.inL1Tid);
        boolean bl = exception = (header & 0x20) != 0;
        if (exception) {
            resultType = TypeDescription.getTypeDescription(TypeClass.ANY);
            argTypes = null;
            args = null;
        } else {
            resultType = (TypeDescription)pending.function.getReturnSignature();
            argTypes = pending.function.getOutSignature();
            args = pending.arguments;
        }
        Object object = result = resultType == null ? null : this.unmarshal.readValue(resultType);
        if (argTypes != null) {
            for (int i = 0; i < argTypes.length; ++i) {
                if (argTypes[i] == null) continue;
                Array.set(args[i], 0, this.unmarshal.readValue((TypeDescription)argTypes[i].getComponentType()));
            }
        }
        return new UrpMessage(this.inL1Tid, false, null, null, null, false, null, exception, result, args, pending.internal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeRequest(boolean internal, String oid, TypeDescription type, String function, ThreadId tid, Object[] arguments) throws IOException {
        IMethodDescription desc = type.getMethodDescription(function);
        DataOutputStream dataOutputStream = this.output;
        synchronized (dataOutputStream) {
            if (desc.getIndex() == 2 && this.releaseQueue.size() < 100) {
                this.releaseQueue.add(new QueuedRelease(internal, oid, type, desc, tid));
                return false;
            }
            this.writeQueuedReleases();
            return this.writeRequest(internal, oid, type, desc, tid, arguments, true);
        }
    }

    private boolean writeRequest(boolean internal, String oid, TypeDescription type, IMethodDescription desc, ThreadId tid, Object[] arguments, boolean flush) throws IOException {
        boolean sync;
        boolean moreFlags;
        int funId = desc.getIndex();
        if (funId < 0 || funId > 65535) {
            throw new IllegalArgumentException("function ID " + funId + " out of range");
        }
        boolean forceSync = this.forceSynchronous && funId != 2;
        boolean longHeader = moreFlags = forceSync && desc.isOneway();
        int header = 0;
        if (!type.equals(this.outL1Type)) {
            longHeader = true;
            header |= 0x20;
            this.outL1Type = type;
        } else {
            type = null;
        }
        if (!oid.equals(this.outL1Oid)) {
            longHeader = true;
            header |= 0x10;
            this.outL1Oid = oid;
        } else {
            oid = null;
        }
        if (!tid.equals(this.outL1Tid)) {
            longHeader = true;
            header |= 8;
            this.outL1Tid = tid;
        } else {
            tid = null;
        }
        if (funId > 16383) {
            longHeader = true;
        }
        if (longHeader) {
            header |= 0xC0;
            if (funId > 255) {
                header |= 4;
            }
            if (moreFlags) {
                header |= 1;
            }
            this.marshal.write8Bit(header);
            if (moreFlags) {
                this.marshal.write8Bit(192);
            }
            if (funId > 255) {
                this.marshal.write16Bit(funId);
            } else {
                this.marshal.write8Bit(funId);
            }
            if (type != null) {
                this.marshal.writeType(type);
            }
            if (oid != null) {
                this.marshal.writeObjectId(oid);
            }
            if (tid != null) {
                this.marshal.writeThreadId(tid);
            }
        } else {
            if (funId > 63) {
                this.marshal.write8Bit(0x40 | funId >> 8);
            }
            this.marshal.write8Bit(funId);
        }
        if (this.currentContext && !internal && funId != 2) {
            this.marshal.writeInterface(UnoRuntime.getCurrentContext(), new Type(XCurrentContext.class));
        }
        ITypeDescription[] inSig = desc.getInSignature();
        ITypeDescription[] outSig = desc.getOutSignature();
        for (int i = 0; i < inSig.length; ++i) {
            if (inSig[i] == null) continue;
            if (outSig[i] != null) {
                this.marshal.writeValue((TypeDescription)outSig[i].getComponentType(), ((Object[])arguments[i])[0]);
                continue;
            }
            this.marshal.writeValue((TypeDescription)inSig[i], arguments[i]);
        }
        boolean bl = sync = forceSync || !desc.isOneway();
        if (sync) {
            this.pendingOut.push(this.outL1Tid, new PendingRequests.Item(internal, desc, arguments));
        }
        this.writeBlock(flush);
        return sync;
    }

    private void writeBlock(boolean flush) throws IOException {
        byte[] data = this.marshal.reset();
        this.output.writeInt(data.length);
        this.output.writeInt(1);
        this.output.write(data);
        if (flush) {
            this.output.flush();
        }
    }

    private void writeQueuedReleases() throws IOException {
        int i = this.releaseQueue.size();
        while (i > 0) {
            QueuedRelease r = this.releaseQueue.get(--i);
            this.writeRequest(r.internal, r.objectId, r.type, r.method, r.threadId, null, false);
            this.releaseQueue.remove(i);
        }
    }

    private static boolean parseAttributes(String attributes) {
        boolean forceSynchronous = true;
        if (attributes != null) {
            StringTokenizer t = new StringTokenizer(attributes, ",");
            while (t.hasMoreTokens()) {
                String a = t.nextToken();
                String v = null;
                int i = a.indexOf(61);
                if (i >= 0) {
                    v = a.substring(i + 1);
                    a = a.substring(0, i);
                }
                if (a.equalsIgnoreCase("ForceSynchronous")) {
                    forceSynchronous = urp.parseBooleanAttributeValue(a, v);
                    continue;
                }
                if (a.equalsIgnoreCase("negotiate")) {
                    urp.parseBooleanAttributeValue(a, v);
                    continue;
                }
                throw new IllegalArgumentException("unknown protocol attribute " + a);
            }
        }
        return forceSynchronous;
    }

    private static boolean parseBooleanAttributeValue(String attribute, String value) {
        if (value == null) {
            throw new IllegalArgumentException("missing value for protocol attribute " + attribute);
        }
        if (value.equals("0")) {
            return false;
        }
        if (value.equals("1")) {
            return true;
        }
        throw new IllegalArgumentException("bad value " + value + " for protocol attribute " + attribute);
    }

    private static final class QueuedRelease {
        public final boolean internal;
        public final String objectId;
        public final TypeDescription type;
        public final IMethodDescription method;
        public final ThreadId threadId;

        public QueuedRelease(boolean internal, String objectId, TypeDescription type, IMethodDescription method, ThreadId threadId) {
            this.internal = internal;
            this.objectId = objectId;
            this.type = type;
            this.method = method;
            this.threadId = threadId;
        }
    }
}

