/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.db;

import com.sun.star.awt.XWindow;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XChild;
import com.sun.star.container.XHierarchicalNameAccess;
import com.sun.star.container.XHierarchicalNameContainer;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XStorable;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.Locale;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.sdb.XCompletedConnection;
import com.sun.star.sdb.XDocumentDataSource;
import com.sun.star.sdb.XFormDocumentsSupplier;
import com.sun.star.sdb.XOfficeDatabaseDocument;
import com.sun.star.sdb.XQueriesSupplier;
import com.sun.star.sdb.XQueryDefinitionsSupplier;
import com.sun.star.sdb.XReportDocumentsSupplier;
import com.sun.star.sdb.tools.XConnectionTools;
import com.sun.star.sdbc.SQLException;
import com.sun.star.sdbc.XConnection;
import com.sun.star.sdbc.XDataSource;
import com.sun.star.sdbc.XDatabaseMetaData;
import com.sun.star.sdbc.XResultSet;
import com.sun.star.sdbc.XRow;
import com.sun.star.sdbcx.XColumnsSupplier;
import com.sun.star.sdbcx.XTablesSupplier;
import com.sun.star.task.XInteractionHandler;
import com.sun.star.ucb.XSimpleFileAccess;
import com.sun.star.ui.dialogs.XExecutableDialog;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.XCloseable;
import com.sun.star.util.XNumberFormatsSupplier;
import com.sun.star.wizards.common.Configuration;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.FileAccess;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.NamedValueCollection;
import com.sun.star.wizards.common.NumberFormatter;
import com.sun.star.wizards.common.Properties;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.common.Resource;
import com.sun.star.wizards.common.SystemDialog;
import com.sun.star.wizards.db.SQLQueryComposer;
import com.sun.star.wizards.db.TypeInspector;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DBMetaData {
    private XNameAccess xQueryNames;
    public XDatabaseMetaData xDBMetaData;
    private XDataSource m_dataSource;
    private XPropertySet m_dataSourceSettings;
    private XOfficeDatabaseDocument xModel;
    private XPropertySet xDataSourcePropertySet;
    private ArrayList<CommandObject> CommandObjects = new ArrayList(1);
    private Locale aLocale;
    public String DataSourceName;
    public XConnection DBConnection;
    private XConnectionTools m_connectionTools;
    public XMultiServiceFactory xMSF;
    private XComponent xConnectionComponent;
    private XNameAccess xNameAccess;
    private XInterface xDatabaseContext;
    private XWindowPeer xWindowPeer;
    private String[] TableNames = new String[0];
    private String[] QueryNames = new String[0];
    protected int[][] WidthList;
    protected static final int[] NumericTypes = new int[]{-6, -5, 2, 3, 4, 5, 6, 7, 8};
    protected static final int[] BinaryTypes = new int[]{-2, -3, -4, 2004, 0, 2000, 2001, 2002, 2003, 2005, 2006};
    private int iMaxColumnsInSelect;
    private int iMaxColumnNameLength = -1;
    private int iMaxTableNameLength = -1;
    private boolean bPasswordIsRequired;
    private static final int NOLIMIT = 9999999;
    protected static final int RID_DB_COMMON = 1000;
    private static final int INVALID = 9999999;
    public TypeInspector oTypeInspector;
    private NumberFormatter oNumberFormatter = null;
    private long lDateCorrection = 9999999L;
    private boolean bdisposeConnection = false;

    public XPropertySet getDataSourcePropertySet() {
        return this.xDataSourcePropertySet;
    }

    public DBMetaData(XMultiServiceFactory xMSF) {
        this.getInterfaces(xMSF);
        this.InitializeWidthList();
    }

    public NumberFormatter getNumberFormatter() {
        if (this.oNumberFormatter == null) {
            try {
                XNumberFormatsSupplier xNumberFormatsSupplier = (XNumberFormatsSupplier)AnyConverter.toObject(XNumberFormatsSupplier.class, (Object)this.xDataSourcePropertySet.getPropertyValue("NumberFormatsSupplier"));
                this.aLocale = Configuration.getLocale(this.xMSF);
                this.oNumberFormatter = new NumberFormatter(this.xMSF, xNumberFormatsSupplier, this.aLocale);
                this.lDateCorrection = this.oNumberFormatter.getNullDateCorrection();
            }
            catch (Exception e) {
                Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, e);
            }
        }
        return this.oNumberFormatter;
    }

    public long getNullDateCorrection() {
        if (this.lDateCorrection == 9999999L) {
            if (this.oNumberFormatter == null) {
                this.oNumberFormatter = this.getNumberFormatter();
            }
            this.lDateCorrection = this.oNumberFormatter.getNullDateCorrection();
        }
        return this.lDateCorrection;
    }

    private void getInterfaces(XMultiServiceFactory xMSF) {
        try {
            this.xMSF = xMSF;
            this.xDatabaseContext = (XInterface)xMSF.createInstance("com.sun.star.sdb.DatabaseContext");
            this.xNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)this.xDatabaseContext);
            this.xNameAccess.getElementNames();
        }
        catch (Exception e) {
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    public boolean hasTableByName(String _stablename) {
        return this.getTableNamesAsNameAccess().hasByName(_stablename);
    }

    public void setTableByName(String _tableName) {
        CommandObject oTableObject = new CommandObject(_tableName, 0);
        this.CommandObjects.add(oTableObject);
    }

    public CommandObject getTableByName(String _tablename) {
        return this.getCommandByName(_tablename, 0);
    }

    public CommandObject getQueryByName(String _queryname) {
        return this.getCommandByName(_queryname, 1);
    }

    public CommandObject getCommandByName(String _commandname, int _commandtype) {
        CommandObject oCommand = null;
        for (int i = 0; i < this.CommandObjects.size(); ++i) {
            oCommand = this.CommandObjects.get(i);
            if (!oCommand.Name.equals(_commandname) || oCommand.CommandType != _commandtype) continue;
            return oCommand;
        }
        if (oCommand == null) {
            oCommand = new CommandObject(_commandname, _commandtype);
            this.CommandObjects.add(oCommand);
        }
        return oCommand;
    }

    public void setQueryByName(String _QueryName) {
        CommandObject oQueryObject = new CommandObject(_QueryName, 1);
        this.CommandObjects.add(oQueryObject);
    }

    public boolean hasEscapeProcessing(XPropertySet _xQueryPropertySet) {
        boolean bHasEscapeProcessing = false;
        try {
            if (_xQueryPropertySet.getPropertySetInfo().hasPropertyByName("EscapeProcessing")) {
                bHasEscapeProcessing = AnyConverter.toBoolean((Object)_xQueryPropertySet.getPropertyValue("EscapeProcessing"));
            }
        }
        catch (Exception e) {
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, e);
        }
        return bHasEscapeProcessing;
    }

    private XNameAccess getQueryNamesAsNameAccess() {
        XQueriesSupplier xDBQueries = (XQueriesSupplier)UnoRuntime.queryInterface(XQueriesSupplier.class, (Object)this.DBConnection);
        this.xQueryNames = xDBQueries.getQueries();
        return this.xQueryNames;
    }

    public XNameAccess getTableNamesAsNameAccess() {
        XTablesSupplier xDBTables = (XTablesSupplier)UnoRuntime.queryInterface(XTablesSupplier.class, (Object)this.DBConnection);
        return xDBTables.getTables();
    }

    public String[] getQueryNames() {
        if (this.QueryNames != null && this.QueryNames.length > 0) {
            return this.QueryNames;
        }
        this.QueryNames = this.getQueryNamesAsNameAccess().getElementNames();
        return this.QueryNames;
    }

    public String[] getTableNames() {
        if (this.TableNames != null && this.TableNames.length > 0) {
            return this.TableNames;
        }
        this.TableNames = this.getTableNamesAsNameAccess().getElementNames();
        return this.TableNames;
    }

    private void InitializeWidthList() {
        this.WidthList = new int[17][2];
        this.WidthList[0][0] = -7;
        this.WidthList[1][0] = 16;
        this.WidthList[2][0] = -6;
        this.WidthList[3][0] = -5;
        this.WidthList[4][0] = -1;
        this.WidthList[5][0] = 1;
        this.WidthList[6][0] = 2;
        this.WidthList[7][0] = 3;
        this.WidthList[8][0] = 4;
        this.WidthList[9][0] = 5;
        this.WidthList[10][0] = 6;
        this.WidthList[11][0] = 7;
        this.WidthList[12][0] = 8;
        this.WidthList[13][0] = 12;
        this.WidthList[14][0] = 91;
        this.WidthList[15][0] = 92;
        this.WidthList[16][0] = 93;
    }

    public boolean isBinaryDataType(int _itype) {
        if (NumericTypes == null) {
            this.InitializeWidthList();
        }
        return JavaTools.FieldInIntTable(BinaryTypes, _itype) > -1;
    }

    public int getMaxTablesInSelect() {
        try {
            int itablecount = this.xDBMetaData.getMaxTablesInSelect();
            if (itablecount == 0) {
                return 9999999;
            }
            return itablecount;
        }
        catch (SQLException e) {
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, e);
            return -1;
        }
    }

    public int getMaxColumnsInSelect() {
        return this.iMaxColumnsInSelect;
    }

    private void setMaxColumnsInSelect() throws SQLException {
        this.iMaxColumnsInSelect = this.xDBMetaData.getMaxColumnsInSelect();
        if (this.iMaxColumnsInSelect == 0) {
            this.iMaxColumnsInSelect = 9999999;
        }
    }

    public int getMaxColumnsInTable() throws SQLException {
        int iMaxColumnsInTable = this.xDBMetaData.getMaxColumnsInTable();
        if (iMaxColumnsInTable == 0) {
            iMaxColumnsInTable = 9999999;
        }
        return iMaxColumnsInTable;
    }

    private void getDataSourceObjects() throws Exception {
        try {
            this.xDBMetaData = this.DBConnection.getMetaData();
            this.getDataSourceInterfaces();
            this.setMaxColumnsInSelect();
        }
        catch (SQLException e) {
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    private void ensureDataSourceSettings() throws UnknownPropertyException, WrappedTargetException {
        if (this.m_dataSourceSettings != null) {
            return;
        }
        XPropertySet dataSourceProperties = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.getDataSource());
        this.m_dataSourceSettings = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)dataSourceProperties.getPropertyValue("Settings"));
    }

    public boolean isSQL92CheckEnabled() {
        boolean isSQL92CheckEnabled = false;
        try {
            this.ensureDataSourceSettings();
            isSQL92CheckEnabled = AnyConverter.toBoolean((Object)this.m_dataSourceSettings.getPropertyValue("EnableSQL92Check"));
        }
        catch (Exception e) {
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, e);
        }
        return isSQL92CheckEnabled;
    }

    public XDataSource getDataSource() {
        if (this.m_dataSource == null) {
            try {
                Object oDataSource = this.xNameAccess.getByName(this.DataSourceName);
                this.m_dataSource = (XDataSource)UnoRuntime.queryInterface(XDataSource.class, (Object)oDataSource);
            }
            catch (NoSuchElementException noSuchElementException) {
            }
            catch (WrappedTargetException wrappedTargetException) {
                // empty catch block
            }
        }
        return this.m_dataSource;
    }

    private void setDataSourceByName(String _DataSourceName) {
        try {
            this.DataSourceName = _DataSourceName;
            this.getDataSourceInterfaces();
            XDocumentDataSource xDocu = (XDocumentDataSource)UnoRuntime.queryInterface(XDocumentDataSource.class, (Object)this.getDataSource());
            if (xDocu != null) {
                this.xModel = xDocu.getDatabaseDocument();
            }
        }
        catch (Exception e) {
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    private void getDataSourceInterfaces() throws Exception {
        this.xDataSourcePropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.getDataSource());
        this.bPasswordIsRequired = (Boolean)this.xDataSourcePropertySet.getPropertyValue("IsPasswordRequired");
    }

    public boolean getConnection(PropertyValue[] curproperties) {
        try {
            XConnection xConnection = null;
            if (Properties.hasPropertyValue(curproperties, PropertyNames.ACTIVE_CONNECTION)) {
                xConnection = (XConnection)UnoRuntime.queryInterface(XConnection.class, (Object)Properties.getPropertyValue(curproperties, PropertyNames.ACTIVE_CONNECTION));
                if (xConnection != null) {
                    XPropertySet xPSet;
                    XChild child = (XChild)UnoRuntime.queryInterface(XChild.class, (Object)xConnection);
                    this.m_dataSource = (XDataSource)UnoRuntime.queryInterface(XDataSource.class, (Object)child.getParent());
                    XDocumentDataSource xDocu = (XDocumentDataSource)UnoRuntime.queryInterface(XDocumentDataSource.class, (Object)this.m_dataSource);
                    if (xDocu != null) {
                        this.xModel = xDocu.getDatabaseDocument();
                    }
                    if ((xPSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.m_dataSource)) != null) {
                        this.DataSourceName = AnyConverter.toString((Object)xPSet.getPropertyValue(PropertyNames.PROPERTY_NAME));
                    }
                    return this.getConnection(xConnection);
                }
                this.bdisposeConnection = true;
            } else {
                this.bdisposeConnection = true;
            }
            if (Properties.hasPropertyValue(curproperties, "DataSourceName")) {
                String sDataSourceName = AnyConverter.toString((Object)Properties.getPropertyValue(curproperties, "DataSourceName"));
                return this.getConnection(sDataSourceName);
            }
            if (Properties.hasPropertyValue(curproperties, "DataSource")) {
                this.m_dataSource = (XDataSource)UnoRuntime.queryInterface(XDataSource.class, (Object)Properties.getPropertyValue(curproperties, "DataSource"));
                XDocumentDataSource xDocu = (XDocumentDataSource)UnoRuntime.queryInterface(XDocumentDataSource.class, (Object)this.m_dataSource);
                if (xDocu != null) {
                    this.xModel = xDocu.getDatabaseDocument();
                }
                return this.getConnection(this.m_dataSource);
            }
            if (Properties.hasPropertyValue(curproperties, "DatabaseLocation")) {
                String sDataSourceName = AnyConverter.toString((Object)Properties.getPropertyValue(curproperties, "DatabaseLocation"));
                return this.getConnection(sDataSourceName);
            }
        }
        catch (IllegalArgumentException e) {
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, e);
        }
        catch (UnknownPropertyException e) {
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, e);
        }
        catch (WrappedTargetException e) {
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, e);
        }
        return false;
    }

    private boolean getConnection(String _DataSourceName) {
        this.setDataSourceByName(_DataSourceName);
        return this.getConnection(this.getDataSource());
    }

    private boolean getConnection(XConnection _DBConnection) {
        try {
            this.DBConnection = _DBConnection;
            this.m_connectionTools = (XConnectionTools)UnoRuntime.queryInterface(XConnectionTools.class, (Object)this.DBConnection);
            this.getDataSourceObjects();
            return true;
        }
        catch (Exception e) {
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, e);
            return false;
        }
    }

    private boolean getConnection(XDataSource _dataSource) {
        Resource oResource = new Resource(this.xMSF, "dbw");
        try {
            int iMsg = 0;
            boolean bgetConnection = false;
            if (this.DBConnection != null) {
                this.xConnectionComponent.dispose();
            }
            this.getDataSourceInterfaces();
            if (!this.bPasswordIsRequired) {
                this.DBConnection = _dataSource.getConnection(PropertyNames.EMPTY_STRING, PropertyNames.EMPTY_STRING);
                bgetConnection = true;
            } else {
                XInteractionHandler xInteractionHandler = (XInteractionHandler)UnoRuntime.queryInterface(XInteractionHandler.class, (Object)this.xMSF.createInstance("com.sun.star.task.InteractionHandler"));
                boolean bExitLoop = true;
                do {
                    XCompletedConnection xCompleted2 = (XCompletedConnection)UnoRuntime.queryInterface(XCompletedConnection.class, (Object)_dataSource);
                    try {
                        this.DBConnection = xCompleted2.connectWithCompletion(xInteractionHandler);
                        boolean bl = bgetConnection = this.DBConnection != null;
                        if (bgetConnection) continue;
                        bExitLoop = true;
                    }
                    catch (Exception exception) {
                        String sMsgNoConnection = oResource.getResText(1014);
                        iMsg = this.showMessageBox("QueryBox", 0x4000000, sMsgNoConnection);
                        bExitLoop = iMsg == 0;
                        bgetConnection = false;
                    }
                } while (!bExitLoop);
            }
            if (!bgetConnection) {
                String sMsgConnectionImpossible = oResource.getResText(1035);
                this.showMessageBox("ErrorBox", 0x400000, sMsgConnectionImpossible);
            } else {
                this.xConnectionComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)this.DBConnection);
                this.m_connectionTools = (XConnectionTools)UnoRuntime.queryInterface(XConnectionTools.class, (Object)this.DBConnection);
                this.getDataSourceObjects();
            }
            return bgetConnection;
        }
        catch (Exception e) {
            String sMsgConnectionImpossible = oResource.getResText(1035);
            this.showMessageBox("ErrorBox", 0x400000, sMsgConnectionImpossible);
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, e);
            return false;
        }
    }

    public int getMaxColumnNameLength() {
        try {
            if (this.iMaxColumnNameLength <= 0) {
                this.iMaxColumnNameLength = this.xDBMetaData.getMaxColumnNameLength();
            }
            return this.iMaxColumnNameLength;
        }
        catch (SQLException e) {
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, e);
            return 0;
        }
    }

    public int getMaxTableNameLength() {
        try {
            if (this.iMaxTableNameLength <= 0) {
                this.iMaxTableNameLength = this.xDBMetaData.getMaxTableNameLength();
            }
            return this.iMaxTableNameLength;
        }
        catch (SQLException e) {
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, e);
            return 0;
        }
    }

    public boolean supportsPrimaryKeys() {
        boolean supportsPrimaryKeys = false;
        try {
            this.ensureDataSourceSettings();
            Any primaryKeySupport = (Any)this.m_dataSourceSettings.getPropertyValue("PrimaryKeySupport");
            supportsPrimaryKeys = AnyConverter.isVoid((Object)primaryKeySupport) ? this.supportsCoreSQLGrammar() : AnyConverter.toBoolean((Object)primaryKeySupport);
        }
        catch (Exception ex) {
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, ex);
        }
        return supportsPrimaryKeys;
    }

    private boolean supportsCoreSQLGrammar() {
        try {
            return this.xDBMetaData.supportsCoreSQLGrammar();
        }
        catch (SQLException e) {
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, e);
            return false;
        }
    }

    public boolean supportsQueriesInFrom() throws SQLException {
        return this.m_connectionTools.getDataSourceMetaData().supportsQueriesInFrom();
    }

    public String suggestName(int i_objectType, String i_baseName) throws IllegalArgumentException, SQLException {
        return this.m_connectionTools.getObjectNames().suggestName(i_objectType, i_baseName);
    }

    public boolean createQuery(SQLQueryComposer _oSQLQueryComposer, String _QueryName) {
        try {
            XQueryDefinitionsSupplier xQueryDefinitionsSuppl = (XQueryDefinitionsSupplier)UnoRuntime.queryInterface(XQueryDefinitionsSupplier.class, (Object)this.m_dataSource);
            XNameAccess xQueryDefs = xQueryDefinitionsSuppl.getQueryDefinitions();
            XSingleServiceFactory xSSFQueryDefs = (XSingleServiceFactory)UnoRuntime.queryInterface(XSingleServiceFactory.class, (Object)xQueryDefs);
            Object oQuery = xSSFQueryDefs.createInstance();
            XPropertySet xPSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)oQuery);
            String s = _oSQLQueryComposer.m_xQueryAnalyzer.getQuery();
            xPSet.setPropertyValue(PropertyNames.COMMAND, (Object)s);
            XNameContainer xNameCont = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)xQueryDefs);
            this.m_connectionTools.getObjectNames().checkNameForCreate(1, _QueryName);
            xNameCont.insertByName(_QueryName, oQuery);
            return true;
        }
        catch (WrappedTargetException exception) {
            SQLException sqlError = null;
            try {
                sqlError = (SQLException)((Object)exception.TargetException);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            if (sqlError != null) {
                this.callSQLErrorMessageDialog(sqlError, null);
                return false;
            }
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, exception);
        }
        catch (SQLException e) {
            this.callSQLErrorMessageDialog(e, null);
            return false;
        }
        catch (Exception e) {
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, e);
        }
        return false;
    }

    public void dispose() {
        if (this.DBConnection != null && this.bdisposeConnection) {
            this.xConnectionComponent.dispose();
        }
    }

    public XHierarchicalNameAccess getReportDocuments() {
        XReportDocumentsSupplier xReportDocumentSuppl = (XReportDocumentsSupplier)UnoRuntime.queryInterface(XReportDocumentsSupplier.class, (Object)this.xModel);
        xReportDocumentSuppl.getReportDocuments();
        return (XHierarchicalNameAccess)UnoRuntime.queryInterface(XHierarchicalNameAccess.class, (Object)xReportDocumentSuppl.getReportDocuments());
    }

    public XHierarchicalNameAccess getFormDocuments() {
        XFormDocumentsSupplier xFormDocumentSuppl = (XFormDocumentsSupplier)UnoRuntime.queryInterface(XFormDocumentsSupplier.class, (Object)this.xModel);
        return (XHierarchicalNameAccess)UnoRuntime.queryInterface(XHierarchicalNameAccess.class, (Object)xFormDocumentSuppl.getFormDocuments());
    }

    public boolean hasFormDocumentByName(String _sFormName) {
        XFormDocumentsSupplier xFormDocumentSuppl = (XFormDocumentsSupplier)UnoRuntime.queryInterface(XFormDocumentsSupplier.class, (Object)this.xModel);
        XNameAccess xFormNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)xFormDocumentSuppl.getFormDocuments());
        return xFormNameAccess.hasByName(_sFormName);
    }

    public void addFormDocument(XComponent _xComponent) {
        XHierarchicalNameAccess _xFormDocNameAccess = this.getFormDocuments();
        this.addDatabaseDocument(_xComponent, _xFormDocNameAccess, false);
    }

    public void addReportDocument(XComponent _xComponent, boolean _bcreatedynamicreport) {
        XHierarchicalNameAccess xReportDocNameAccess = this.getReportDocuments();
        this.addDatabaseDocument(_xComponent, xReportDocNameAccess, _bcreatedynamicreport);
    }

    private void addDatabaseDocument(XComponent _xComponent, XHierarchicalNameAccess _xDocNameAccess, boolean i_createTemplate) {
        try {
            XModel xDocumentModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)_xComponent);
            String documentURL = xDocumentModel.getURL();
            String basename = FileAccess.getBasename(documentURL, "/");
            XCloseable xCloseable = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)_xComponent);
            xCloseable.close(false);
            NamedValueCollection creationArgs = new NamedValueCollection();
            creationArgs.put(PropertyNames.PROPERTY_NAME, basename);
            creationArgs.put(PropertyNames.URL, documentURL);
            creationArgs.put("AsTemplate", i_createTemplate);
            XMultiServiceFactory xDocMSF = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)_xDocNameAccess);
            Object oDBDocument = xDocMSF.createInstanceWithArguments("com.sun.star.sdb.DocumentDefinition", (Object[])creationArgs.getPropertyValues());
            XHierarchicalNameContainer xHier = (XHierarchicalNameContainer)UnoRuntime.queryInterface(XHierarchicalNameContainer.class, (Object)_xDocNameAccess);
            String sdocname = Desktop.getUniqueName(_xDocNameAccess, basename);
            xHier.insertByHierarchicalName(sdocname, oDBDocument);
            XInterface xInterface = (XInterface)this.xMSF.createInstance("com.sun.star.ucb.SimpleFileAccess");
            XSimpleFileAccess xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, (Object)xInterface);
            xSimpleFileAccess.kill(documentURL);
        }
        catch (Exception e) {
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    public void createTypeInspector() throws SQLException {
        this.oTypeInspector = new TypeInspector(this.xDBMetaData.getTypeInfo());
    }

    public TypeInspector getDBDataTypeInspector() {
        return this.oTypeInspector;
    }

    private String[] StringsFromResultSet(XResultSet _xResultSet, int _icol) {
        String[] sColValues = null;
        if (_xResultSet == null) {
            return sColValues;
        }
        try {
            XRow xRow = (XRow)UnoRuntime.queryInterface(XRow.class, (Object)_xResultSet);
            ArrayList<String> aColVector = new ArrayList<String>();
            while (_xResultSet.next()) {
                aColVector.add(xRow.getString(_icol));
            }
            sColValues = new String[aColVector.size()];
            aColVector.toArray(sColValues);
        }
        catch (SQLException e) {
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, e);
        }
        return sColValues;
    }

    public String[] getCatalogNames() {
        try {
            XResultSet xResultSet = this.xDBMetaData.getCatalogs();
            return this.StringsFromResultSet(xResultSet, 1);
        }
        catch (SQLException e) {
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, e);
            return null;
        }
    }

    public String[] getSchemaNames() {
        try {
            XResultSet xResultSet = this.xDBMetaData.getSchemas();
            return this.StringsFromResultSet(xResultSet, 1);
        }
        catch (SQLException e) {
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, e);
            return null;
        }
    }

    public boolean storeDatabaseDocumentToTempPath(XComponent _xcomponent, String _storename) {
        try {
            String storepath = FileAccess.getOfficePath(this.xMSF, "Temp") + "/" + _storename;
            XStorable xStoreable = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)_xcomponent);
            PropertyValue[] oStoreProperties = new PropertyValue[]{Properties.createProperty("FilterName", "writer8")};
            storepath = storepath + ".odt";
            xStoreable.storeAsURL(storepath, oStoreProperties);
            return true;
        }
        catch (Exception e) {
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, e);
            return false;
        }
    }

    public int showMessageBox(String windowServiceName, int windowAttribute, String MessageText) {
        if (this.getWindowPeer() != null) {
            return SystemDialog.showMessageBox(this.xMSF, this.xWindowPeer, windowServiceName, windowAttribute, MessageText);
        }
        return SystemDialog.showMessageBox(this.xMSF, windowServiceName, windowAttribute, MessageText);
    }

    private XWindowPeer getWindowPeer() {
        return this.xWindowPeer;
    }

    public void setWindowPeer(XWindowPeer windowPeer) {
        this.xWindowPeer = windowPeer;
    }

    public void callSQLErrorMessageDialog(SQLException oSQLException, XWindow _xWindow) {
        try {
            Object oDialog = this.xMSF.createInstance("com.sun.star.sdb.ErrorMessageDialog");
            XInitialization xInitialization = (XInitialization)UnoRuntime.queryInterface(XInitialization.class, (Object)oDialog);
            Object[] aPropertyValue = new PropertyValue[]{Properties.createProperty("SQLException", (Object)oSQLException), Properties.createProperty("ParentWindow", _xWindow)};
            xInitialization.initialize(aPropertyValue);
            XExecutableDialog xExecutableDialog = (XExecutableDialog)UnoRuntime.queryInterface(XExecutableDialog.class, (Object)oDialog);
            xExecutableDialog.execute();
        }
        catch (com.sun.star.uno.Exception ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "error calling the error dialog", ex);
        }
    }

    public void finish() {
        this.xQueryNames = null;
        this.xNameAccess = null;
        this.xDatabaseContext = null;
        this.xDBMetaData = null;
        this.m_dataSource = null;
        this.xModel = null;
        this.xDataSourcePropertySet = null;
        this.xWindowPeer = null;
        this.DBConnection = null;
        this.m_connectionTools = null;
        this.xMSF = null;
        this.xConnectionComponent = null;
        this.CommandObjects = null;
    }

    public class CommandObject {
        private XNameAccess xColumns;
        private XPropertySet xPropertySet;
        private String Name;
        private int CommandType;

        private CommandObject(String _CommandName, int _CommandType) {
            try {
                this.Name = _CommandName;
                this.CommandType = _CommandType;
                Object oCommand = this.CommandType == 0 ? DBMetaData.this.getTableNamesAsNameAccess().getByName(this.Name) : DBMetaData.this.getQueryNamesAsNameAccess().getByName(this.Name);
                XColumnsSupplier xCommandCols = (XColumnsSupplier)UnoRuntime.queryInterface(XColumnsSupplier.class, (Object)oCommand);
                this.xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)oCommand);
                this.xColumns = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)xCommandCols.getColumns());
            }
            catch (Exception e) {
                Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, e);
            }
        }

        public XNameAccess getColumns() {
            return this.xColumns;
        }

        public String getName() {
            return this.Name;
        }

        public XPropertySet getPropertySet() {
            return this.xPropertySet;
        }
    }
}

