/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.view.AbstractMultipleOptionsBaseTableModel;
import org.zaproxy.zap.view.MultipleOptionsTablePanel;

public abstract class AbstractMultipleOptionsBaseTablePanel<E>
extends MultipleOptionsTablePanel {
    protected static final long serialVersionUID = -7609757285865562636L;
    protected static final String ADD_BUTTON_LABEL = Constant.messages.getString("multiple.options.panel.add.button.label");
    protected static final String MODIFY_BUTTON_LABEL = Constant.messages.getString("multiple.options.panel.modify.button.label");
    protected static final String REMOVE_BUTTON_LABEL = Constant.messages.getString("multiple.options.panel.remove.button.label");
    protected static final String REMOVE_WO_CONFIRMATION_CHECKBOX_LABEL = Constant.messages.getString("multiple.options.panel.removeWithoutConfirmation.checkbox.label");
    protected JButton addButton;
    protected JButton modifyButton;
    protected JButton removeButton;
    protected AbstractMultipleOptionsBaseTableModel<E> model;
    protected GridBagConstraints gbcFooterPanel;
    protected JCheckBox removeWithoutConfirmationCheckBox;

    public AbstractMultipleOptionsBaseTablePanel(AbstractMultipleOptionsBaseTableModel<E> abstractMultipleOptionsBaseTableModel) {
        this(abstractMultipleOptionsBaseTableModel, true);
    }

    protected AbstractMultipleOptionsBaseTablePanel(AbstractMultipleOptionsBaseTableModel<E> abstractMultipleOptionsBaseTableModel, boolean bl) {
        super(abstractMultipleOptionsBaseTableModel);
        this.getFooterPanel().setLayout(new GridBagLayout());
        this.gbcFooterPanel = new GridBagConstraints();
        this.gbcFooterPanel.gridx = 0;
        this.gbcFooterPanel.weightx = 1.0;
        this.gbcFooterPanel.weighty = 1.0;
        this.gbcFooterPanel.anchor = 21;
        this.addFooterPanelComponent(this.getRemoveWithoutConfirmationCheckBox());
        this.model = abstractMultipleOptionsBaseTableModel;
        this.addButton = new JButton(ADD_BUTTON_LABEL);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object e = AbstractMultipleOptionsBaseTablePanel.this.showAddDialogue();
                if (e != null) {
                    AbstractMultipleOptionsBaseTablePanel.this.getMultipleOptionsModel().addElement(e);
                }
            }
        });
        if (bl) {
            this.modifyButton = new JButton(MODIFY_BUTTON_LABEL);
            this.modifyButton.setEnabled(false);
            this.modifyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractMultipleOptionsBaseTablePanel.this.modifyElement(AbstractMultipleOptionsBaseTablePanel.this.getSelectedRow());
                }
            });
        }
        this.removeButton = new JButton(REMOVE_BUTTON_LABEL);
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = AbstractMultipleOptionsBaseTablePanel.this.getSelectedRow();
                if (!AbstractMultipleOptionsBaseTablePanel.this.isRemoveWithoutConfirmation() && !AbstractMultipleOptionsBaseTablePanel.this.showRemoveDialogue(AbstractMultipleOptionsBaseTablePanel.this.getMultipleOptionsModel().getElement(n))) {
                    return;
                }
                AbstractMultipleOptionsBaseTablePanel.this.getMultipleOptionsModel().removeElement(n);
            }
        });
        this.addButton(this.addButton);
        if (bl) {
            this.addButton(this.modifyButton);
        }
        this.addButton(this.removeButton);
        this.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    AbstractMultipleOptionsBaseTablePanel.this.selectionChanged(AbstractMultipleOptionsBaseTablePanel.this.getTable().getSelectionModel().getMinSelectionIndex() >= 0);
                }
            }
        });
        if (bl) {
            this.getTable().addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    Point point;
                    JXTable jXTable;
                    int n;
                    if (mouseEvent.getClickCount() == 2 && AbstractMultipleOptionsBaseTablePanel.this.modifyButton != null && AbstractMultipleOptionsBaseTablePanel.this.modifyButton.isEnabled() && (n = (jXTable = (JXTable)mouseEvent.getSource()).rowAtPoint(point = mouseEvent.getPoint())) >= 0) {
                        AbstractMultipleOptionsBaseTablePanel.this.modifyElement(AbstractMultipleOptionsBaseTablePanel.this.getTable().convertRowIndexToModel(n));
                    }
                }
            });
        }
    }

    private void modifyElement(int n) {
        E e = this.showModifyDialogue(this.getMultipleOptionsModel().getElement(n));
        if (e != null) {
            this.getMultipleOptionsModel().modifyElement(n, e);
        }
    }

    protected void selectionChanged(boolean bl) {
        if (this.modifyButton != null) {
            this.modifyButton.setEnabled(bl);
        }
        this.removeButton.setEnabled(bl);
    }

    public AbstractMultipleOptionsBaseTablePanel(TableModel tableModel) {
        super(tableModel);
    }

    @Override
    public void setComponentEnabled(boolean bl) {
        boolean bl2;
        super.setComponentEnabled(bl);
        this.addButton.setEnabled(bl);
        this.removeWithoutConfirmationCheckBox.setEnabled(bl);
        boolean bl3 = bl2 = bl && this.getTable().getSelectionModel().getMinSelectionIndex() >= 0;
        if (this.modifyButton != null) {
            this.modifyButton.setEnabled(bl2);
        }
        this.removeButton.setEnabled(bl2);
    }

    public final void addFooterPanelComponent(JComponent jComponent) {
        this.getFooterPanel().add((Component)jComponent, this.gbcFooterPanel);
    }

    public boolean isRemoveWithoutConfirmation() {
        return this.getRemoveWithoutConfirmationCheckBox().isSelected();
    }

    public void setRemoveWithoutConfirmation(boolean bl) {
        this.getRemoveWithoutConfirmationCheckBox().setSelected(bl);
    }

    protected String getRemoveWithoutConfirmationLabel() {
        return REMOVE_WO_CONFIRMATION_CHECKBOX_LABEL;
    }

    protected final JCheckBox getRemoveWithoutConfirmationCheckBox() {
        if (this.removeWithoutConfirmationCheckBox == null) {
            this.removeWithoutConfirmationCheckBox = new JCheckBox(this.getRemoveWithoutConfirmationLabel());
        }
        return this.removeWithoutConfirmationCheckBox;
    }

    protected int getSelectedRow() {
        int n = this.getTable().getSelectionModel().getMinSelectionIndex();
        if (n == -1) {
            return -1;
        }
        return this.getTable().convertRowIndexToModel(n);
    }

    protected AbstractMultipleOptionsBaseTableModel<E> getMultipleOptionsModel() {
        return this.model;
    }

    public abstract E showAddDialogue();

    public abstract E showModifyDialogue(E var1);

    public abstract boolean showRemoveDialogue(E var1);
}

