/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.http.netty3.Netty3HttpServerTransport;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.plugins.NetworkPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.netty3.Netty3Transport;
import org.elasticsearch.transport.netty3.Netty3Utils;

public class Netty3Plugin
extends Plugin
implements NetworkPlugin {
    public static final String NETTY_TRANSPORT_NAME = "netty3";
    public static final String NETTY_HTTP_TRANSPORT_NAME = "netty3";

    public List<Setting<?>> getSettings() {
        return Arrays.asList(Netty3HttpServerTransport.SETTING_HTTP_NETTY_MAX_CUMULATION_BUFFER_CAPACITY, Netty3HttpServerTransport.SETTING_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS, Netty3HttpServerTransport.SETTING_HTTP_WORKER_COUNT, Netty3HttpServerTransport.SETTING_HTTP_TCP_NO_DELAY, Netty3HttpServerTransport.SETTING_HTTP_TCP_KEEP_ALIVE, Netty3HttpServerTransport.SETTING_HTTP_TCP_BLOCKING_SERVER, Netty3HttpServerTransport.SETTING_HTTP_TCP_REUSE_ADDRESS, Netty3HttpServerTransport.SETTING_HTTP_TCP_SEND_BUFFER_SIZE, Netty3HttpServerTransport.SETTING_HTTP_TCP_RECEIVE_BUFFER_SIZE, Netty3Transport.WORKER_COUNT, Netty3Transport.NETTY_MAX_CUMULATION_BUFFER_CAPACITY, Netty3Transport.NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS, Netty3Transport.NETTY_RECEIVE_PREDICTOR_SIZE, Netty3Transport.NETTY_RECEIVE_PREDICTOR_MIN, Netty3Transport.NETTY_RECEIVE_PREDICTOR_MAX, Netty3Transport.NETTY_BOSS_COUNT);
    }

    public Map<String, Supplier<Transport>> getTransports(Settings settings, ThreadPool threadPool, BigArrays bigArrays, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NetworkService networkService) {
        return Collections.singletonMap("netty3", () -> new Netty3Transport(settings, threadPool, networkService, bigArrays, namedWriteableRegistry, circuitBreakerService));
    }

    public Map<String, Supplier<HttpServerTransport>> getHttpTransports(Settings settings, ThreadPool threadPool, BigArrays bigArrays, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NamedXContentRegistry xContentRegistry, NetworkService networkService) {
        return Collections.singletonMap("netty3", () -> new Netty3HttpServerTransport(settings, networkService, bigArrays, threadPool, xContentRegistry));
    }

    static {
        Netty3Utils.setup();
    }
}

