/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.get;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.index.mapper.MapperService;

public class GetField
implements Streamable,
ToXContent,
Iterable<Object> {
    private String name;
    private List<Object> values;

    private GetField() {
    }

    public GetField(String name, List<Object> values) {
        this.name = Objects.requireNonNull(name, "name must not be null");
        this.values = Objects.requireNonNull(values, "values must not be null");
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        if (this.values != null && !this.values.isEmpty()) {
            return this.values.get(0);
        }
        return null;
    }

    public List<Object> getValues() {
        return this.values;
    }

    public boolean isMetadataField() {
        return MapperService.isMetadataField(this.name);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.values.iterator();
    }

    public static GetField readGetField(StreamInput in) throws IOException {
        GetField result = new GetField();
        result.readFrom(in);
        return result;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readString();
        int size = in.readVInt();
        this.values = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            this.values.add(in.readGenericValue());
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeVInt(this.values.size());
        for (Object obj : this.values) {
            out.writeGenericValue(obj);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(this.name);
        for (Object value : this.values) {
            builder.value(value);
        }
        builder.endArray();
        return builder;
    }

    public static GetField fromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.currentToken(), parser::getTokenLocation);
        String fieldName = parser.currentName();
        XContentParser.Token token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, token, parser::getTokenLocation);
        ArrayList<Object> values = new ArrayList<Object>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            Object value;
            if (token == XContentParser.Token.VALUE_STRING) {
                value = parser.text();
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                value = parser.numberValue();
            } else if (token == XContentParser.Token.VALUE_BOOLEAN) {
                value = parser.booleanValue();
            } else if (token == XContentParser.Token.VALUE_EMBEDDED_OBJECT) {
                value = new BytesArray(parser.binaryValue());
            } else {
                throw new ParsingException(parser.getTokenLocation(), "Failed to parse object: unsupported token found [" + (Object)((Object)token) + "]", new Object[0]);
            }
            values.add(value);
        }
        return new GetField(fieldName, values);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetField objects = (GetField)o;
        return Objects.equals(this.name, objects.name) && Objects.equals(this.values, objects.values);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.values);
    }

    public String toString() {
        return "GetField{name='" + this.name + '\'' + ", values=" + this.values + '}';
    }
}

