/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.io.IOException;
import java.util.Locale;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.RandomAccessOrds;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;

public enum MultiValueMode implements Writeable
{
    SUM{

        @Override
        protected long pick(SortedNumericDocValues values, long missingValue, int doc) {
            values.setDocument(doc);
            int count = values.count();
            if (count > 0) {
                long total = 0L;
                for (int index = 0; index < count; ++index) {
                    total += values.valueAt(index);
                }
                return total;
            }
            return missingValue;
        }

        @Override
        protected long pick(SortedNumericDocValues values, long missingValue, DocIdSetIterator docItr, int startDoc, int endDoc) {
            try {
                int totalCount = 0;
                long totalValue = 0L;
                int doc = startDoc;
                while (doc < endDoc) {
                    values.setDocument(doc);
                    int count = values.count();
                    for (int index = 0; index < count; ++index) {
                        totalValue += values.valueAt(index);
                    }
                    totalCount += count;
                    doc = docItr.nextDoc();
                }
                return totalCount > 0 ? totalValue : missingValue;
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }

        @Override
        protected double pick(SortedNumericDoubleValues values, double missingValue, int doc) {
            values.setDocument(doc);
            int count = values.count();
            if (count > 0) {
                double total = 0.0;
                for (int index = 0; index < count; ++index) {
                    total += values.valueAt(index);
                }
                return total;
            }
            return missingValue;
        }

        @Override
        protected double pick(SortedNumericDoubleValues values, double missingValue, DocIdSetIterator docItr, int startDoc, int endDoc) {
            try {
                int totalCount = 0;
                double totalValue = 0.0;
                int doc = startDoc;
                while (doc < endDoc) {
                    values.setDocument(doc);
                    int count = values.count();
                    for (int index = 0; index < count; ++index) {
                        totalValue += values.valueAt(index);
                    }
                    totalCount += count;
                    doc = docItr.nextDoc();
                }
                return totalCount > 0 ? totalValue : missingValue;
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }

        @Override
        protected double pick(UnsortedNumericDoubleValues values, double missingValue, int doc) {
            values.setDocument(doc);
            int count = values.count();
            if (count > 0) {
                double total = 0.0;
                for (int index = 0; index < count; ++index) {
                    total += values.valueAt(index);
                }
                return total;
            }
            return missingValue;
        }
    }
    ,
    AVG{

        @Override
        protected long pick(SortedNumericDocValues values, long missingValue, int doc) {
            values.setDocument(doc);
            int count = values.count();
            if (count > 0) {
                long total = 0L;
                for (int index = 0; index < count; ++index) {
                    total += values.valueAt(index);
                }
                return count > 1 ? Math.round((double)total / (double)count) : total;
            }
            return missingValue;
        }

        @Override
        protected long pick(SortedNumericDocValues values, long missingValue, DocIdSetIterator docItr, int startDoc, int endDoc) {
            try {
                int totalCount = 0;
                long totalValue = 0L;
                int doc = startDoc;
                while (doc < endDoc) {
                    values.setDocument(doc);
                    int count = values.count();
                    for (int index = 0; index < count; ++index) {
                        totalValue += values.valueAt(index);
                    }
                    totalCount += count;
                    doc = docItr.nextDoc();
                }
                if (totalCount < 1) {
                    return missingValue;
                }
                return totalCount > 1 ? Math.round((double)totalValue / (double)totalCount) : totalValue;
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }

        @Override
        protected double pick(SortedNumericDoubleValues values, double missingValue, int doc) {
            values.setDocument(doc);
            int count = values.count();
            if (count > 0) {
                double total = 0.0;
                for (int index = 0; index < count; ++index) {
                    total += values.valueAt(index);
                }
                return total / (double)count;
            }
            return missingValue;
        }

        @Override
        protected double pick(SortedNumericDoubleValues values, double missingValue, DocIdSetIterator docItr, int startDoc, int endDoc) {
            try {
                int totalCount = 0;
                double totalValue = 0.0;
                int doc = startDoc;
                while (doc < endDoc) {
                    values.setDocument(doc);
                    int count = values.count();
                    for (int index = 0; index < count; ++index) {
                        totalValue += values.valueAt(index);
                    }
                    totalCount += count;
                    doc = docItr.nextDoc();
                }
                if (totalCount < 1) {
                    return missingValue;
                }
                return totalValue / (double)totalCount;
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }

        @Override
        protected double pick(UnsortedNumericDoubleValues values, double missingValue, int doc) {
            values.setDocument(doc);
            int count = values.count();
            if (count > 0) {
                double total = 0.0;
                for (int index = 0; index < count; ++index) {
                    total += values.valueAt(index);
                }
                return total / (double)count;
            }
            return missingValue;
        }
    }
    ,
    MEDIAN{

        @Override
        protected long pick(SortedNumericDocValues values, long missingValue, int doc) {
            values.setDocument(doc);
            int count = values.count();
            if (count > 0) {
                if (count % 2 == 0) {
                    return Math.round((double)(values.valueAt((count /= 2) - 1) + values.valueAt(count)) / 2.0);
                }
                return values.valueAt(count /= 2);
            }
            return missingValue;
        }

        @Override
        protected double pick(SortedNumericDoubleValues values, double missingValue, int doc) {
            values.setDocument(doc);
            int count = values.count();
            if (count > 0) {
                if (count % 2 == 0) {
                    return (values.valueAt((count /= 2) - 1) + values.valueAt(count)) / 2.0;
                }
                return values.valueAt(count /= 2);
            }
            return missingValue;
        }
    }
    ,
    MIN{

        @Override
        protected long pick(SortedNumericDocValues values, long missingValue, int doc) {
            values.setDocument(doc);
            int count = values.count();
            return count > 0 ? values.valueAt(0) : missingValue;
        }

        @Override
        protected long pick(SortedNumericDocValues values, long missingValue, DocIdSetIterator docItr, int startDoc, int endDoc) {
            try {
                int totalCount = 0;
                long minValue = Long.MAX_VALUE;
                int doc = startDoc;
                while (doc < endDoc) {
                    values.setDocument(doc);
                    int count = values.count();
                    if (count > 0) {
                        minValue = Math.min(minValue, values.valueAt(0));
                    }
                    totalCount += count;
                    doc = docItr.nextDoc();
                }
                return totalCount > 0 ? minValue : missingValue;
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }

        @Override
        protected double pick(SortedNumericDoubleValues values, double missingValue, int doc) {
            values.setDocument(doc);
            int count = values.count();
            return count > 0 ? values.valueAt(0) : missingValue;
        }

        @Override
        protected double pick(SortedNumericDoubleValues values, double missingValue, DocIdSetIterator docItr, int startDoc, int endDoc) {
            try {
                int totalCount = 0;
                double minValue = Double.MAX_VALUE;
                int doc = startDoc;
                while (doc < endDoc) {
                    values.setDocument(doc);
                    int count = values.count();
                    if (count > 0) {
                        minValue = Math.min(minValue, values.valueAt(0));
                    }
                    totalCount += count;
                    doc = docItr.nextDoc();
                }
                return totalCount > 0 ? minValue : missingValue;
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }

        @Override
        protected BytesRef pick(SortedBinaryDocValues values, BytesRef missingValue, int doc) {
            values.setDocument(doc);
            int count = values.count();
            return count > 0 ? values.valueAt(0) : missingValue;
        }

        @Override
        protected BytesRef pick(BinaryDocValues values, BytesRefBuilder builder, DocIdSetIterator docItr, int startDoc, int endDoc) {
            try {
                BytesRefBuilder value = null;
                int doc = startDoc;
                while (doc < endDoc) {
                    BytesRef innerValue = values.get(doc);
                    if (innerValue != null) {
                        if (value == null) {
                            builder.copyBytes(innerValue);
                            value = builder;
                        } else {
                            BytesRef min;
                            BytesRef bytesRef = min = value.get().compareTo(innerValue) <= 0 ? value.get() : innerValue;
                            if (min == innerValue) {
                                value.copyBytes(min);
                            }
                        }
                    }
                    doc = docItr.nextDoc();
                }
                return value == null ? null : value.get();
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }

        @Override
        protected int pick(RandomAccessOrds values, int doc) {
            values.setDocument(doc);
            return values.cardinality() > 0 ? (int)values.ordAt(0) : -1;
        }

        @Override
        protected int pick(SortedDocValues values, DocIdSetIterator docItr, int startDoc, int endDoc) {
            try {
                int ord = -1;
                int doc = startDoc;
                while (doc < endDoc) {
                    int innerOrd = values.getOrd(doc);
                    if (innerOrd != -1) {
                        ord = ord == -1 ? innerOrd : Math.min(ord, innerOrd);
                    }
                    doc = docItr.nextDoc();
                }
                return ord;
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }

        @Override
        protected double pick(UnsortedNumericDoubleValues values, double missingValue, int doc) {
            values.setDocument(doc);
            int count = values.count();
            double min = Double.MAX_VALUE;
            for (int index = 0; index < count; ++index) {
                min = Math.min(values.valueAt(index), min);
            }
            return count > 0 ? min : missingValue;
        }
    }
    ,
    MAX{

        @Override
        protected long pick(SortedNumericDocValues values, long missingValue, int doc) {
            values.setDocument(doc);
            int count = values.count();
            return count > 0 ? values.valueAt(count - 1) : missingValue;
        }

        @Override
        protected long pick(SortedNumericDocValues values, long missingValue, DocIdSetIterator docItr, int startDoc, int endDoc) {
            try {
                int totalCount = 0;
                long maxValue = Long.MIN_VALUE;
                int doc = startDoc;
                while (doc < endDoc) {
                    values.setDocument(doc);
                    int count = values.count();
                    if (count > 0) {
                        maxValue = Math.max(maxValue, values.valueAt(count - 1));
                    }
                    totalCount += count;
                    doc = docItr.nextDoc();
                }
                return totalCount > 0 ? maxValue : missingValue;
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }

        @Override
        protected double pick(SortedNumericDoubleValues values, double missingValue, int doc) {
            values.setDocument(doc);
            int count = values.count();
            return count > 0 ? values.valueAt(count - 1) : missingValue;
        }

        @Override
        protected double pick(SortedNumericDoubleValues values, double missingValue, DocIdSetIterator docItr, int startDoc, int endDoc) {
            try {
                int totalCount = 0;
                double maxValue = Double.MIN_VALUE;
                int doc = startDoc;
                while (doc < endDoc) {
                    values.setDocument(doc);
                    int count = values.count();
                    if (count > 0) {
                        maxValue = Math.max(maxValue, values.valueAt(count - 1));
                    }
                    totalCount += count;
                    doc = docItr.nextDoc();
                }
                return totalCount > 0 ? maxValue : missingValue;
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }

        @Override
        protected BytesRef pick(SortedBinaryDocValues values, BytesRef missingValue, int doc) {
            values.setDocument(doc);
            int count = values.count();
            return count > 0 ? values.valueAt(count - 1) : missingValue;
        }

        @Override
        protected BytesRef pick(BinaryDocValues values, BytesRefBuilder builder, DocIdSetIterator docItr, int startDoc, int endDoc) {
            try {
                BytesRefBuilder value = null;
                int doc = startDoc;
                while (doc < endDoc) {
                    BytesRef innerValue = values.get(doc);
                    if (innerValue != null) {
                        if (value == null) {
                            builder.copyBytes(innerValue);
                            value = builder;
                        } else {
                            BytesRef max;
                            BytesRef bytesRef = max = value.get().compareTo(innerValue) > 0 ? value.get() : innerValue;
                            if (max == innerValue) {
                                value.copyBytes(max);
                            }
                        }
                    }
                    doc = docItr.nextDoc();
                }
                return value == null ? null : value.get();
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }

        @Override
        protected int pick(RandomAccessOrds values, int doc) {
            values.setDocument(doc);
            int count = values.cardinality();
            return count > 0 ? (int)values.ordAt(count - 1) : -1;
        }

        @Override
        protected int pick(SortedDocValues values, DocIdSetIterator docItr, int startDoc, int endDoc) {
            try {
                int ord = -1;
                int doc = startDoc;
                while (doc < endDoc) {
                    int innerOrd = values.getOrd(doc);
                    if (innerOrd != -1) {
                        ord = Math.max(ord, innerOrd);
                    }
                    doc = docItr.nextDoc();
                }
                return ord;
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }

        @Override
        protected double pick(UnsortedNumericDoubleValues values, double missingValue, int doc) {
            values.setDocument(doc);
            int count = values.count();
            double max = Double.MIN_VALUE;
            for (int index = 0; index < count; ++index) {
                max = Math.max(values.valueAt(index), max);
            }
            return count > 0 ? max : missingValue;
        }
    };


    public static MultiValueMode fromString(String sortMode) {
        try {
            return MultiValueMode.valueOf(sortMode.toUpperCase(Locale.ROOT));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal sort mode: " + sortMode);
        }
    }

    public NumericDocValues select(final SortedNumericDocValues values, final long missingValue) {
        final NumericDocValues singleton = DocValues.unwrapSingleton((SortedNumericDocValues)values);
        if (singleton != null) {
            final Bits docsWithField = DocValues.unwrapSingletonBits((SortedNumericDocValues)values);
            if (docsWithField == null || missingValue == 0L) {
                return singleton;
            }
            return new NumericDocValues(){

                public long get(int docID) {
                    long value = singleton.get(docID);
                    if (value == 0L && !docsWithField.get(docID)) {
                        return missingValue;
                    }
                    return value;
                }
            };
        }
        return new NumericDocValues(){

            public long get(int docID) {
                return MultiValueMode.this.pick(values, missingValue, docID);
            }
        };
    }

    protected long pick(SortedNumericDocValues values, long missingValue, int doc) {
        throw new IllegalArgumentException("Unsupported sort mode: " + this);
    }

    public NumericDocValues select(final SortedNumericDocValues values, final long missingValue, final BitSet rootDocs, final DocIdSetIterator innerDocs, int maxDoc) throws IOException {
        if (rootDocs == null || innerDocs == null) {
            return this.select(DocValues.emptySortedNumeric((int)maxDoc), missingValue);
        }
        return new NumericDocValues(){
            int lastSeenRootDoc = 0;
            long lastEmittedValue = missingValue;

            public long get(int rootDoc) {
                assert (rootDocs.get(rootDoc)) : "can only sort root documents";
                assert (rootDoc >= this.lastSeenRootDoc) : "can only evaluate current and upcoming root docs";
                if (rootDoc == this.lastSeenRootDoc) {
                    return this.lastEmittedValue;
                }
                try {
                    int prevRootDoc = rootDocs.prevSetBit(rootDoc - 1);
                    int firstNestedDoc = innerDocs.docID() > prevRootDoc ? innerDocs.docID() : innerDocs.advance(prevRootDoc + 1);
                    this.lastSeenRootDoc = rootDoc;
                    this.lastEmittedValue = MultiValueMode.this.pick(values, missingValue, innerDocs, firstNestedDoc, rootDoc);
                    return this.lastEmittedValue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    protected long pick(SortedNumericDocValues values, long missingValue, DocIdSetIterator docItr, int startDoc, int endDoc) {
        throw new IllegalArgumentException("Unsupported sort mode: " + this);
    }

    public NumericDoubleValues select(final SortedNumericDoubleValues values, final double missingValue) {
        final NumericDoubleValues singleton = FieldData.unwrapSingleton(values);
        if (singleton != null) {
            final Bits docsWithField = FieldData.unwrapSingletonBits(values);
            if (docsWithField == null || missingValue == 0.0) {
                return singleton;
            }
            return new NumericDoubleValues(){

                @Override
                public double get(int docID) {
                    double value = singleton.get(docID);
                    if (value == 0.0 && !docsWithField.get(docID)) {
                        return missingValue;
                    }
                    return value;
                }
            };
        }
        return new NumericDoubleValues(){

            @Override
            public double get(int docID) {
                return MultiValueMode.this.pick(values, missingValue, docID);
            }
        };
    }

    protected double pick(SortedNumericDoubleValues values, double missingValue, int doc) {
        throw new IllegalArgumentException("Unsupported sort mode: " + this);
    }

    public NumericDoubleValues select(final SortedNumericDoubleValues values, final double missingValue, final BitSet rootDocs, final DocIdSetIterator innerDocs, int maxDoc) throws IOException {
        if (rootDocs == null || innerDocs == null) {
            return this.select(FieldData.emptySortedNumericDoubles(maxDoc), missingValue);
        }
        return new NumericDoubleValues(){
            int lastSeenRootDoc = 0;
            double lastEmittedValue = missingValue;

            @Override
            public double get(int rootDoc) {
                assert (rootDocs.get(rootDoc)) : "can only sort root documents";
                assert (rootDoc >= this.lastSeenRootDoc) : "can only evaluate current and upcoming root docs";
                if (rootDoc == this.lastSeenRootDoc) {
                    return this.lastEmittedValue;
                }
                try {
                    int prevRootDoc = rootDocs.prevSetBit(rootDoc - 1);
                    int firstNestedDoc = innerDocs.docID() > prevRootDoc ? innerDocs.docID() : innerDocs.advance(prevRootDoc + 1);
                    this.lastSeenRootDoc = rootDoc;
                    this.lastEmittedValue = MultiValueMode.this.pick(values, missingValue, innerDocs, firstNestedDoc, rootDoc);
                    return this.lastEmittedValue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    protected double pick(SortedNumericDoubleValues values, double missingValue, DocIdSetIterator docItr, int startDoc, int endDoc) {
        throw new IllegalArgumentException("Unsupported sort mode: " + this);
    }

    public BinaryDocValues select(final SortedBinaryDocValues values, final BytesRef missingValue) {
        final BinaryDocValues singleton = FieldData.unwrapSingleton(values);
        if (singleton != null) {
            final Bits docsWithField = FieldData.unwrapSingletonBits(values);
            if (docsWithField == null) {
                return singleton;
            }
            return new BinaryDocValues(){

                public BytesRef get(int docID) {
                    BytesRef value = singleton.get(docID);
                    if (value.length == 0 && !docsWithField.get(docID)) {
                        return missingValue;
                    }
                    return value;
                }
            };
        }
        return new BinaryDocValues(){

            public BytesRef get(int docID) {
                return MultiValueMode.this.pick(values, missingValue, docID);
            }
        };
    }

    protected BytesRef pick(SortedBinaryDocValues values, BytesRef missingValue, int doc) {
        throw new IllegalArgumentException("Unsupported sort mode: " + this);
    }

    public BinaryDocValues select(SortedBinaryDocValues values, final BytesRef missingValue, final BitSet rootDocs, final DocIdSetIterator innerDocs, int maxDoc) throws IOException {
        if (rootDocs == null || innerDocs == null) {
            return this.select(FieldData.emptySortedBinary(maxDoc), missingValue);
        }
        final BinaryDocValues selectedValues = this.select(values, null);
        return new BinaryDocValues(){
            final BytesRefBuilder builder = new BytesRefBuilder();
            int lastSeenRootDoc = 0;
            BytesRef lastEmittedValue = missingValue;

            public BytesRef get(int rootDoc) {
                assert (rootDocs.get(rootDoc)) : "can only sort root documents";
                assert (rootDoc >= this.lastSeenRootDoc) : "can only evaluate current and upcoming root docs";
                if (rootDoc == this.lastSeenRootDoc) {
                    return this.lastEmittedValue;
                }
                try {
                    int prevRootDoc = rootDocs.prevSetBit(rootDoc - 1);
                    int firstNestedDoc = innerDocs.docID() > prevRootDoc ? innerDocs.docID() : innerDocs.advance(prevRootDoc + 1);
                    this.lastSeenRootDoc = rootDoc;
                    this.lastEmittedValue = MultiValueMode.this.pick(selectedValues, this.builder, innerDocs, firstNestedDoc, rootDoc);
                    if (this.lastEmittedValue == null) {
                        this.lastEmittedValue = missingValue;
                    }
                    return this.lastEmittedValue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    protected BytesRef pick(BinaryDocValues values, BytesRefBuilder builder, DocIdSetIterator docItr, int startDoc, int endDoc) {
        throw new IllegalArgumentException("Unsupported sort mode: " + this);
    }

    public SortedDocValues select(final RandomAccessOrds values) {
        if (values.getValueCount() >= Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("fields containing more than 2147483646 unique terms are unsupported");
        }
        SortedDocValues singleton = DocValues.unwrapSingleton((SortedSetDocValues)values);
        if (singleton != null) {
            return singleton;
        }
        return new SortedDocValues(){

            public int getOrd(int docID) {
                return MultiValueMode.this.pick(values, docID);
            }

            public BytesRef lookupOrd(int ord) {
                return values.lookupOrd((long)ord);
            }

            public int getValueCount() {
                return (int)values.getValueCount();
            }
        };
    }

    protected int pick(RandomAccessOrds values, int doc) {
        throw new IllegalArgumentException("Unsupported sort mode: " + this);
    }

    public SortedDocValues select(RandomAccessOrds values, final BitSet rootDocs, final DocIdSetIterator innerDocs) throws IOException {
        if (rootDocs == null || innerDocs == null) {
            return this.select(DocValues.emptySortedSet());
        }
        final SortedDocValues selectedValues = this.select(values);
        return new SortedDocValues(){
            int lastSeenRootDoc = 0;
            int lastEmittedOrd = -1;

            public BytesRef lookupOrd(int ord) {
                return selectedValues.lookupOrd(ord);
            }

            public int getValueCount() {
                return selectedValues.getValueCount();
            }

            public int getOrd(int rootDoc) {
                assert (rootDocs.get(rootDoc)) : "can only sort root documents";
                assert (rootDoc >= this.lastSeenRootDoc) : "can only evaluate current and upcoming root docs";
                if (rootDoc == this.lastSeenRootDoc) {
                    return this.lastEmittedOrd;
                }
                try {
                    int prevRootDoc = rootDocs.prevSetBit(rootDoc - 1);
                    int firstNestedDoc = innerDocs.docID() > prevRootDoc ? innerDocs.docID() : innerDocs.advance(prevRootDoc + 1);
                    this.lastSeenRootDoc = rootDoc;
                    this.lastEmittedOrd = MultiValueMode.this.pick(selectedValues, innerDocs, firstNestedDoc, rootDoc);
                    return this.lastEmittedOrd;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    protected int pick(SortedDocValues values, DocIdSetIterator docItr, int startDoc, int endDoc) {
        throw new IllegalArgumentException("Unsupported sort mode: " + this);
    }

    public NumericDoubleValues select(final UnsortedNumericDoubleValues values, final double missingValue) {
        return new NumericDoubleValues(){

            @Override
            public double get(int docID) {
                return MultiValueMode.this.pick(values, missingValue, docID);
            }
        };
    }

    protected double pick(UnsortedNumericDoubleValues values, double missingValue, int doc) {
        throw new IllegalArgumentException("Unsupported sort mode: " + this);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.ordinal());
    }

    public static MultiValueMode readMultiValueModeFrom(StreamInput in) throws IOException {
        int ordinal = in.readVInt();
        if (ordinal < 0 || ordinal >= MultiValueMode.values().length) {
            throw new IOException("Unknown MultiValueMode ordinal [" + ordinal + "]");
        }
        return MultiValueMode.values()[ordinal];
    }

    public static interface UnsortedNumericDoubleValues {
        public int count();

        public void setDocument(int var1);

        public double valueAt(int var1);
    }
}

