// autogenerated: do not edit!
// generated from gen/*Ops.go

package ssa

import (
	"cmd/internal/obj"
	"cmd/internal/obj/arm"
	"cmd/internal/obj/x86"
)

const (
	BlockInvalid BlockKind = iota

	BlockAMD64EQ
	BlockAMD64NE
	BlockAMD64LT
	BlockAMD64LE
	BlockAMD64GT
	BlockAMD64GE
	BlockAMD64ULT
	BlockAMD64ULE
	BlockAMD64UGT
	BlockAMD64UGE
	BlockAMD64EQF
	BlockAMD64NEF
	BlockAMD64ORD
	BlockAMD64NAN

	BlockARMEQ
	BlockARMNE
	BlockARMLT
	BlockARMLE
	BlockARMGT
	BlockARMGE
	BlockARMULT
	BlockARMULE
	BlockARMUGT
	BlockARMUGE

	BlockPlain
	BlockIf
	BlockCall
	BlockDefer
	BlockCheck
	BlockRet
	BlockRetJmp
	BlockExit
	BlockFirst
)

var blockString = [...]string{
	BlockInvalid: "BlockInvalid",

	BlockAMD64EQ:  "EQ",
	BlockAMD64NE:  "NE",
	BlockAMD64LT:  "LT",
	BlockAMD64LE:  "LE",
	BlockAMD64GT:  "GT",
	BlockAMD64GE:  "GE",
	BlockAMD64ULT: "ULT",
	BlockAMD64ULE: "ULE",
	BlockAMD64UGT: "UGT",
	BlockAMD64UGE: "UGE",
	BlockAMD64EQF: "EQF",
	BlockAMD64NEF: "NEF",
	BlockAMD64ORD: "ORD",
	BlockAMD64NAN: "NAN",

	BlockARMEQ:  "EQ",
	BlockARMNE:  "NE",
	BlockARMLT:  "LT",
	BlockARMLE:  "LE",
	BlockARMGT:  "GT",
	BlockARMGE:  "GE",
	BlockARMULT: "ULT",
	BlockARMULE: "ULE",
	BlockARMUGT: "UGT",
	BlockARMUGE: "UGE",

	BlockPlain:  "Plain",
	BlockIf:     "If",
	BlockCall:   "Call",
	BlockDefer:  "Defer",
	BlockCheck:  "Check",
	BlockRet:    "Ret",
	BlockRetJmp: "RetJmp",
	BlockExit:   "Exit",
	BlockFirst:  "First",
}

func (k BlockKind) String() string { return blockString[k] }

const (
	OpInvalid Op = iota

	OpAMD64ADDSS
	OpAMD64ADDSD
	OpAMD64SUBSS
	OpAMD64SUBSD
	OpAMD64MULSS
	OpAMD64MULSD
	OpAMD64DIVSS
	OpAMD64DIVSD
	OpAMD64MOVSSload
	OpAMD64MOVSDload
	OpAMD64MOVSSconst
	OpAMD64MOVSDconst
	OpAMD64MOVSSloadidx1
	OpAMD64MOVSSloadidx4
	OpAMD64MOVSDloadidx1
	OpAMD64MOVSDloadidx8
	OpAMD64MOVSSstore
	OpAMD64MOVSDstore
	OpAMD64MOVSSstoreidx1
	OpAMD64MOVSSstoreidx4
	OpAMD64MOVSDstoreidx1
	OpAMD64MOVSDstoreidx8
	OpAMD64ADDQ
	OpAMD64ADDL
	OpAMD64ADDQconst
	OpAMD64ADDLconst
	OpAMD64SUBQ
	OpAMD64SUBL
	OpAMD64SUBQconst
	OpAMD64SUBLconst
	OpAMD64MULQ
	OpAMD64MULL
	OpAMD64MULQconst
	OpAMD64MULLconst
	OpAMD64HMULQ
	OpAMD64HMULL
	OpAMD64HMULW
	OpAMD64HMULB
	OpAMD64HMULQU
	OpAMD64HMULLU
	OpAMD64HMULWU
	OpAMD64HMULBU
	OpAMD64AVGQU
	OpAMD64DIVQ
	OpAMD64DIVL
	OpAMD64DIVW
	OpAMD64DIVQU
	OpAMD64DIVLU
	OpAMD64DIVWU
	OpAMD64MODQ
	OpAMD64MODL
	OpAMD64MODW
	OpAMD64MODQU
	OpAMD64MODLU
	OpAMD64MODWU
	OpAMD64ANDQ
	OpAMD64ANDL
	OpAMD64ANDQconst
	OpAMD64ANDLconst
	OpAMD64ORQ
	OpAMD64ORL
	OpAMD64ORQconst
	OpAMD64ORLconst
	OpAMD64XORQ
	OpAMD64XORL
	OpAMD64XORQconst
	OpAMD64XORLconst
	OpAMD64CMPQ
	OpAMD64CMPL
	OpAMD64CMPW
	OpAMD64CMPB
	OpAMD64CMPQconst
	OpAMD64CMPLconst
	OpAMD64CMPWconst
	OpAMD64CMPBconst
	OpAMD64UCOMISS
	OpAMD64UCOMISD
	OpAMD64TESTQ
	OpAMD64TESTL
	OpAMD64TESTW
	OpAMD64TESTB
	OpAMD64TESTQconst
	OpAMD64TESTLconst
	OpAMD64TESTWconst
	OpAMD64TESTBconst
	OpAMD64SHLQ
	OpAMD64SHLL
	OpAMD64SHLQconst
	OpAMD64SHLLconst
	OpAMD64SHRQ
	OpAMD64SHRL
	OpAMD64SHRW
	OpAMD64SHRB
	OpAMD64SHRQconst
	OpAMD64SHRLconst
	OpAMD64SHRWconst
	OpAMD64SHRBconst
	OpAMD64SARQ
	OpAMD64SARL
	OpAMD64SARW
	OpAMD64SARB
	OpAMD64SARQconst
	OpAMD64SARLconst
	OpAMD64SARWconst
	OpAMD64SARBconst
	OpAMD64ROLQconst
	OpAMD64ROLLconst
	OpAMD64ROLWconst
	OpAMD64ROLBconst
	OpAMD64NEGQ
	OpAMD64NEGL
	OpAMD64NOTQ
	OpAMD64NOTL
	OpAMD64BSFQ
	OpAMD64BSFL
	OpAMD64BSFW
	OpAMD64BSRQ
	OpAMD64BSRL
	OpAMD64BSRW
	OpAMD64CMOVQEQconst
	OpAMD64CMOVLEQconst
	OpAMD64CMOVWEQconst
	OpAMD64CMOVQNEconst
	OpAMD64CMOVLNEconst
	OpAMD64CMOVWNEconst
	OpAMD64BSWAPQ
	OpAMD64BSWAPL
	OpAMD64SQRTSD
	OpAMD64SBBQcarrymask
	OpAMD64SBBLcarrymask
	OpAMD64SETEQ
	OpAMD64SETNE
	OpAMD64SETL
	OpAMD64SETLE
	OpAMD64SETG
	OpAMD64SETGE
	OpAMD64SETB
	OpAMD64SETBE
	OpAMD64SETA
	OpAMD64SETAE
	OpAMD64SETEQF
	OpAMD64SETNEF
	OpAMD64SETORD
	OpAMD64SETNAN
	OpAMD64SETGF
	OpAMD64SETGEF
	OpAMD64MOVBQSX
	OpAMD64MOVBQZX
	OpAMD64MOVWQSX
	OpAMD64MOVWQZX
	OpAMD64MOVLQSX
	OpAMD64MOVLQZX
	OpAMD64MOVLconst
	OpAMD64MOVQconst
	OpAMD64CVTTSD2SL
	OpAMD64CVTTSD2SQ
	OpAMD64CVTTSS2SL
	OpAMD64CVTTSS2SQ
	OpAMD64CVTSL2SS
	OpAMD64CVTSL2SD
	OpAMD64CVTSQ2SS
	OpAMD64CVTSQ2SD
	OpAMD64CVTSD2SS
	OpAMD64CVTSS2SD
	OpAMD64PXOR
	OpAMD64LEAQ
	OpAMD64LEAQ1
	OpAMD64LEAQ2
	OpAMD64LEAQ4
	OpAMD64LEAQ8
	OpAMD64MOVBload
	OpAMD64MOVBQSXload
	OpAMD64MOVWload
	OpAMD64MOVWQSXload
	OpAMD64MOVLload
	OpAMD64MOVLQSXload
	OpAMD64MOVQload
	OpAMD64MOVBstore
	OpAMD64MOVWstore
	OpAMD64MOVLstore
	OpAMD64MOVQstore
	OpAMD64MOVOload
	OpAMD64MOVOstore
	OpAMD64MOVBloadidx1
	OpAMD64MOVWloadidx1
	OpAMD64MOVWloadidx2
	OpAMD64MOVLloadidx1
	OpAMD64MOVLloadidx4
	OpAMD64MOVQloadidx1
	OpAMD64MOVQloadidx8
	OpAMD64MOVBstoreidx1
	OpAMD64MOVWstoreidx1
	OpAMD64MOVWstoreidx2
	OpAMD64MOVLstoreidx1
	OpAMD64MOVLstoreidx4
	OpAMD64MOVQstoreidx1
	OpAMD64MOVQstoreidx8
	OpAMD64MOVBstoreconst
	OpAMD64MOVWstoreconst
	OpAMD64MOVLstoreconst
	OpAMD64MOVQstoreconst
	OpAMD64MOVBstoreconstidx1
	OpAMD64MOVWstoreconstidx1
	OpAMD64MOVWstoreconstidx2
	OpAMD64MOVLstoreconstidx1
	OpAMD64MOVLstoreconstidx4
	OpAMD64MOVQstoreconstidx1
	OpAMD64MOVQstoreconstidx8
	OpAMD64DUFFZERO
	OpAMD64MOVOconst
	OpAMD64REPSTOSQ
	OpAMD64CALLstatic
	OpAMD64CALLclosure
	OpAMD64CALLdefer
	OpAMD64CALLgo
	OpAMD64CALLinter
	OpAMD64DUFFCOPY
	OpAMD64REPMOVSQ
	OpAMD64InvertFlags
	OpAMD64LoweredGetG
	OpAMD64LoweredGetClosurePtr
	OpAMD64LoweredNilCheck
	OpAMD64MOVQconvert
	OpAMD64FlagEQ
	OpAMD64FlagLT_ULT
	OpAMD64FlagLT_UGT
	OpAMD64FlagGT_UGT
	OpAMD64FlagGT_ULT

	OpARMADD
	OpARMADDconst
	OpARMMOVWconst
	OpARMCMP
	OpARMMOVWload
	OpARMMOVWstore
	OpARMCALLstatic
	OpARMLessThan

	OpAdd8
	OpAdd16
	OpAdd32
	OpAdd64
	OpAddPtr
	OpAdd32F
	OpAdd64F
	OpSub8
	OpSub16
	OpSub32
	OpSub64
	OpSubPtr
	OpSub32F
	OpSub64F
	OpMul8
	OpMul16
	OpMul32
	OpMul64
	OpMul32F
	OpMul64F
	OpDiv32F
	OpDiv64F
	OpHmul8
	OpHmul8u
	OpHmul16
	OpHmul16u
	OpHmul32
	OpHmul32u
	OpHmul64
	OpHmul64u
	OpAvg64u
	OpDiv8
	OpDiv8u
	OpDiv16
	OpDiv16u
	OpDiv32
	OpDiv32u
	OpDiv64
	OpDiv64u
	OpMod8
	OpMod8u
	OpMod16
	OpMod16u
	OpMod32
	OpMod32u
	OpMod64
	OpMod64u
	OpAnd8
	OpAnd16
	OpAnd32
	OpAnd64
	OpOr8
	OpOr16
	OpOr32
	OpOr64
	OpXor8
	OpXor16
	OpXor32
	OpXor64
	OpLsh8x8
	OpLsh8x16
	OpLsh8x32
	OpLsh8x64
	OpLsh16x8
	OpLsh16x16
	OpLsh16x32
	OpLsh16x64
	OpLsh32x8
	OpLsh32x16
	OpLsh32x32
	OpLsh32x64
	OpLsh64x8
	OpLsh64x16
	OpLsh64x32
	OpLsh64x64
	OpRsh8x8
	OpRsh8x16
	OpRsh8x32
	OpRsh8x64
	OpRsh16x8
	OpRsh16x16
	OpRsh16x32
	OpRsh16x64
	OpRsh32x8
	OpRsh32x16
	OpRsh32x32
	OpRsh32x64
	OpRsh64x8
	OpRsh64x16
	OpRsh64x32
	OpRsh64x64
	OpRsh8Ux8
	OpRsh8Ux16
	OpRsh8Ux32
	OpRsh8Ux64
	OpRsh16Ux8
	OpRsh16Ux16
	OpRsh16Ux32
	OpRsh16Ux64
	OpRsh32Ux8
	OpRsh32Ux16
	OpRsh32Ux32
	OpRsh32Ux64
	OpRsh64Ux8
	OpRsh64Ux16
	OpRsh64Ux32
	OpRsh64Ux64
	OpLrot8
	OpLrot16
	OpLrot32
	OpLrot64
	OpEq8
	OpEq16
	OpEq32
	OpEq64
	OpEqPtr
	OpEqInter
	OpEqSlice
	OpEq32F
	OpEq64F
	OpNeq8
	OpNeq16
	OpNeq32
	OpNeq64
	OpNeqPtr
	OpNeqInter
	OpNeqSlice
	OpNeq32F
	OpNeq64F
	OpLess8
	OpLess8U
	OpLess16
	OpLess16U
	OpLess32
	OpLess32U
	OpLess64
	OpLess64U
	OpLess32F
	OpLess64F
	OpLeq8
	OpLeq8U
	OpLeq16
	OpLeq16U
	OpLeq32
	OpLeq32U
	OpLeq64
	OpLeq64U
	OpLeq32F
	OpLeq64F
	OpGreater8
	OpGreater8U
	OpGreater16
	OpGreater16U
	OpGreater32
	OpGreater32U
	OpGreater64
	OpGreater64U
	OpGreater32F
	OpGreater64F
	OpGeq8
	OpGeq8U
	OpGeq16
	OpGeq16U
	OpGeq32
	OpGeq32U
	OpGeq64
	OpGeq64U
	OpGeq32F
	OpGeq64F
	OpAndB
	OpOrB
	OpEqB
	OpNeqB
	OpNot
	OpNeg8
	OpNeg16
	OpNeg32
	OpNeg64
	OpNeg32F
	OpNeg64F
	OpCom8
	OpCom16
	OpCom32
	OpCom64
	OpCtz16
	OpCtz32
	OpCtz64
	OpClz16
	OpClz32
	OpClz64
	OpBswap32
	OpBswap64
	OpSqrt
	OpPhi
	OpCopy
	OpConvert
	OpConstBool
	OpConstString
	OpConstNil
	OpConst8
	OpConst16
	OpConst32
	OpConst64
	OpConst32F
	OpConst64F
	OpConstInterface
	OpConstSlice
	OpInitMem
	OpArg
	OpAddr
	OpSP
	OpSB
	OpFunc
	OpLoad
	OpStore
	OpMove
	OpZero
	OpClosureCall
	OpStaticCall
	OpDeferCall
	OpGoCall
	OpInterCall
	OpSignExt8to16
	OpSignExt8to32
	OpSignExt8to64
	OpSignExt16to32
	OpSignExt16to64
	OpSignExt32to64
	OpZeroExt8to16
	OpZeroExt8to32
	OpZeroExt8to64
	OpZeroExt16to32
	OpZeroExt16to64
	OpZeroExt32to64
	OpTrunc16to8
	OpTrunc32to8
	OpTrunc32to16
	OpTrunc64to8
	OpTrunc64to16
	OpTrunc64to32
	OpCvt32to32F
	OpCvt32to64F
	OpCvt64to32F
	OpCvt64to64F
	OpCvt32Fto32
	OpCvt32Fto64
	OpCvt64Fto32
	OpCvt64Fto64
	OpCvt32Fto64F
	OpCvt64Fto32F
	OpIsNonNil
	OpIsInBounds
	OpIsSliceInBounds
	OpNilCheck
	OpGetG
	OpGetClosurePtr
	OpArrayIndex
	OpPtrIndex
	OpOffPtr
	OpSliceMake
	OpSlicePtr
	OpSliceLen
	OpSliceCap
	OpComplexMake
	OpComplexReal
	OpComplexImag
	OpStringMake
	OpStringPtr
	OpStringLen
	OpIMake
	OpITab
	OpIData
	OpStructMake0
	OpStructMake1
	OpStructMake2
	OpStructMake3
	OpStructMake4
	OpStructSelect
	OpStoreReg
	OpLoadReg
	OpFwdRef
	OpUnknown
	OpVarDef
	OpVarKill
	OpVarLive
	OpKeepAlive
)

var opcodeTable = [...]opInfo{
	{name: "OpInvalid"},

	{
		name:         "ADDSS",
		argLen:       2,
		commutative:  true,
		resultInArg0: true,
		asm:          x86.AADDSS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []regMask{
				4294901760, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
		},
	},
	{
		name:         "ADDSD",
		argLen:       2,
		commutative:  true,
		resultInArg0: true,
		asm:          x86.AADDSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []regMask{
				4294901760, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
		},
	},
	{
		name:         "SUBSS",
		argLen:       2,
		resultInArg0: true,
		asm:          x86.ASUBSS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			clobbers: 2147483648, // X15
			outputs: []regMask{
				2147418112, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "SUBSD",
		argLen:       2,
		resultInArg0: true,
		asm:          x86.ASUBSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			clobbers: 2147483648, // X15
			outputs: []regMask{
				2147418112, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "MULSS",
		argLen:       2,
		commutative:  true,
		resultInArg0: true,
		asm:          x86.AMULSS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []regMask{
				4294901760, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
		},
	},
	{
		name:         "MULSD",
		argLen:       2,
		commutative:  true,
		resultInArg0: true,
		asm:          x86.AMULSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []regMask{
				4294901760, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
		},
	},
	{
		name:         "DIVSS",
		argLen:       2,
		resultInArg0: true,
		asm:          x86.ADIVSS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			clobbers: 2147483648, // X15
			outputs: []regMask{
				2147418112, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "DIVSD",
		argLen:       2,
		resultInArg0: true,
		asm:          x86.ADIVSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			clobbers: 2147483648, // X15
			outputs: []regMask{
				2147418112, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:    "MOVSSload",
		auxType: auxSymOff,
		argLen:  2,
		asm:     x86.AMOVSS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
			outputs: []regMask{
				4294901760, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
		},
	},
	{
		name:    "MOVSDload",
		auxType: auxSymOff,
		argLen:  2,
		asm:     x86.AMOVSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
			outputs: []regMask{
				4294901760, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
		},
	},
	{
		name:              "MOVSSconst",
		auxType:           auxFloat32,
		argLen:            0,
		rematerializeable: true,
		asm:               x86.AMOVSS,
		reg: regInfo{
			outputs: []regMask{
				4294901760, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
		},
	},
	{
		name:              "MOVSDconst",
		auxType:           auxFloat64,
		argLen:            0,
		rematerializeable: true,
		asm:               x86.AMOVSD,
		reg: regInfo{
			outputs: []regMask{
				4294901760, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
		},
	},
	{
		name:    "MOVSSloadidx1",
		auxType: auxSymOff,
		argLen:  3,
		asm:     x86.AMOVSS,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
			outputs: []regMask{
				4294901760, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
		},
	},
	{
		name:    "MOVSSloadidx4",
		auxType: auxSymOff,
		argLen:  3,
		asm:     x86.AMOVSS,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
			outputs: []regMask{
				4294901760, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
		},
	},
	{
		name:    "MOVSDloadidx1",
		auxType: auxSymOff,
		argLen:  3,
		asm:     x86.AMOVSD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
			outputs: []regMask{
				4294901760, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
		},
	},
	{
		name:    "MOVSDloadidx8",
		auxType: auxSymOff,
		argLen:  3,
		asm:     x86.AMOVSD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
			outputs: []regMask{
				4294901760, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
		},
	},
	{
		name:    "MOVSSstore",
		auxType: auxSymOff,
		argLen:  3,
		asm:     x86.AMOVSS,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
		},
	},
	{
		name:    "MOVSDstore",
		auxType: auxSymOff,
		argLen:  3,
		asm:     x86.AMOVSD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
		},
	},
	{
		name:    "MOVSSstoreidx1",
		auxType: auxSymOff,
		argLen:  4,
		asm:     x86.AMOVSS,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{2, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
		},
	},
	{
		name:    "MOVSSstoreidx4",
		auxType: auxSymOff,
		argLen:  4,
		asm:     x86.AMOVSS,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{2, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
		},
	},
	{
		name:    "MOVSDstoreidx1",
		auxType: auxSymOff,
		argLen:  4,
		asm:     x86.AMOVSD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{2, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
		},
	},
	{
		name:    "MOVSDstoreidx8",
		auxType: auxSymOff,
		argLen:  4,
		asm:     x86.AMOVSD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{2, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
		},
	},
	{
		name:        "ADDQ",
		argLen:      2,
		commutative: true,
		asm:         x86.AADDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{0, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:        "ADDL",
		argLen:      2,
		commutative: true,
		asm:         x86.AADDL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{0, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:    "ADDQconst",
		auxType: auxInt64,
		argLen:  1,
		asm:     x86.AADDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:    "ADDLconst",
		auxType: auxInt32,
		argLen:  1,
		asm:     x86.AADDL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "SUBQ",
		argLen:       2,
		resultInArg0: true,
		asm:          x86.ASUBQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{1, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "SUBL",
		argLen:       2,
		resultInArg0: true,
		asm:          x86.ASUBL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{1, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "SUBQconst",
		auxType:      auxInt64,
		argLen:       1,
		resultInArg0: true,
		asm:          x86.ASUBQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "SUBLconst",
		auxType:      auxInt32,
		argLen:       1,
		resultInArg0: true,
		asm:          x86.ASUBL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "MULQ",
		argLen:       2,
		commutative:  true,
		resultInArg0: true,
		asm:          x86.AIMULQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{1, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "MULL",
		argLen:       2,
		commutative:  true,
		resultInArg0: true,
		asm:          x86.AIMULL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{1, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "MULQconst",
		auxType:      auxInt64,
		argLen:       1,
		resultInArg0: true,
		asm:          x86.AIMULQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "MULLconst",
		auxType:      auxInt32,
		argLen:       1,
		resultInArg0: true,
		asm:          x86.AIMULL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:   "HMULQ",
		argLen: 2,
		asm:    x86.AIMULQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},     // AX
				{1, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934593, // AX FLAGS
			outputs: []regMask{
				4, // DX
			},
		},
	},
	{
		name:   "HMULL",
		argLen: 2,
		asm:    x86.AIMULL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},     // AX
				{1, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934593, // AX FLAGS
			outputs: []regMask{
				4, // DX
			},
		},
	},
	{
		name:   "HMULW",
		argLen: 2,
		asm:    x86.AIMULW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},     // AX
				{1, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934593, // AX FLAGS
			outputs: []regMask{
				4, // DX
			},
		},
	},
	{
		name:   "HMULB",
		argLen: 2,
		asm:    x86.AIMULB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},     // AX
				{1, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934593, // AX FLAGS
			outputs: []regMask{
				4, // DX
			},
		},
	},
	{
		name:   "HMULQU",
		argLen: 2,
		asm:    x86.AMULQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},     // AX
				{1, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934593, // AX FLAGS
			outputs: []regMask{
				4, // DX
			},
		},
	},
	{
		name:   "HMULLU",
		argLen: 2,
		asm:    x86.AMULL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},     // AX
				{1, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934593, // AX FLAGS
			outputs: []regMask{
				4, // DX
			},
		},
	},
	{
		name:   "HMULWU",
		argLen: 2,
		asm:    x86.AMULW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},     // AX
				{1, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934593, // AX FLAGS
			outputs: []regMask{
				4, // DX
			},
		},
	},
	{
		name:   "HMULBU",
		argLen: 2,
		asm:    x86.AMULB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},     // AX
				{1, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934593, // AX FLAGS
			outputs: []regMask{
				4, // DX
			},
		},
	},
	{
		name:         "AVGQU",
		argLen:       2,
		commutative:  true,
		resultInArg0: true,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{1, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:   "DIVQ",
		argLen: 2,
		asm:    x86.AIDIVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},     // AX
				{1, 65531}, // AX CX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934596, // DX FLAGS
			outputs: []regMask{
				1, // AX
			},
		},
	},
	{
		name:   "DIVL",
		argLen: 2,
		asm:    x86.AIDIVL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},     // AX
				{1, 65531}, // AX CX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934596, // DX FLAGS
			outputs: []regMask{
				1, // AX
			},
		},
	},
	{
		name:   "DIVW",
		argLen: 2,
		asm:    x86.AIDIVW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},     // AX
				{1, 65531}, // AX CX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934596, // DX FLAGS
			outputs: []regMask{
				1, // AX
			},
		},
	},
	{
		name:   "DIVQU",
		argLen: 2,
		asm:    x86.ADIVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},     // AX
				{1, 65531}, // AX CX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934596, // DX FLAGS
			outputs: []regMask{
				1, // AX
			},
		},
	},
	{
		name:   "DIVLU",
		argLen: 2,
		asm:    x86.ADIVL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},     // AX
				{1, 65531}, // AX CX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934596, // DX FLAGS
			outputs: []regMask{
				1, // AX
			},
		},
	},
	{
		name:   "DIVWU",
		argLen: 2,
		asm:    x86.ADIVW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},     // AX
				{1, 65531}, // AX CX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934596, // DX FLAGS
			outputs: []regMask{
				1, // AX
			},
		},
	},
	{
		name:   "MODQ",
		argLen: 2,
		asm:    x86.AIDIVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},     // AX
				{1, 65531}, // AX CX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934593, // AX FLAGS
			outputs: []regMask{
				4, // DX
			},
		},
	},
	{
		name:   "MODL",
		argLen: 2,
		asm:    x86.AIDIVL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},     // AX
				{1, 65531}, // AX CX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934593, // AX FLAGS
			outputs: []regMask{
				4, // DX
			},
		},
	},
	{
		name:   "MODW",
		argLen: 2,
		asm:    x86.AIDIVW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},     // AX
				{1, 65531}, // AX CX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934593, // AX FLAGS
			outputs: []regMask{
				4, // DX
			},
		},
	},
	{
		name:   "MODQU",
		argLen: 2,
		asm:    x86.ADIVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},     // AX
				{1, 65531}, // AX CX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934593, // AX FLAGS
			outputs: []regMask{
				4, // DX
			},
		},
	},
	{
		name:   "MODLU",
		argLen: 2,
		asm:    x86.ADIVL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},     // AX
				{1, 65531}, // AX CX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934593, // AX FLAGS
			outputs: []regMask{
				4, // DX
			},
		},
	},
	{
		name:   "MODWU",
		argLen: 2,
		asm:    x86.ADIVW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},     // AX
				{1, 65531}, // AX CX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934593, // AX FLAGS
			outputs: []regMask{
				4, // DX
			},
		},
	},
	{
		name:         "ANDQ",
		argLen:       2,
		commutative:  true,
		resultInArg0: true,
		asm:          x86.AANDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{1, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "ANDL",
		argLen:       2,
		commutative:  true,
		resultInArg0: true,
		asm:          x86.AANDL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{1, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "ANDQconst",
		auxType:      auxInt64,
		argLen:       1,
		resultInArg0: true,
		asm:          x86.AANDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "ANDLconst",
		auxType:      auxInt32,
		argLen:       1,
		resultInArg0: true,
		asm:          x86.AANDL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "ORQ",
		argLen:       2,
		commutative:  true,
		resultInArg0: true,
		asm:          x86.AORQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{1, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "ORL",
		argLen:       2,
		commutative:  true,
		resultInArg0: true,
		asm:          x86.AORL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{1, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "ORQconst",
		auxType:      auxInt64,
		argLen:       1,
		resultInArg0: true,
		asm:          x86.AORQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "ORLconst",
		auxType:      auxInt32,
		argLen:       1,
		resultInArg0: true,
		asm:          x86.AORL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "XORQ",
		argLen:       2,
		commutative:  true,
		resultInArg0: true,
		asm:          x86.AXORQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{1, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "XORL",
		argLen:       2,
		commutative:  true,
		resultInArg0: true,
		asm:          x86.AXORL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{1, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "XORQconst",
		auxType:      auxInt64,
		argLen:       1,
		resultInArg0: true,
		asm:          x86.AXORQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "XORLconst",
		auxType:      auxInt32,
		argLen:       1,
		resultInArg0: true,
		asm:          x86.AXORL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:   "CMPQ",
		argLen: 2,
		asm:    x86.ACMPQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{1, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			outputs: []regMask{
				8589934592, // FLAGS
			},
		},
	},
	{
		name:   "CMPL",
		argLen: 2,
		asm:    x86.ACMPL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{1, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			outputs: []regMask{
				8589934592, // FLAGS
			},
		},
	},
	{
		name:   "CMPW",
		argLen: 2,
		asm:    x86.ACMPW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{1, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			outputs: []regMask{
				8589934592, // FLAGS
			},
		},
	},
	{
		name:   "CMPB",
		argLen: 2,
		asm:    x86.ACMPB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{1, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			outputs: []regMask{
				8589934592, // FLAGS
			},
		},
	},
	{
		name:    "CMPQconst",
		auxType: auxInt64,
		argLen:  1,
		asm:     x86.ACMPQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			outputs: []regMask{
				8589934592, // FLAGS
			},
		},
	},
	{
		name:    "CMPLconst",
		auxType: auxInt32,
		argLen:  1,
		asm:     x86.ACMPL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			outputs: []regMask{
				8589934592, // FLAGS
			},
		},
	},
	{
		name:    "CMPWconst",
		auxType: auxInt16,
		argLen:  1,
		asm:     x86.ACMPW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			outputs: []regMask{
				8589934592, // FLAGS
			},
		},
	},
	{
		name:    "CMPBconst",
		auxType: auxInt8,
		argLen:  1,
		asm:     x86.ACMPB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			outputs: []regMask{
				8589934592, // FLAGS
			},
		},
	},
	{
		name:   "UCOMISS",
		argLen: 2,
		asm:    x86.AUCOMISS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []regMask{
				8589934592, // FLAGS
			},
		},
	},
	{
		name:   "UCOMISD",
		argLen: 2,
		asm:    x86.AUCOMISD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []regMask{
				8589934592, // FLAGS
			},
		},
	},
	{
		name:   "TESTQ",
		argLen: 2,
		asm:    x86.ATESTQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{1, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			outputs: []regMask{
				8589934592, // FLAGS
			},
		},
	},
	{
		name:   "TESTL",
		argLen: 2,
		asm:    x86.ATESTL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{1, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			outputs: []regMask{
				8589934592, // FLAGS
			},
		},
	},
	{
		name:   "TESTW",
		argLen: 2,
		asm:    x86.ATESTW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{1, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			outputs: []regMask{
				8589934592, // FLAGS
			},
		},
	},
	{
		name:   "TESTB",
		argLen: 2,
		asm:    x86.ATESTB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{1, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			outputs: []regMask{
				8589934592, // FLAGS
			},
		},
	},
	{
		name:    "TESTQconst",
		auxType: auxInt64,
		argLen:  1,
		asm:     x86.ATESTQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			outputs: []regMask{
				8589934592, // FLAGS
			},
		},
	},
	{
		name:    "TESTLconst",
		auxType: auxInt32,
		argLen:  1,
		asm:     x86.ATESTL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			outputs: []regMask{
				8589934592, // FLAGS
			},
		},
	},
	{
		name:    "TESTWconst",
		auxType: auxInt16,
		argLen:  1,
		asm:     x86.ATESTW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			outputs: []regMask{
				8589934592, // FLAGS
			},
		},
	},
	{
		name:    "TESTBconst",
		auxType: auxInt8,
		argLen:  1,
		asm:     x86.ATESTB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			outputs: []regMask{
				8589934592, // FLAGS
			},
		},
	},
	{
		name:         "SHLQ",
		argLen:       2,
		resultInArg0: true,
		asm:          x86.ASHLQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2},     // CX
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "SHLL",
		argLen:       2,
		resultInArg0: true,
		asm:          x86.ASHLL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2},     // CX
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "SHLQconst",
		auxType:      auxInt64,
		argLen:       1,
		resultInArg0: true,
		asm:          x86.ASHLQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "SHLLconst",
		auxType:      auxInt32,
		argLen:       1,
		resultInArg0: true,
		asm:          x86.ASHLL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "SHRQ",
		argLen:       2,
		resultInArg0: true,
		asm:          x86.ASHRQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2},     // CX
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "SHRL",
		argLen:       2,
		resultInArg0: true,
		asm:          x86.ASHRL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2},     // CX
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "SHRW",
		argLen:       2,
		resultInArg0: true,
		asm:          x86.ASHRW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2},     // CX
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "SHRB",
		argLen:       2,
		resultInArg0: true,
		asm:          x86.ASHRB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2},     // CX
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "SHRQconst",
		auxType:      auxInt64,
		argLen:       1,
		resultInArg0: true,
		asm:          x86.ASHRQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "SHRLconst",
		auxType:      auxInt32,
		argLen:       1,
		resultInArg0: true,
		asm:          x86.ASHRL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "SHRWconst",
		auxType:      auxInt16,
		argLen:       1,
		resultInArg0: true,
		asm:          x86.ASHRW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "SHRBconst",
		auxType:      auxInt8,
		argLen:       1,
		resultInArg0: true,
		asm:          x86.ASHRB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "SARQ",
		argLen:       2,
		resultInArg0: true,
		asm:          x86.ASARQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2},     // CX
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "SARL",
		argLen:       2,
		resultInArg0: true,
		asm:          x86.ASARL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2},     // CX
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "SARW",
		argLen:       2,
		resultInArg0: true,
		asm:          x86.ASARW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2},     // CX
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "SARB",
		argLen:       2,
		resultInArg0: true,
		asm:          x86.ASARB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2},     // CX
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "SARQconst",
		auxType:      auxInt64,
		argLen:       1,
		resultInArg0: true,
		asm:          x86.ASARQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "SARLconst",
		auxType:      auxInt32,
		argLen:       1,
		resultInArg0: true,
		asm:          x86.ASARL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "SARWconst",
		auxType:      auxInt16,
		argLen:       1,
		resultInArg0: true,
		asm:          x86.ASARW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "SARBconst",
		auxType:      auxInt8,
		argLen:       1,
		resultInArg0: true,
		asm:          x86.ASARB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "ROLQconst",
		auxType:      auxInt64,
		argLen:       1,
		resultInArg0: true,
		asm:          x86.AROLQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "ROLLconst",
		auxType:      auxInt32,
		argLen:       1,
		resultInArg0: true,
		asm:          x86.AROLL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "ROLWconst",
		auxType:      auxInt16,
		argLen:       1,
		resultInArg0: true,
		asm:          x86.AROLW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "ROLBconst",
		auxType:      auxInt8,
		argLen:       1,
		resultInArg0: true,
		asm:          x86.AROLB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "NEGQ",
		argLen:       1,
		resultInArg0: true,
		asm:          x86.ANEGQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "NEGL",
		argLen:       1,
		resultInArg0: true,
		asm:          x86.ANEGL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "NOTQ",
		argLen:       1,
		resultInArg0: true,
		asm:          x86.ANOTQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "NOTL",
		argLen:       1,
		resultInArg0: true,
		asm:          x86.ANOTL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:   "BSFQ",
		argLen: 1,
		asm:    x86.ABSFQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:   "BSFL",
		argLen: 1,
		asm:    x86.ABSFL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:   "BSFW",
		argLen: 1,
		asm:    x86.ABSFW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:   "BSRQ",
		argLen: 1,
		asm:    x86.ABSRQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:   "BSRL",
		argLen: 1,
		asm:    x86.ABSRL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:   "BSRW",
		argLen: 1,
		asm:    x86.ABSRW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "CMOVQEQconst",
		auxType:      auxInt64,
		argLen:       2,
		resultInArg0: true,
		asm:          x86.ACMOVQEQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 8589934592}, // FLAGS
				{0, 65518},      // CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934593, // AX FLAGS
			outputs: []regMask{
				65518, // CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "CMOVLEQconst",
		auxType:      auxInt32,
		argLen:       2,
		resultInArg0: true,
		asm:          x86.ACMOVLEQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 8589934592}, // FLAGS
				{0, 65518},      // CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934593, // AX FLAGS
			outputs: []regMask{
				65518, // CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "CMOVWEQconst",
		auxType:      auxInt16,
		argLen:       2,
		resultInArg0: true,
		asm:          x86.ACMOVLEQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 8589934592}, // FLAGS
				{0, 65518},      // CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934593, // AX FLAGS
			outputs: []regMask{
				65518, // CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "CMOVQNEconst",
		auxType:      auxInt64,
		argLen:       2,
		resultInArg0: true,
		asm:          x86.ACMOVQNE,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 8589934592}, // FLAGS
				{0, 65518},      // CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934593, // AX FLAGS
			outputs: []regMask{
				65518, // CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "CMOVLNEconst",
		auxType:      auxInt32,
		argLen:       2,
		resultInArg0: true,
		asm:          x86.ACMOVLNE,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 8589934592}, // FLAGS
				{0, 65518},      // CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934593, // AX FLAGS
			outputs: []regMask{
				65518, // CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "CMOVWNEconst",
		auxType:      auxInt16,
		argLen:       2,
		resultInArg0: true,
		asm:          x86.ACMOVLNE,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 8589934592}, // FLAGS
				{0, 65518},      // CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934593, // AX FLAGS
			outputs: []regMask{
				65518, // CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "BSWAPQ",
		argLen:       1,
		resultInArg0: true,
		asm:          x86.ABSWAPQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:         "BSWAPL",
		argLen:       1,
		resultInArg0: true,
		asm:          x86.ABSWAPL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:   "SQRTSD",
		argLen: 1,
		asm:    x86.ASQRTSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []regMask{
				4294901760, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
		},
	},
	{
		name:   "SBBQcarrymask",
		argLen: 1,
		asm:    x86.ASBBQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 8589934592}, // FLAGS
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:   "SBBLcarrymask",
		argLen: 1,
		asm:    x86.ASBBL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 8589934592}, // FLAGS
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:   "SETEQ",
		argLen: 1,
		asm:    x86.ASETEQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 8589934592}, // FLAGS
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:   "SETNE",
		argLen: 1,
		asm:    x86.ASETNE,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 8589934592}, // FLAGS
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:   "SETL",
		argLen: 1,
		asm:    x86.ASETLT,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 8589934592}, // FLAGS
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:   "SETLE",
		argLen: 1,
		asm:    x86.ASETLE,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 8589934592}, // FLAGS
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:   "SETG",
		argLen: 1,
		asm:    x86.ASETGT,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 8589934592}, // FLAGS
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:   "SETGE",
		argLen: 1,
		asm:    x86.ASETGE,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 8589934592}, // FLAGS
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:   "SETB",
		argLen: 1,
		asm:    x86.ASETCS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 8589934592}, // FLAGS
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:   "SETBE",
		argLen: 1,
		asm:    x86.ASETLS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 8589934592}, // FLAGS
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:   "SETA",
		argLen: 1,
		asm:    x86.ASETHI,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 8589934592}, // FLAGS
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:   "SETAE",
		argLen: 1,
		asm:    x86.ASETCC,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 8589934592}, // FLAGS
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:   "SETEQF",
		argLen: 1,
		asm:    x86.ASETEQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 8589934592}, // FLAGS
			},
			clobbers: 8589934593, // AX FLAGS
			outputs: []regMask{
				65518, // CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:   "SETNEF",
		argLen: 1,
		asm:    x86.ASETNE,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 8589934592}, // FLAGS
			},
			clobbers: 8589934593, // AX FLAGS
			outputs: []regMask{
				65518, // CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:   "SETORD",
		argLen: 1,
		asm:    x86.ASETPC,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 8589934592}, // FLAGS
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:   "SETNAN",
		argLen: 1,
		asm:    x86.ASETPS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 8589934592}, // FLAGS
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:   "SETGF",
		argLen: 1,
		asm:    x86.ASETHI,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 8589934592}, // FLAGS
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:   "SETGEF",
		argLen: 1,
		asm:    x86.ASETCC,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 8589934592}, // FLAGS
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:   "MOVBQSX",
		argLen: 1,
		asm:    x86.AMOVBQSX,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:   "MOVBQZX",
		argLen: 1,
		asm:    x86.AMOVBQZX,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:   "MOVWQSX",
		argLen: 1,
		asm:    x86.AMOVWQSX,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:   "MOVWQZX",
		argLen: 1,
		asm:    x86.AMOVWQZX,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:   "MOVLQSX",
		argLen: 1,
		asm:    x86.AMOVLQSX,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:   "MOVLQZX",
		argLen: 1,
		asm:    x86.AMOVLQZX,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:              "MOVLconst",
		auxType:           auxInt32,
		argLen:            0,
		rematerializeable: true,
		asm:               x86.AMOVL,
		reg: regInfo{
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:              "MOVQconst",
		auxType:           auxInt64,
		argLen:            0,
		rematerializeable: true,
		asm:               x86.AMOVQ,
		reg: regInfo{
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:   "CVTTSD2SL",
		argLen: 1,
		asm:    x86.ACVTTSD2SL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:   "CVTTSD2SQ",
		argLen: 1,
		asm:    x86.ACVTTSD2SQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:   "CVTTSS2SL",
		argLen: 1,
		asm:    x86.ACVTTSS2SL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:   "CVTTSS2SQ",
		argLen: 1,
		asm:    x86.ACVTTSS2SQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:   "CVTSL2SS",
		argLen: 1,
		asm:    x86.ACVTSL2SS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			outputs: []regMask{
				4294901760, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
		},
	},
	{
		name:   "CVTSL2SD",
		argLen: 1,
		asm:    x86.ACVTSL2SD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			outputs: []regMask{
				4294901760, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
		},
	},
	{
		name:   "CVTSQ2SS",
		argLen: 1,
		asm:    x86.ACVTSQ2SS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			outputs: []regMask{
				4294901760, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
		},
	},
	{
		name:   "CVTSQ2SD",
		argLen: 1,
		asm:    x86.ACVTSQ2SD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			outputs: []regMask{
				4294901760, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
		},
	},
	{
		name:   "CVTSD2SS",
		argLen: 1,
		asm:    x86.ACVTSD2SS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []regMask{
				4294901760, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
		},
	},
	{
		name:   "CVTSS2SD",
		argLen: 1,
		asm:    x86.ACVTSS2SD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []regMask{
				4294901760, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
		},
	},
	{
		name:         "PXOR",
		argLen:       2,
		commutative:  true,
		resultInArg0: true,
		asm:          x86.APXOR,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []regMask{
				4294901760, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
		},
	},
	{
		name:              "LEAQ",
		auxType:           auxSymOff,
		argLen:            1,
		rematerializeable: true,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:    "LEAQ1",
		auxType: auxSymOff,
		argLen:  2,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:    "LEAQ2",
		auxType: auxSymOff,
		argLen:  2,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:    "LEAQ4",
		auxType: auxSymOff,
		argLen:  2,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:    "LEAQ8",
		auxType: auxSymOff,
		argLen:  2,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:    "MOVBload",
		auxType: auxSymOff,
		argLen:  2,
		asm:     x86.AMOVBLZX,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:    "MOVBQSXload",
		auxType: auxSymOff,
		argLen:  2,
		asm:     x86.AMOVBQSX,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:    "MOVWload",
		auxType: auxSymOff,
		argLen:  2,
		asm:     x86.AMOVWLZX,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:    "MOVWQSXload",
		auxType: auxSymOff,
		argLen:  2,
		asm:     x86.AMOVWQSX,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:    "MOVLload",
		auxType: auxSymOff,
		argLen:  2,
		asm:     x86.AMOVL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:    "MOVLQSXload",
		auxType: auxSymOff,
		argLen:  2,
		asm:     x86.AMOVLQSX,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:    "MOVQload",
		auxType: auxSymOff,
		argLen:  2,
		asm:     x86.AMOVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:    "MOVBstore",
		auxType: auxSymOff,
		argLen:  3,
		asm:     x86.AMOVB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
		},
	},
	{
		name:    "MOVWstore",
		auxType: auxSymOff,
		argLen:  3,
		asm:     x86.AMOVW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
		},
	},
	{
		name:    "MOVLstore",
		auxType: auxSymOff,
		argLen:  3,
		asm:     x86.AMOVL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
		},
	},
	{
		name:    "MOVQstore",
		auxType: auxSymOff,
		argLen:  3,
		asm:     x86.AMOVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
		},
	},
	{
		name:    "MOVOload",
		auxType: auxSymOff,
		argLen:  2,
		asm:     x86.AMOVUPS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
			outputs: []regMask{
				4294901760, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
		},
	},
	{
		name:    "MOVOstore",
		auxType: auxSymOff,
		argLen:  3,
		asm:     x86.AMOVUPS,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
		},
	},
	{
		name:    "MOVBloadidx1",
		auxType: auxSymOff,
		argLen:  3,
		asm:     x86.AMOVBLZX,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:    "MOVWloadidx1",
		auxType: auxSymOff,
		argLen:  3,
		asm:     x86.AMOVWLZX,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:    "MOVWloadidx2",
		auxType: auxSymOff,
		argLen:  3,
		asm:     x86.AMOVWLZX,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:    "MOVLloadidx1",
		auxType: auxSymOff,
		argLen:  3,
		asm:     x86.AMOVL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:    "MOVLloadidx4",
		auxType: auxSymOff,
		argLen:  3,
		asm:     x86.AMOVL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:    "MOVQloadidx1",
		auxType: auxSymOff,
		argLen:  3,
		asm:     x86.AMOVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:    "MOVQloadidx8",
		auxType: auxSymOff,
		argLen:  3,
		asm:     x86.AMOVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:    "MOVBstoreidx1",
		auxType: auxSymOff,
		argLen:  4,
		asm:     x86.AMOVB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{2, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
		},
	},
	{
		name:    "MOVWstoreidx1",
		auxType: auxSymOff,
		argLen:  4,
		asm:     x86.AMOVW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{2, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
		},
	},
	{
		name:    "MOVWstoreidx2",
		auxType: auxSymOff,
		argLen:  4,
		asm:     x86.AMOVW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{2, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
		},
	},
	{
		name:    "MOVLstoreidx1",
		auxType: auxSymOff,
		argLen:  4,
		asm:     x86.AMOVL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{2, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
		},
	},
	{
		name:    "MOVLstoreidx4",
		auxType: auxSymOff,
		argLen:  4,
		asm:     x86.AMOVL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{2, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
		},
	},
	{
		name:    "MOVQstoreidx1",
		auxType: auxSymOff,
		argLen:  4,
		asm:     x86.AMOVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{2, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
		},
	},
	{
		name:    "MOVQstoreidx8",
		auxType: auxSymOff,
		argLen:  4,
		asm:     x86.AMOVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{2, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
		},
	},
	{
		name:    "MOVBstoreconst",
		auxType: auxSymValAndOff,
		argLen:  2,
		asm:     x86.AMOVB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
		},
	},
	{
		name:    "MOVWstoreconst",
		auxType: auxSymValAndOff,
		argLen:  2,
		asm:     x86.AMOVW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
		},
	},
	{
		name:    "MOVLstoreconst",
		auxType: auxSymValAndOff,
		argLen:  2,
		asm:     x86.AMOVL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
		},
	},
	{
		name:    "MOVQstoreconst",
		auxType: auxSymValAndOff,
		argLen:  2,
		asm:     x86.AMOVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
		},
	},
	{
		name:    "MOVBstoreconstidx1",
		auxType: auxSymValAndOff,
		argLen:  3,
		asm:     x86.AMOVB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
		},
	},
	{
		name:    "MOVWstoreconstidx1",
		auxType: auxSymValAndOff,
		argLen:  3,
		asm:     x86.AMOVW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
		},
	},
	{
		name:    "MOVWstoreconstidx2",
		auxType: auxSymValAndOff,
		argLen:  3,
		asm:     x86.AMOVW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
		},
	},
	{
		name:    "MOVLstoreconstidx1",
		auxType: auxSymValAndOff,
		argLen:  3,
		asm:     x86.AMOVL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
		},
	},
	{
		name:    "MOVLstoreconstidx4",
		auxType: auxSymValAndOff,
		argLen:  3,
		asm:     x86.AMOVL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
		},
	},
	{
		name:    "MOVQstoreconstidx1",
		auxType: auxSymValAndOff,
		argLen:  3,
		asm:     x86.AMOVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
		},
	},
	{
		name:    "MOVQstoreconstidx8",
		auxType: auxSymValAndOff,
		argLen:  3,
		asm:     x86.AMOVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 65535},      // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
				{0, 4295032831}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 SB
			},
		},
	},
	{
		name:    "DUFFZERO",
		auxType: auxInt64,
		argLen:  3,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 128},   // DI
				{1, 65536}, // X0
			},
			clobbers: 8589934720, // DI FLAGS
		},
	},
	{
		name:              "MOVOconst",
		auxType:           auxInt128,
		argLen:            0,
		rematerializeable: true,
		reg: regInfo{
			outputs: []regMask{
				4294901760, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
		},
	},
	{
		name:   "REPSTOSQ",
		argLen: 4,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 128}, // DI
				{1, 2},   // CX
				{2, 1},   // AX
			},
			clobbers: 130, // CX DI
		},
	},
	{
		name:    "CALLstatic",
		auxType: auxSymOff,
		argLen:  1,
		reg: regInfo{
			clobbers: 12884901871, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 FLAGS
		},
	},
	{
		name:    "CALLclosure",
		auxType: auxInt64,
		argLen:  3,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 4},     // DX
				{0, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 12884901871, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 FLAGS
		},
	},
	{
		name:    "CALLdefer",
		auxType: auxInt64,
		argLen:  1,
		reg: regInfo{
			clobbers: 12884901871, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 FLAGS
		},
	},
	{
		name:    "CALLgo",
		auxType: auxInt64,
		argLen:  1,
		reg: regInfo{
			clobbers: 12884901871, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 FLAGS
		},
	},
	{
		name:    "CALLinter",
		auxType: auxInt64,
		argLen:  2,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65519}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 12884901871, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15 X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 FLAGS
		},
	},
	{
		name:    "DUFFCOPY",
		auxType: auxInt64,
		argLen:  3,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 128}, // DI
				{1, 64},  // SI
			},
			clobbers: 8590000320, // SI DI X0 FLAGS
		},
	},
	{
		name:   "REPMOVSQ",
		argLen: 4,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 128}, // DI
				{1, 64},  // SI
				{2, 2},   // CX
			},
			clobbers: 194, // CX SI DI
		},
	},
	{
		name:   "InvertFlags",
		argLen: 1,
		reg:    regInfo{},
	},
	{
		name:   "LoweredGetG",
		argLen: 1,
		reg: regInfo{
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:   "LoweredGetClosurePtr",
		argLen: 0,
		reg: regInfo{
			outputs: []regMask{
				4, // DX
			},
		},
	},
	{
		name:   "LoweredNilCheck",
		argLen: 2,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			clobbers: 8589934592, // FLAGS
		},
	},
	{
		name:   "MOVQconvert",
		argLen: 2,
		asm:    x86.AMOVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65535}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
			outputs: []regMask{
				65519, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R14 R15
			},
		},
	},
	{
		name:   "FlagEQ",
		argLen: 0,
		reg:    regInfo{},
	},
	{
		name:   "FlagLT_ULT",
		argLen: 0,
		reg:    regInfo{},
	},
	{
		name:   "FlagLT_UGT",
		argLen: 0,
		reg:    regInfo{},
	},
	{
		name:   "FlagGT_UGT",
		argLen: 0,
		reg:    regInfo{},
	},
	{
		name:   "FlagGT_ULT",
		argLen: 0,
		reg:    regInfo{},
	},

	{
		name:        "ADD",
		argLen:      2,
		commutative: true,
		asm:         arm.AADD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 31}, // R0 R1 R2 R3 SP
				{1, 31}, // R0 R1 R2 R3 SP
			},
			outputs: []regMask{
				31, // R0 R1 R2 R3 SP
			},
		},
	},
	{
		name:    "ADDconst",
		auxType: auxSymOff,
		argLen:  1,
		asm:     arm.AADD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 31}, // R0 R1 R2 R3 SP
			},
			outputs: []regMask{
				31, // R0 R1 R2 R3 SP
			},
		},
	},
	{
		name:              "MOVWconst",
		auxType:           auxInt32,
		argLen:            0,
		rematerializeable: true,
		asm:               arm.AMOVW,
		reg: regInfo{
			outputs: []regMask{
				31, // R0 R1 R2 R3 SP
			},
		},
	},
	{
		name:   "CMP",
		argLen: 2,
		asm:    arm.ACMP,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 31}, // R0 R1 R2 R3 SP
				{1, 31}, // R0 R1 R2 R3 SP
			},
			outputs: []regMask{
				32, // FLAGS
			},
		},
	},
	{
		name:    "MOVWload",
		auxType: auxSymOff,
		argLen:  2,
		asm:     arm.AMOVW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 31}, // R0 R1 R2 R3 SP
			},
			outputs: []regMask{
				31, // R0 R1 R2 R3 SP
			},
		},
	},
	{
		name:    "MOVWstore",
		auxType: auxSymOff,
		argLen:  3,
		asm:     arm.AMOVW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 31}, // R0 R1 R2 R3 SP
				{1, 31}, // R0 R1 R2 R3 SP
			},
		},
	},
	{
		name:    "CALLstatic",
		auxType: auxSymOff,
		argLen:  1,
		reg: regInfo{
			clobbers: 15, // R0 R1 R2 R3
		},
	},
	{
		name:   "LessThan",
		argLen: 1,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 32}, // FLAGS
			},
			outputs: []regMask{
				31, // R0 R1 R2 R3 SP
			},
		},
	},

	{
		name:        "Add8",
		argLen:      2,
		commutative: true,
		generic:     true,
	},
	{
		name:        "Add16",
		argLen:      2,
		commutative: true,
		generic:     true,
	},
	{
		name:        "Add32",
		argLen:      2,
		commutative: true,
		generic:     true,
	},
	{
		name:        "Add64",
		argLen:      2,
		commutative: true,
		generic:     true,
	},
	{
		name:    "AddPtr",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Add32F",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Add64F",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Sub8",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Sub16",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Sub32",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Sub64",
		argLen:  2,
		generic: true,
	},
	{
		name:    "SubPtr",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Sub32F",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Sub64F",
		argLen:  2,
		generic: true,
	},
	{
		name:        "Mul8",
		argLen:      2,
		commutative: true,
		generic:     true,
	},
	{
		name:        "Mul16",
		argLen:      2,
		commutative: true,
		generic:     true,
	},
	{
		name:        "Mul32",
		argLen:      2,
		commutative: true,
		generic:     true,
	},
	{
		name:        "Mul64",
		argLen:      2,
		commutative: true,
		generic:     true,
	},
	{
		name:    "Mul32F",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Mul64F",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Div32F",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Div64F",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Hmul8",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Hmul8u",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Hmul16",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Hmul16u",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Hmul32",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Hmul32u",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Hmul64",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Hmul64u",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Avg64u",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Div8",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Div8u",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Div16",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Div16u",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Div32",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Div32u",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Div64",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Div64u",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Mod8",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Mod8u",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Mod16",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Mod16u",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Mod32",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Mod32u",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Mod64",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Mod64u",
		argLen:  2,
		generic: true,
	},
	{
		name:        "And8",
		argLen:      2,
		commutative: true,
		generic:     true,
	},
	{
		name:        "And16",
		argLen:      2,
		commutative: true,
		generic:     true,
	},
	{
		name:        "And32",
		argLen:      2,
		commutative: true,
		generic:     true,
	},
	{
		name:        "And64",
		argLen:      2,
		commutative: true,
		generic:     true,
	},
	{
		name:        "Or8",
		argLen:      2,
		commutative: true,
		generic:     true,
	},
	{
		name:        "Or16",
		argLen:      2,
		commutative: true,
		generic:     true,
	},
	{
		name:        "Or32",
		argLen:      2,
		commutative: true,
		generic:     true,
	},
	{
		name:        "Or64",
		argLen:      2,
		commutative: true,
		generic:     true,
	},
	{
		name:        "Xor8",
		argLen:      2,
		commutative: true,
		generic:     true,
	},
	{
		name:        "Xor16",
		argLen:      2,
		commutative: true,
		generic:     true,
	},
	{
		name:        "Xor32",
		argLen:      2,
		commutative: true,
		generic:     true,
	},
	{
		name:        "Xor64",
		argLen:      2,
		commutative: true,
		generic:     true,
	},
	{
		name:    "Lsh8x8",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Lsh8x16",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Lsh8x32",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Lsh8x64",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Lsh16x8",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Lsh16x16",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Lsh16x32",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Lsh16x64",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Lsh32x8",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Lsh32x16",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Lsh32x32",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Lsh32x64",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Lsh64x8",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Lsh64x16",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Lsh64x32",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Lsh64x64",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Rsh8x8",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Rsh8x16",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Rsh8x32",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Rsh8x64",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Rsh16x8",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Rsh16x16",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Rsh16x32",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Rsh16x64",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Rsh32x8",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Rsh32x16",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Rsh32x32",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Rsh32x64",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Rsh64x8",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Rsh64x16",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Rsh64x32",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Rsh64x64",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Rsh8Ux8",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Rsh8Ux16",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Rsh8Ux32",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Rsh8Ux64",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Rsh16Ux8",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Rsh16Ux16",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Rsh16Ux32",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Rsh16Ux64",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Rsh32Ux8",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Rsh32Ux16",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Rsh32Ux32",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Rsh32Ux64",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Rsh64Ux8",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Rsh64Ux16",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Rsh64Ux32",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Rsh64Ux64",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Lrot8",
		auxType: auxInt64,
		argLen:  1,
		generic: true,
	},
	{
		name:    "Lrot16",
		auxType: auxInt64,
		argLen:  1,
		generic: true,
	},
	{
		name:    "Lrot32",
		auxType: auxInt64,
		argLen:  1,
		generic: true,
	},
	{
		name:    "Lrot64",
		auxType: auxInt64,
		argLen:  1,
		generic: true,
	},
	{
		name:        "Eq8",
		argLen:      2,
		commutative: true,
		generic:     true,
	},
	{
		name:        "Eq16",
		argLen:      2,
		commutative: true,
		generic:     true,
	},
	{
		name:        "Eq32",
		argLen:      2,
		commutative: true,
		generic:     true,
	},
	{
		name:        "Eq64",
		argLen:      2,
		commutative: true,
		generic:     true,
	},
	{
		name:        "EqPtr",
		argLen:      2,
		commutative: true,
		generic:     true,
	},
	{
		name:    "EqInter",
		argLen:  2,
		generic: true,
	},
	{
		name:    "EqSlice",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Eq32F",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Eq64F",
		argLen:  2,
		generic: true,
	},
	{
		name:        "Neq8",
		argLen:      2,
		commutative: true,
		generic:     true,
	},
	{
		name:        "Neq16",
		argLen:      2,
		commutative: true,
		generic:     true,
	},
	{
		name:        "Neq32",
		argLen:      2,
		commutative: true,
		generic:     true,
	},
	{
		name:        "Neq64",
		argLen:      2,
		commutative: true,
		generic:     true,
	},
	{
		name:        "NeqPtr",
		argLen:      2,
		commutative: true,
		generic:     true,
	},
	{
		name:    "NeqInter",
		argLen:  2,
		generic: true,
	},
	{
		name:    "NeqSlice",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Neq32F",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Neq64F",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Less8",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Less8U",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Less16",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Less16U",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Less32",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Less32U",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Less64",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Less64U",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Less32F",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Less64F",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Leq8",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Leq8U",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Leq16",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Leq16U",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Leq32",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Leq32U",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Leq64",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Leq64U",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Leq32F",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Leq64F",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Greater8",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Greater8U",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Greater16",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Greater16U",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Greater32",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Greater32U",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Greater64",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Greater64U",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Greater32F",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Greater64F",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Geq8",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Geq8U",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Geq16",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Geq16U",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Geq32",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Geq32U",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Geq64",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Geq64U",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Geq32F",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Geq64F",
		argLen:  2,
		generic: true,
	},
	{
		name:    "AndB",
		argLen:  2,
		generic: true,
	},
	{
		name:    "OrB",
		argLen:  2,
		generic: true,
	},
	{
		name:    "EqB",
		argLen:  2,
		generic: true,
	},
	{
		name:    "NeqB",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Not",
		argLen:  1,
		generic: true,
	},
	{
		name:    "Neg8",
		argLen:  1,
		generic: true,
	},
	{
		name:    "Neg16",
		argLen:  1,
		generic: true,
	},
	{
		name:    "Neg32",
		argLen:  1,
		generic: true,
	},
	{
		name:    "Neg64",
		argLen:  1,
		generic: true,
	},
	{
		name:    "Neg32F",
		argLen:  1,
		generic: true,
	},
	{
		name:    "Neg64F",
		argLen:  1,
		generic: true,
	},
	{
		name:    "Com8",
		argLen:  1,
		generic: true,
	},
	{
		name:    "Com16",
		argLen:  1,
		generic: true,
	},
	{
		name:    "Com32",
		argLen:  1,
		generic: true,
	},
	{
		name:    "Com64",
		argLen:  1,
		generic: true,
	},
	{
		name:    "Ctz16",
		argLen:  1,
		generic: true,
	},
	{
		name:    "Ctz32",
		argLen:  1,
		generic: true,
	},
	{
		name:    "Ctz64",
		argLen:  1,
		generic: true,
	},
	{
		name:    "Clz16",
		argLen:  1,
		generic: true,
	},
	{
		name:    "Clz32",
		argLen:  1,
		generic: true,
	},
	{
		name:    "Clz64",
		argLen:  1,
		generic: true,
	},
	{
		name:    "Bswap32",
		argLen:  1,
		generic: true,
	},
	{
		name:    "Bswap64",
		argLen:  1,
		generic: true,
	},
	{
		name:    "Sqrt",
		argLen:  1,
		generic: true,
	},
	{
		name:    "Phi",
		argLen:  -1,
		generic: true,
	},
	{
		name:    "Copy",
		argLen:  1,
		generic: true,
	},
	{
		name:    "Convert",
		argLen:  2,
		generic: true,
	},
	{
		name:    "ConstBool",
		auxType: auxBool,
		argLen:  0,
		generic: true,
	},
	{
		name:    "ConstString",
		auxType: auxString,
		argLen:  0,
		generic: true,
	},
	{
		name:    "ConstNil",
		argLen:  0,
		generic: true,
	},
	{
		name:    "Const8",
		auxType: auxInt8,
		argLen:  0,
		generic: true,
	},
	{
		name:    "Const16",
		auxType: auxInt16,
		argLen:  0,
		generic: true,
	},
	{
		name:    "Const32",
		auxType: auxInt32,
		argLen:  0,
		generic: true,
	},
	{
		name:    "Const64",
		auxType: auxInt64,
		argLen:  0,
		generic: true,
	},
	{
		name:    "Const32F",
		auxType: auxFloat32,
		argLen:  0,
		generic: true,
	},
	{
		name:    "Const64F",
		auxType: auxFloat64,
		argLen:  0,
		generic: true,
	},
	{
		name:    "ConstInterface",
		argLen:  0,
		generic: true,
	},
	{
		name:    "ConstSlice",
		argLen:  0,
		generic: true,
	},
	{
		name:    "InitMem",
		argLen:  0,
		generic: true,
	},
	{
		name:    "Arg",
		auxType: auxSymOff,
		argLen:  0,
		generic: true,
	},
	{
		name:    "Addr",
		auxType: auxSym,
		argLen:  1,
		generic: true,
	},
	{
		name:    "SP",
		argLen:  0,
		generic: true,
	},
	{
		name:    "SB",
		argLen:  0,
		generic: true,
	},
	{
		name:    "Func",
		auxType: auxSym,
		argLen:  0,
		generic: true,
	},
	{
		name:    "Load",
		argLen:  2,
		generic: true,
	},
	{
		name:    "Store",
		auxType: auxInt64,
		argLen:  3,
		generic: true,
	},
	{
		name:    "Move",
		auxType: auxInt64,
		argLen:  3,
		generic: true,
	},
	{
		name:    "Zero",
		auxType: auxInt64,
		argLen:  2,
		generic: true,
	},
	{
		name:    "ClosureCall",
		auxType: auxInt64,
		argLen:  3,
		generic: true,
	},
	{
		name:    "StaticCall",
		auxType: auxSymOff,
		argLen:  1,
		generic: true,
	},
	{
		name:    "DeferCall",
		auxType: auxInt64,
		argLen:  1,
		generic: true,
	},
	{
		name:    "GoCall",
		auxType: auxInt64,
		argLen:  1,
		generic: true,
	},
	{
		name:    "InterCall",
		auxType: auxInt64,
		argLen:  2,
		generic: true,
	},
	{
		name:    "SignExt8to16",
		argLen:  1,
		generic: true,
	},
	{
		name:    "SignExt8to32",
		argLen:  1,
		generic: true,
	},
	{
		name:    "SignExt8to64",
		argLen:  1,
		generic: true,
	},
	{
		name:    "SignExt16to32",
		argLen:  1,
		generic: true,
	},
	{
		name:    "SignExt16to64",
		argLen:  1,
		generic: true,
	},
	{
		name:    "SignExt32to64",
		argLen:  1,
		generic: true,
	},
	{
		name:    "ZeroExt8to16",
		argLen:  1,
		generic: true,
	},
	{
		name:    "ZeroExt8to32",
		argLen:  1,
		generic: true,
	},
	{
		name:    "ZeroExt8to64",
		argLen:  1,
		generic: true,
	},
	{
		name:    "ZeroExt16to32",
		argLen:  1,
		generic: true,
	},
	{
		name:    "ZeroExt16to64",
		argLen:  1,
		generic: true,
	},
	{
		name:    "ZeroExt32to64",
		argLen:  1,
		generic: true,
	},
	{
		name:    "Trunc16to8",
		argLen:  1,
		generic: true,
	},
	{
		name:    "Trunc32to8",
		argLen:  1,
		generic: true,
	},
	{
		name:    "Trunc32to16",
		argLen:  1,
		generic: true,
	},
	{
		name:    "Trunc64to8",
		argLen:  1,
		generic: true,
	},
	{
		name:    "Trunc64to16",
		argLen:  1,
		generic: true,
	},
	{
		name:    "Trunc64to32",
		argLen:  1,
		generic: true,
	},
	{
		name:    "Cvt32to32F",
		argLen:  1,
		generic: true,
	},
	{
		name:    "Cvt32to64F",
		argLen:  1,
		generic: true,
	},
	{
		name:    "Cvt64to32F",
		argLen:  1,
		generic: true,
	},
	{
		name:    "Cvt64to64F",
		argLen:  1,
		generic: true,
	},
	{
		name:    "Cvt32Fto32",
		argLen:  1,
		generic: true,
	},
	{
		name:    "Cvt32Fto64",
		argLen:  1,
		generic: true,
	},
	{
		name:    "Cvt64Fto32",
		argLen:  1,
		generic: true,
	},
	{
		name:    "Cvt64Fto64",
		argLen:  1,
		generic: true,
	},
	{
		name:    "Cvt32Fto64F",
		argLen:  1,
		generic: true,
	},
	{
		name:    "Cvt64Fto32F",
		argLen:  1,
		generic: true,
	},
	{
		name:    "IsNonNil",
		argLen:  1,
		generic: true,
	},
	{
		name:    "IsInBounds",
		argLen:  2,
		generic: true,
	},
	{
		name:    "IsSliceInBounds",
		argLen:  2,
		generic: true,
	},
	{
		name:    "NilCheck",
		argLen:  2,
		generic: true,
	},
	{
		name:    "GetG",
		argLen:  1,
		generic: true,
	},
	{
		name:    "GetClosurePtr",
		argLen:  0,
		generic: true,
	},
	{
		name:    "ArrayIndex",
		auxType: auxInt64,
		argLen:  1,
		generic: true,
	},
	{
		name:    "PtrIndex",
		argLen:  2,
		generic: true,
	},
	{
		name:    "OffPtr",
		auxType: auxInt64,
		argLen:  1,
		generic: true,
	},
	{
		name:    "SliceMake",
		argLen:  3,
		generic: true,
	},
	{
		name:    "SlicePtr",
		argLen:  1,
		generic: true,
	},
	{
		name:    "SliceLen",
		argLen:  1,
		generic: true,
	},
	{
		name:    "SliceCap",
		argLen:  1,
		generic: true,
	},
	{
		name:    "ComplexMake",
		argLen:  2,
		generic: true,
	},
	{
		name:    "ComplexReal",
		argLen:  1,
		generic: true,
	},
	{
		name:    "ComplexImag",
		argLen:  1,
		generic: true,
	},
	{
		name:    "StringMake",
		argLen:  2,
		generic: true,
	},
	{
		name:    "StringPtr",
		argLen:  1,
		generic: true,
	},
	{
		name:    "StringLen",
		argLen:  1,
		generic: true,
	},
	{
		name:    "IMake",
		argLen:  2,
		generic: true,
	},
	{
		name:    "ITab",
		argLen:  1,
		generic: true,
	},
	{
		name:    "IData",
		argLen:  1,
		generic: true,
	},
	{
		name:    "StructMake0",
		argLen:  0,
		generic: true,
	},
	{
		name:    "StructMake1",
		argLen:  1,
		generic: true,
	},
	{
		name:    "StructMake2",
		argLen:  2,
		generic: true,
	},
	{
		name:    "StructMake3",
		argLen:  3,
		generic: true,
	},
	{
		name:    "StructMake4",
		argLen:  4,
		generic: true,
	},
	{
		name:    "StructSelect",
		auxType: auxInt64,
		argLen:  1,
		generic: true,
	},
	{
		name:    "StoreReg",
		argLen:  1,
		generic: true,
	},
	{
		name:    "LoadReg",
		argLen:  1,
		generic: true,
	},
	{
		name:    "FwdRef",
		auxType: auxSym,
		argLen:  0,
		generic: true,
	},
	{
		name:    "Unknown",
		argLen:  0,
		generic: true,
	},
	{
		name:    "VarDef",
		auxType: auxSym,
		argLen:  1,
		generic: true,
	},
	{
		name:    "VarKill",
		auxType: auxSym,
		argLen:  1,
		generic: true,
	},
	{
		name:    "VarLive",
		auxType: auxSym,
		argLen:  1,
		generic: true,
	},
	{
		name:    "KeepAlive",
		argLen:  2,
		generic: true,
	},
}

func (o Op) Asm() obj.As    { return opcodeTable[o].asm }
func (o Op) String() string { return opcodeTable[o].name }

var registersAMD64 = [...]Register{
	{0, "AX"},
	{1, "CX"},
	{2, "DX"},
	{3, "BX"},
	{4, "SP"},
	{5, "BP"},
	{6, "SI"},
	{7, "DI"},
	{8, "R8"},
	{9, "R9"},
	{10, "R10"},
	{11, "R11"},
	{12, "R12"},
	{13, "R13"},
	{14, "R14"},
	{15, "R15"},
	{16, "X0"},
	{17, "X1"},
	{18, "X2"},
	{19, "X3"},
	{20, "X4"},
	{21, "X5"},
	{22, "X6"},
	{23, "X7"},
	{24, "X8"},
	{25, "X9"},
	{26, "X10"},
	{27, "X11"},
	{28, "X12"},
	{29, "X13"},
	{30, "X14"},
	{31, "X15"},
	{32, "SB"},
	{33, "FLAGS"},
}
var registersARM = [...]Register{
	{0, "R0"},
	{1, "R1"},
	{2, "R2"},
	{3, "R3"},
	{4, "SP"},
	{5, "FLAGS"},
	{6, "SB"},
}
