/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.image;

import java.awt.image.BufferedImage;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.OutputStream;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.resources.Messages;
import org.apache.batik.transcoder.keys.FloatKey;
import org.apache.batik.transcoder.keys.IntegerKey;

public class PNGTranscoder
extends ImageTranscoder {
    public static final TranscodingHints.Key KEY_GAMMA = new FloatKey();
    public static final float[] DEFAULT_CHROMA = new float[]{0.3127f, 0.329f, 0.64f, 0.33f, 0.3f, 0.6f, 0.15f, 0.06f};
    public static final TranscodingHints.Key KEY_INDEXED = new IntegerKey();

    public PNGTranscoder() {
        this.hints.put(KEY_FORCE_TRANSPARENT_WHITE, Boolean.FALSE);
    }

    public UserAgent getUserAgent() {
        return this.userAgent;
    }

    @Override
    public BufferedImage createImage(int n, int n2) {
        return new BufferedImage(n, n2, 2);
    }

    private WriteAdapter getWriteAdapter(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            WriteAdapter writeAdapter = (WriteAdapter)clazz.newInstance();
            return writeAdapter;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    @Override
    public void writeImage(BufferedImage bufferedImage, TranscoderOutput transcoderOutput) throws TranscoderException {
        Object object;
        OutputStream outputStream = transcoderOutput.getOutputStream();
        if (outputStream == null) {
            throw new TranscoderException(Messages.formatMessage("png.badoutput", null));
        }
        boolean bl = false;
        if (this.hints.containsKey(KEY_FORCE_TRANSPARENT_WHITE)) {
            bl = (Boolean)this.hints.get(KEY_FORCE_TRANSPARENT_WHITE);
        }
        if (bl) {
            object = (SinglePixelPackedSampleModel)bufferedImage.getSampleModel();
            this.forceTransparentWhite(bufferedImage, (SinglePixelPackedSampleModel)object);
        }
        if ((object = this.getWriteAdapter("org.apache.batik.ext.awt.image.codec.png.PNGTranscoderInternalCodecWriteAdapter")) == null) {
            object = this.getWriteAdapter("org.apache.batik.transcoder.image.PNGTranscoderImageIOWriteAdapter");
        }
        if (object == null) {
            throw new TranscoderException("Could not write PNG file because no WriteAdapter is availble");
        }
        object.writeImage(this, bufferedImage, transcoderOutput);
    }

    public static interface WriteAdapter {
        public void writeImage(PNGTranscoder var1, BufferedImage var2, TranscoderOutput var3) throws TranscoderException;
    }
}

