/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.history;

import java.util.List;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.SiteMap;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.view.messagecontainer.http.HttpMessageContainer;
import org.zaproxy.zap.view.popup.PopupMenuItemHttpMessageContainer;
import org.zaproxy.zap.view.popup.PopupMenuItemSiteNodeContainer;

public class PopupMenuPurgeSites
extends PopupMenuItemSiteNodeContainer {
    private static final long serialVersionUID = 4827464631678110752L;

    public PopupMenuPurgeSites() {
        super(Constant.messages.getString("sites.purge.popup"), true);
    }

    @Override
    public boolean isEnableForInvoker(PopupMenuItemHttpMessageContainer.Invoker invoker, HttpMessageContainer httpMessageContainer) {
        return invoker == PopupMenuItemHttpMessageContainer.Invoker.SITES_PANEL;
    }

    @Override
    public boolean isButtonEnabledForSiteNode(SiteNode siteNode) {
        return !siteNode.isRoot() || siteNode.getChildCount() != 0;
    }

    @Override
    public void performHistoryReferenceActions(List<HistoryReference> list) {
        int n;
        if (list.size() > 0 && (n = View.getSingleton().showConfirmDialog(Constant.messages.getString("sites.purge.warning"))) != 0) {
            return;
        }
        super.performHistoryReferenceActions(list);
    }

    @Override
    public void performAction(SiteNode siteNode) {
        ExtensionHistory extensionHistory = Control.getSingleton().getExtensionLoader().getExtension(ExtensionHistory.class);
        if (extensionHistory != null) {
            extensionHistory.purge(Model.getSingleton().getSession().getSiteTree(), siteNode);
        }
    }

    @Deprecated
    public static void purge(SiteMap siteMap, SiteNode siteNode) {
        ExtensionHistory extensionHistory = Control.getSingleton().getExtensionLoader().getExtension(ExtensionHistory.class);
        if (extensionHistory != null) {
            extensionHistory.purge(siteMap, siteNode);
        }
    }

    @Override
    public boolean isSafe() {
        return true;
    }
}

