/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.Utils;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.scene.Node;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;

public class ComboBoxBaseBehavior<T>
extends BehaviorBase<ComboBoxBase<T>> {
    private boolean keyDown;
    private static final String PRESS_ACTION = "Press";
    private static final String RELEASE_ACTION = "Release";
    protected static final List<KeyBinding> COMBO_BOX_BASE_BINDINGS = new ArrayList<KeyBinding>();
    boolean wasComboBoxButtonClickedForAutoHide = false;
    boolean mouseInsideButton = false;

    public ComboBoxBaseBehavior(ComboBoxBase<T> comboBoxBase) {
        super(comboBoxBase);
        InvalidationListener invalidationListener = new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                if (ComboBoxBaseBehavior.this.keyDown && !((ComboBoxBase)ComboBoxBaseBehavior.this.getControl()).isFocused()) {
                    ComboBoxBaseBehavior.this.keyDown = false;
                    ((ComboBoxBase)ComboBoxBaseBehavior.this.getControl()).disarm();
                }
            }
        };
        ((ComboBoxBase)this.getControl()).focusedProperty().addListener(invalidationListener);
    }

    @Override
    protected List<KeyBinding> createKeyBindings() {
        return COMBO_BOX_BASE_BINDINGS;
    }

    @Override
    protected void callAction(String string) {
        if (PRESS_ACTION.equals(string)) {
            this.keyPressed();
        } else if (RELEASE_ACTION.equals(string)) {
            this.keyReleased();
        } else if ("showPopup".equals(string)) {
            this.show();
        } else if ("togglePopup".equals(string)) {
            if (((ComboBoxBase)this.getControl()).isShowing()) {
                this.hide();
            } else {
                this.show();
            }
        } else {
            super.callAction(string);
        }
    }

    private void keyPressed() {
        if (!((ComboBoxBase)this.getControl()).isPressed() && !((ComboBoxBase)this.getControl()).isArmed()) {
            this.keyDown = true;
            ((ComboBoxBase)this.getControl()).arm();
        }
    }

    private void keyReleased() {
        if (this.keyDown) {
            this.keyDown = false;
            if (((ComboBoxBase)this.getControl()).isArmed()) {
                ((ComboBoxBase)this.getControl()).disarm();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        this.getFocus();
        this.arm(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        this.disarm();
        if (((ComboBoxBase)this.getControl()).isShowing()) {
            this.hide();
        } else if (!this.wasComboBoxButtonClickedForAutoHide && ((ComboBoxBase)this.getControl()).contains(mouseEvent.getX(), mouseEvent.getY())) {
            this.show();
        } else {
            this.wasComboBoxButtonClickedForAutoHide = false;
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        Node node;
        this.mouseInsideButton = ((ComboBoxBase)this.getControl()).isEditable() ? (node = ((ComboBoxBase)this.getControl()).lookup("#arrow-button")) != null && node.localToScene(node.getBoundsInLocal()).contains(mouseEvent.getSceneX(), mouseEvent.getSceneY()) : true;
        super.mouseEntered(mouseEvent);
        this.arm();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseInsideButton = false;
        super.mouseExited(mouseEvent);
        this.disarm();
    }

    private void getFocus() {
        if (!((ComboBoxBase)this.getControl()).isFocused() && ((ComboBoxBase)this.getControl()).isFocusTraversable()) {
            ((ComboBoxBase)this.getControl()).requestFocus();
        }
    }

    private void arm(MouseEvent mouseEvent) {
        boolean bl;
        boolean bl2 = bl = mouseEvent.getButton() == MouseButton.PRIMARY && !mouseEvent.isMiddleButtonDown() && !mouseEvent.isSecondaryButtonDown() && !mouseEvent.isShiftDown() && !mouseEvent.isControlDown() && !mouseEvent.isAltDown() && !mouseEvent.isMetaDown();
        if (!((ComboBoxBase)this.getControl()).isArmed() && bl) {
            ((ComboBoxBase)this.getControl()).arm();
        }
    }

    public void show() {
        if (!((ComboBoxBase)this.getControl()).isShowing()) {
            ((ComboBoxBase)this.getControl()).show();
        }
    }

    public void hide() {
        if (((ComboBoxBase)this.getControl()).isShowing()) {
            ((ComboBoxBase)this.getControl()).hide();
        }
    }

    public void onAutoHide() {
        this.wasComboBoxButtonClickedForAutoHide = this.mouseInsideButton;
        this.hide();
    }

    public void arm() {
        if (((ComboBoxBase)this.getControl()).isPressed()) {
            ((ComboBoxBase)this.getControl()).arm();
        }
    }

    public void disarm() {
        if (!this.keyDown && ((ComboBoxBase)this.getControl()).isArmed()) {
            ((ComboBoxBase)this.getControl()).disarm();
        }
    }

    static {
        COMBO_BOX_BASE_BINDINGS.add(new KeyBinding(KeyCode.F4, KeyEvent.KEY_RELEASED, "togglePopup"));
        COMBO_BOX_BASE_BINDINGS.add(new KeyBinding(KeyCode.UP, "togglePopup").alt());
        COMBO_BOX_BASE_BINDINGS.add(new KeyBinding(KeyCode.DOWN, "togglePopup").alt());
        if (Utils.isWindows()) {
            COMBO_BOX_BASE_BINDINGS.add(new KeyBinding(KeyCode.ENTER, KeyEvent.KEY_PRESSED, PRESS_ACTION));
            COMBO_BOX_BASE_BINDINGS.add(new KeyBinding(KeyCode.ENTER, KeyEvent.KEY_RELEASED, RELEASE_ACTION));
            COMBO_BOX_BASE_BINDINGS.add(new KeyBinding(KeyCode.SPACE, KeyEvent.KEY_PRESSED, PRESS_ACTION));
            COMBO_BOX_BASE_BINDINGS.add(new KeyBinding(KeyCode.SPACE, KeyEvent.KEY_RELEASED, RELEASE_ACTION));
        } else {
            COMBO_BOX_BASE_BINDINGS.add(new KeyBinding(KeyCode.SPACE, KeyEvent.KEY_PRESSED, PRESS_ACTION));
            COMBO_BOX_BASE_BINDINGS.add(new KeyBinding(KeyCode.SPACE, KeyEvent.KEY_RELEASED, RELEASE_ACTION));
        }
        COMBO_BOX_BASE_BINDINGS.addAll(TRAVERSAL_BINDINGS);
    }
}

