/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.platform.java;

import com.oracle.truffle.api.CompilerDirectives;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import jnr.constants.platform.Errno;
import jnr.constants.platform.Fcntl;
import jnr.constants.platform.OpenFlags;
import jnr.posix.FileStat;
import jnr.posix.POSIX;
import org.jruby.truffle.platform.java.TruffleJavaFileStat;
import org.jruby.truffle.platform.posix.JNRTrufflePosix;

public class JavaTrufflePosix
extends JNRTrufflePosix {
    private static final int STDIN = 0;
    private static final int STDOUT = 1;
    private static final int STDERR = 2;
    private final AtomicInteger nextFileHandle = new AtomicInteger(3);
    private final Map<Integer, OpenFile> fileHandles = new ConcurrentHashMap<Integer, OpenFile>();

    public JavaTrufflePosix(POSIX delegateTo) {
        super(delegateTo);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int fcntlInt(int fd, Fcntl fcntlConst, int arg) {
        if (fcntlConst.longValue() == Fcntl.F_GETFL.longValue()) {
            switch (fd) {
                case 0: {
                    return OpenFlags.O_RDONLY.intValue();
                }
                case 1: 
                case 2: {
                    return OpenFlags.O_WRONLY.intValue();
                }
            }
            OpenFile openFile = this.fileHandles.get(fd);
            if (openFile != null) {
                return openFile.getFlags();
            }
        }
        return super.fcntlInt(fd, fcntlConst, arg);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int open(CharSequence path, int flags, int perm) {
        RandomAccessFile randomAccessFile;
        String mode;
        if (perm != 438) {
            return super.open(path, flags, perm);
        }
        int fileHandle = this.nextFileHandle.getAndIncrement();
        if (fileHandle < 0) {
            throw new UnsupportedOperationException();
        }
        int basicMode = flags & 3;
        if (basicMode == OpenFlags.O_RDONLY.intValue()) {
            mode = "r";
        } else if (basicMode == OpenFlags.O_WRONLY.intValue()) {
            mode = "w";
        } else if (basicMode == OpenFlags.O_RDWR.intValue()) {
            mode = "rw";
        } else {
            return super.open(path, flags, perm);
        }
        try {
            randomAccessFile = new RandomAccessFile(path.toString(), mode);
        }
        catch (FileNotFoundException e) {
            return -1;
        }
        this.fileHandles.put(fileHandle, new OpenFile(randomAccessFile, flags));
        return fileHandle;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int read(int fd, ByteBuffer buf, int n) {
        return this.pread(fd, buf.array(), n, buf.arrayOffset());
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int read(int fd, byte[] buf, int n) {
        return this.pread(fd, buf, n, 0);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int write(int fd, ByteBuffer buf, int n) {
        return this.pwrite(fd, buf.array(), n, buf.arrayOffset());
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int write(int fd, byte[] buf, int n) {
        return this.pwrite(fd, buf, n, 0);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int close(int fd) {
        OpenFile openFile = this.fileHandles.get(fd);
        if (openFile != null) {
            this.fileHandles.remove(fd);
            try {
                openFile.getRandomAccessFile().close();
            }
            catch (IOException e) {
                return -1;
            }
            return 0;
        }
        return super.close(fd);
    }

    @Override
    public int getgid() {
        return 0;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public FileStat allocateStat() {
        return new TruffleJavaFileStat(this.getPosix(), null);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String getenv(String envName) {
        String javaValue = System.getenv(envName);
        if (javaValue != null) {
            return javaValue;
        }
        return super.getenv(envName);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int isatty(int fd) {
        return System.console() != null ? 1 : 0;
    }

    @CompilerDirectives.TruffleBoundary
    private int pwrite(int fd, byte[] buf, int n, int offset) {
        if (fd == 1 || fd == 2) {
            PrintStream stream;
            switch (fd) {
                case 1: {
                    stream = System.out;
                    break;
                }
                case 2: {
                    stream = System.err;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            stream.write(buf, offset, n);
            return n;
        }
        throw new UnsupportedOperationException();
    }

    @CompilerDirectives.TruffleBoundary
    private int pread(int fd, byte[] buf, int n, int offset) {
        if (fd == 0) {
            try {
                System.in.read(buf, offset, n);
            }
            catch (IOException e) {
                return -1;
            }
            return n;
        }
        OpenFile openFile = this.fileHandles.get(fd);
        if (openFile != null) {
            int read;
            try {
                read = openFile.getRandomAccessFile().read(buf, offset, n);
            }
            catch (IOException e) {
                return -1;
            }
            if (read == -1) {
                this.errno(Errno.ETIMEDOUT.intValue());
            }
            return read;
        }
        throw new UnsupportedOperationException();
    }

    private static class OpenFile {
        private final RandomAccessFile randomAccessFile;
        private final int flags;

        private OpenFile(RandomAccessFile randomAccessFile, int flags) {
            this.randomAccessFile = randomAccessFile;
            this.flags = flags;
        }

        public RandomAccessFile getRandomAccessFile() {
            return this.randomAccessFile;
        }

        public int getFlags() {
            return this.flags;
        }
    }
}

