/*
 * Decompiled with CFR 0.152.
 */
package dguitar.codecs.guitarPro.statistics;

import common.Util;
import dguitar.codecs.guitarPro.GPEffectsOnNote;
import dguitar.codecs.guitarPro.statistics.GPStats;

public class GPStatsEffectsOnNote
extends GPStats {
    public int numBends;
    public int numGraceNotes;
    public int numTremoloPicks;
    public int numSlides;
    public int numHarmonics;
    public int numTrills;
    public int numLetRing;
    public int numHammerOnPullOff;
    public int numLeftHandVibrato;
    public int numPalmMute;
    public int numStaccato;
    public int nn;

    public GPStatsEffectsOnNote() {
        this.nn = 0;
        this.numBends = 0;
        this.numGraceNotes = 0;
        this.numTremoloPicks = 0;
        this.numSlides = 0;
        this.numHarmonics = 0;
        this.numTrills = 0;
        this.numLetRing = 0;
        this.numHammerOnPullOff = 0;
        this.numLeftHandVibrato = 0;
        this.numPalmMute = 0;
        this.numStaccato = 0;
    }

    public GPStatsEffectsOnNote(GPEffectsOnNote EON) {
        this.nn = 1;
        this.numBends = EON.bend != null ? 1 : 0;
        this.numGraceNotes = EON.graceNote != null ? 1 : 0;
        this.numTremoloPicks = EON.tremoloPicking != null ? 1 : 0;
        this.numSlides = EON.slide != null ? 1 : 0;
        this.numHarmonics = EON.harmonic != null ? 1 : 0;
        this.numTrills = EON.trill != null ? 1 : 0;
        this.numLetRing = EON.letRing ? 1 : 0;
        this.numHammerOnPullOff = EON.hammerOnPullOff ? 1 : 0;
        this.numLeftHandVibrato = EON.leftHandVibrato ? 1 : 0;
        this.numPalmMute = EON.palmMute ? 1 : 0;
        this.numStaccato = EON.staccato ? 1 : 0;
    }

    void add(GPStatsEffectsOnNote a) {
        if (a != null) {
            this.nn += a.nn;
            this.numBends += a.numBends;
            this.numGraceNotes += a.numGraceNotes;
            this.numTremoloPicks += a.numTremoloPicks;
            this.numSlides += a.numSlides;
            this.numHarmonics += a.numHarmonics;
            this.numTrills += a.numTrills;
            this.numLetRing += a.numLetRing;
            this.numHammerOnPullOff += a.numHammerOnPullOff;
            this.numLeftHandVibrato += a.numLeftHandVibrato;
            this.numPalmMute += a.numPalmMute;
            this.numStaccato += a.numStaccato;
        }
    }

    public String toString() {
        String res = "";
        String aux = "notes";
        res = String.valueOf(res) + Util.tabs(level) + this.nn + " " + aux + "\n";
        ++level;
        res = String.valueOf(res) + this.stringFor(this.numBends, "bends", this.nn, aux);
        res = String.valueOf(res) + this.stringFor(this.numGraceNotes, "grace notes", this.nn, aux);
        res = String.valueOf(res) + this.stringFor(this.numTremoloPicks, "tremolo picks", this.nn, aux);
        res = String.valueOf(res) + this.stringFor(this.numSlides, "slides", this.nn, aux);
        res = String.valueOf(res) + this.stringFor(this.numHarmonics, "harmonics", this.nn, aux);
        res = String.valueOf(res) + this.stringFor(this.numTrills, "trills", this.nn, aux);
        res = String.valueOf(res) + this.stringFor(this.numLetRing, "letRings", this.nn, aux);
        res = String.valueOf(res) + this.stringFor(this.numHammerOnPullOff, "hammerOn-PullOffs", this.nn, aux);
        res = String.valueOf(res) + this.stringFor(this.numLeftHandVibrato, "left Hand Vibratos", this.nn, aux);
        res = String.valueOf(res) + this.stringFor(this.numPalmMute, "palm Multes", this.nn, aux);
        res = String.valueOf(res) + this.stringFor(this.numStaccato, "staccatos", this.nn, aux);
        --level;
        return res;
    }
}

