/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.iq80.snappy.Snappy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.ThreadLocalCachedByteArray;
import org.jetbrains.kotlin.com.intellij.util.SystemProperties;
import org.jetbrains.kotlin.com.intellij.util.io.DataInputOutputUtil;

public class CompressionUtil {
    private static final ThreadLocalCachedByteArray spareBufferLocal = new ThreadLocalCachedByteArray();
    private static final AtomicInteger myCompressionRequests = new AtomicInteger();
    private static final AtomicLong myCompressionTime = new AtomicLong();
    private static final AtomicInteger myDecompressionRequests = new AtomicInteger();
    private static final AtomicLong myDecompressionTime = new AtomicLong();
    private static final AtomicLong myDecompressedSize = new AtomicLong();
    private static final AtomicLong mySizeBeforeCompression = new AtomicLong();
    private static final AtomicLong mySizeAfterCompression = new AtomicLong();
    public static final boolean DUMP_COMPRESSION_STATS = SystemProperties.getBooleanProperty("idea.dump.compression.stats", false);

    public static int writeCompressedWithoutOriginalBufferLength(@NotNull DataOutput out, @NotNull byte[] bytes, int length) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/kotlin/com/intellij/util/CompressionUtil", "writeCompressedWithoutOriginalBufferLength"));
        }
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "org/jetbrains/kotlin/com/intellij/util/CompressionUtil", "writeCompressedWithoutOriginalBufferLength"));
        }
        long started = DUMP_COMPRESSION_STATS ? System.nanoTime() : 0L;
        byte[] compressedOutputBuffer = spareBufferLocal.getBuffer(Snappy.maxCompressedLength(length));
        int compressedSize = Snappy.compress(bytes, 0, length, compressedOutputBuffer, 0);
        long time = (DUMP_COMPRESSION_STATS ? System.nanoTime() : 0L) - started;
        mySizeAfterCompression.addAndGet(compressedSize);
        mySizeBeforeCompression.addAndGet(length);
        int requests = myCompressionRequests.incrementAndGet();
        long l = myCompressionTime.addAndGet(time);
        if (DUMP_COMPRESSION_STATS && requests % 1000 == 0) {
            System.out.println("Compressed " + requests + " times, size:" + mySizeBeforeCompression + "->" + mySizeAfterCompression + " for " + l / 1000000L + "ms");
        }
        DataInputOutputUtil.writeINT(out, compressedSize);
        out.write(compressedOutputBuffer, 0, compressedSize);
        return compressedSize;
    }

    @NotNull
    public static byte[] readCompressedWithoutOriginalBufferLength(@NotNull DataInput in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "org/jetbrains/kotlin/com/intellij/util/CompressionUtil", "readCompressedWithoutOriginalBufferLength"));
        }
        int size = DataInputOutputUtil.readINT(in);
        byte[] bytes = spareBufferLocal.getBuffer(size);
        in.readFully(bytes, 0, size);
        int decompressedRequests = myDecompressionRequests.incrementAndGet();
        long started = DUMP_COMPRESSION_STATS ? System.nanoTime() : 0L;
        byte[] decompressedResult = Snappy.uncompress(bytes, 0, size);
        long doneTime = (DUMP_COMPRESSION_STATS ? System.nanoTime() : 0L) - started;
        long decompressedSize = myDecompressedSize.addAndGet(size);
        long decompressedTime = myDecompressionTime.addAndGet(doneTime);
        if (DUMP_COMPRESSION_STATS && decompressedRequests % 1000 == 0) {
            System.out.println("Decompressed " + decompressedRequests + " times, size: " + decompressedSize + " for " + decompressedTime / 1000000L + "ms");
        }
        if (decompressedResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/CompressionUtil", "readCompressedWithoutOriginalBufferLength"));
        }
        return decompressedResult;
    }
}

