/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.ide.IconProvider;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.kotlin.com.intellij.openapi.project.DumbService;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;

public class PsiIconUtil {
    @Nullable
    public static Icon getProvidersIcon(@NotNull PsiElement element, int flags) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/util/PsiIconUtil", "getProvidersIcon"));
        }
        boolean dumb = DumbService.getInstance(element.getProject()).isDumb();
        for (IconProvider iconProvider : PsiIconUtil.getIconProviders()) {
            Icon icon;
            if (dumb && !DumbService.isDumbAware(iconProvider) || (icon = iconProvider.getIcon(element, flags)) == null) continue;
            return icon;
        }
        return null;
    }

    private static IconProvider[] getIconProviders() {
        return IconProviderHolder.ourIconProviders;
    }

    private static class IconProviderHolder {
        private static final IconProvider[] ourIconProviders = Extensions.getExtensions(IconProvider.EXTENSION_POINT_NAME);
    }
}

