/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.coroutines;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.FakeCallKind;
import org.jetbrains.kotlin.types.expressions.FakeCallResolver;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=2, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u0006\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\u0001\u001a0\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0013"}, d2={"controllerTypeIfCoroutine", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "getControllerTypeIfCoroutine", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;)Lorg/jetbrains/kotlin/types/KotlinType;", "getExpectedTypeForCoroutineControllerHandleResult", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "isValidContinuation", "", "resolveCoroutineHandleResultCallIfNeeded", "", "Lorg/jetbrains/kotlin/types/expressions/FakeCallResolver;", "callElement", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expressionToReturn", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "kotlin-compiler"})
public final class CoroutineUtilKt {
    @Nullable
    public static final KotlinType getExpectedTypeForCoroutineControllerHandleResult(@NotNull SimpleFunctionDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if (!$receiver.isOperator() || Intrinsics.areEqual($receiver.getName(), OperatorNameConventions.COROUTINE_HANDLE_RESULT) ^ true) {
            return null;
        }
        ValueParameterDescriptor valueParameterDescriptor = CollectionsKt.getOrNull($receiver.getValueParameters(), 0);
        return valueParameterDescriptor != null ? valueParameterDescriptor.getType() : null;
    }

    @Nullable
    public static final KotlinType getControllerTypeIfCoroutine(@NotNull CallableDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if (!($receiver instanceof AnonymousFunctionDescriptor) || !((AnonymousFunctionDescriptor)$receiver).isCoroutine()) {
            return null;
        }
        ReceiverParameterDescriptor receiverParameterDescriptor = ((AnonymousFunctionDescriptor)$receiver).getExtensionReceiverParameter();
        return receiverParameterDescriptor != null ? receiverParameterDescriptor.getReturnType() : null;
    }

    public static final void resolveCoroutineHandleResultCallIfNeeded(@NotNull FakeCallResolver $receiver, @NotNull KtExpression callElement, @Nullable KtExpression expressionToReturn, @NotNull FunctionDescriptor functionDescriptor, @NotNull ResolutionContext<?> context) {
        KtExpression firstArgument;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(callElement, "callElement");
        Intrinsics.checkParameterIsNotNull(functionDescriptor, "functionDescriptor");
        Intrinsics.checkParameterIsNotNull(context, "context");
        if (CoroutineUtilKt.getControllerTypeIfCoroutine(functionDescriptor) == null) {
            return;
        }
        KotlinTypeInfo info = expressionToReturn != null ? (KotlinTypeInfo)context.trace.getBindingContext().get(BindingContext.EXPRESSION_TYPE_INFO, expressionToReturn) : (KotlinTypeInfo)null;
        TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(context.trace, "trace to store fake argument for", "continuation");
        KtExpression continuation = ExpressionTypingUtils.createFakeExpressionOfType(callElement.getProject(), temporaryBindingTrace, "continuation", DescriptorUtilsKt.getBuiltIns(functionDescriptor).getNothingType());
        Function1<KtExpression, Boolean> tryToResolveCall$ = new Function1<KtExpression, Boolean>($receiver, context, temporaryBindingTrace, functionDescriptor, callElement, continuation){
            final /* synthetic */ FakeCallResolver receiver$0;
            final /* synthetic */ ResolutionContext $context;
            final /* synthetic */ TemporaryBindingTrace $temporaryBindingTrace;
            final /* synthetic */ FunctionDescriptor $functionDescriptor;
            final /* synthetic */ KtExpression $callElement;
            final /* synthetic */ KtExpression $continuation;

            public final boolean invoke(@NotNull KtExpression firstArgument) {
                Intrinsics.checkParameterIsNotNull(firstArgument, "firstArgument");
                Context Context2 = this.$context.replaceBindingTrace(this.$temporaryBindingTrace);
                Intrinsics.checkExpressionValueIsNotNull(Context2, "context.replaceBindingTrace(temporaryBindingTrace)");
                ReceiverParameterDescriptor receiverParameterDescriptor = this.$functionDescriptor.getExtensionReceiverParameter();
                if (receiverParameterDescriptor == null) {
                    Intrinsics.throwNpe();
                }
                ReceiverValue receiverValue = receiverParameterDescriptor.getValue();
                Name name2 = OperatorNameConventions.COROUTINE_HANDLE_RESULT;
                Intrinsics.checkExpressionValueIsNotNull(name2, "OperatorNameConventions.COROUTINE_HANDLE_RESULT");
                OverloadResolutionResults<FunctionDescriptor> resolutionResults = this.receiver$0.resolveFakeCall((ResolutionContext<?>)Context2, receiverValue, name2, this.$callElement, this.$callElement, FakeCallKind.OTHER, (List<? extends KtExpression>)CollectionsKt.listOf(new KtExpression[]{firstArgument, this.$continuation}));
                if (resolutionResults.isSuccess() && resolutionResults.getResultingDescriptor().isOperator()) {
                    this.$context.trace.record(BindingContext.RETURN_HANDLE_RESULT_RESOLVED_CALL, this.$callElement, resolutionResults.getResultingCall());
                    return true;
                }
                return false;
            }
            {
                this.receiver$0 = fakeCallResolver;
                this.$context = resolutionContext;
                this.$temporaryBindingTrace = temporaryBindingTrace;
                this.$functionDescriptor = functionDescriptor;
                this.$callElement = ktExpression;
                this.$continuation = ktExpression2;
                super(1);
            }
        };
        KtExpression unitExpression = ExpressionTypingUtils.createFakeExpressionOfType(callElement.getProject(), temporaryBindingTrace, "unit", DescriptorUtilsKt.getBuiltIns(functionDescriptor).getUnitType());
        KtExpression ktExpression = firstArgument = expressionToReturn == null || info != null && info.getType() != null && KotlinBuiltIns.isUnit(info.getType()) ? unitExpression : expressionToReturn;
        Intrinsics.checkExpressionValueIsNotNull(ktExpression, "firstArgument");
        if (!tryToResolveCall$.invoke(ktExpression) && firstArgument == expressionToReturn) {
            KtExpression ktExpression2 = unitExpression;
            Intrinsics.checkExpressionValueIsNotNull(ktExpression2, "unitExpression");
            tryToResolveCall$.invoke(ktExpression2);
        }
    }

    public static final boolean isValidContinuation(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ClassifierDescriptor classifierDescriptor = $receiver.getConstructor().getDeclarationDescriptor();
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
        return Intrinsics.areEqual(classDescriptor != null ? DescriptorUtilsKt.getFqNameUnsafe(classDescriptor) : null, DescriptorUtils.CONTINUATION_INTERFACE_FQ_NAME.toUnsafe());
    }
}

