/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.http.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang.IncompleteArgumentException;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.gradle.caching.BuildCache;
import org.gradle.caching.BuildCacheEntryReader;
import org.gradle.caching.BuildCacheEntryWriter;
import org.gradle.caching.BuildCacheException;
import org.gradle.caching.BuildCacheKey;
import org.gradle.internal.UncheckedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpBuildCache
implements BuildCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpBuildCache.class);
    private final URI root;
    private final URI safeUri;
    private final CloseableHttpClient httpClient;

    public HttpBuildCache(URI root) {
        if (!root.getPath().endsWith("/")) {
            throw new IncompleteArgumentException("HTTP cache root URI must end with '/'");
        }
        this.root = root;
        this.safeUri = HttpBuildCache.safeUri(root);
        this.httpClient = HttpClients.createDefault();
    }

    public boolean load(BuildCacheKey key, BuildCacheEntryReader reader) throws BuildCacheException {
        int statusCode;
        StatusLine statusLine;
        CloseableHttpResponse response;
        block8: {
            block7: {
                URI uri = this.root.resolve("./" + key.getHashCode());
                HttpGet httpGet = new HttpGet(uri);
                response = null;
                response = this.httpClient.execute((HttpUriRequest)httpGet);
                statusLine = response.getStatusLine();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Response for GET {}: {}", (Object)HttpBuildCache.safeUri(uri), (Object)statusLine);
                }
                if ((statusCode = statusLine.getStatusCode()) < 200 || statusCode >= 300) break block7;
                reader.readFrom(response.getEntity().getContent());
                boolean bl = true;
                HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
                return bl;
            }
            if (statusCode != 404) break block8;
            boolean bl = false;
            HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
            return bl;
        }
        try {
            try {
                throw new BuildCacheException(String.format("For key '%s', using %s response status %d: %s", key, this.getDescription(), statusCode, statusLine.getReasonPhrase()));
            }
            catch (IOException e) {
                throw new BuildCacheException(String.format("loading key '%s' from %s", key, this.getDescription()), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            HttpClientUtils.closeQuietly(response);
            throw throwable;
        }
    }

    public void store(BuildCacheKey key, final BuildCacheEntryWriter output) throws BuildCacheException {
        URI uri = this.root.resolve(key.getHashCode());
        HttpPut httpPut = new HttpPut(uri);
        httpPut.setEntity((HttpEntity)new AbstractHttpEntity(){

            public boolean isRepeatable() {
                return true;
            }

            public long getContentLength() {
                return -1L;
            }

            public InputStream getContent() throws IOException, UnsupportedOperationException {
                throw new UnsupportedOperationException();
            }

            public void writeTo(OutputStream outstream) throws IOException {
                output.writeTo(outstream);
            }

            public boolean isStreaming() {
                return false;
            }
        });
        CloseableHttpResponse response = null;
        try {
            response = this.httpClient.execute((HttpUriRequest)httpPut);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Response for PUT {}: {}", (Object)HttpBuildCache.safeUri(uri), (Object)response.getStatusLine());
            }
        }
        catch (IOException e) {
            try {
                throw new BuildCacheException(String.format("storing key '%s' in %s", key, this.getDescription()), (Throwable)e);
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(response);
                throw throwable;
            }
        }
        HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
    }

    public String getDescription() {
        return "an HTTP build cache (" + this.safeUri + ")";
    }

    public void close() throws IOException {
        this.httpClient.close();
    }

    private static URI safeUri(URI uri) {
        try {
            return new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }
}

