/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal;

import com.google.common.base.Charsets;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Map;
import org.apache.commons.lang.SerializationUtils;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.BuildCacheKeyBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBuildCacheKeyBuilder
implements BuildCacheKeyBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultBuildCacheKeyBuilder.class);
    private final Hasher hasher = Hashing.md5().newHasher();

    public BuildCacheKeyBuilder putByte(byte b) {
        DefaultBuildCacheKeyBuilder.log("byte", b);
        this.hasher.putInt(1);
        this.hasher.putByte(b);
        return this;
    }

    public BuildCacheKeyBuilder putBytes(byte[] bytes) {
        DefaultBuildCacheKeyBuilder.log("bytes", new ByteArrayToStringer(bytes));
        this.hasher.putInt(bytes.length);
        this.hasher.putBytes(bytes);
        return this;
    }

    public BuildCacheKeyBuilder putBytes(byte[] bytes, int off, int len) {
        DefaultBuildCacheKeyBuilder.log("bytes", new ByteArrayToStringer(bytes, off, len));
        this.hasher.putInt(len);
        this.hasher.putBytes(bytes, off, len);
        return this;
    }

    public BuildCacheKeyBuilder putInt(int i) {
        DefaultBuildCacheKeyBuilder.log("int", i);
        this.hasher.putInt(4);
        this.hasher.putInt(i);
        return this;
    }

    public BuildCacheKeyBuilder putLong(long l) {
        DefaultBuildCacheKeyBuilder.log("long", l);
        this.hasher.putInt(8);
        this.hasher.putLong(l);
        return this;
    }

    public BuildCacheKeyBuilder putDouble(double d) {
        DefaultBuildCacheKeyBuilder.log("double", d);
        this.hasher.putInt(8);
        this.hasher.putDouble(d);
        return this;
    }

    public BuildCacheKeyBuilder putBoolean(boolean b) {
        DefaultBuildCacheKeyBuilder.log("boolean", b);
        this.hasher.putInt(1);
        this.hasher.putBoolean(b);
        return this;
    }

    public BuildCacheKeyBuilder putString(CharSequence charSequence) {
        DefaultBuildCacheKeyBuilder.log("string", charSequence);
        this.hasher.putInt(charSequence.length());
        this.hasher.putString(charSequence, Charsets.UTF_8);
        return this;
    }

    public BuildCacheKey build() {
        HashCode hashCode = this.hasher.hash();
        LOGGER.debug("Hash code generated: {}", (Object)hashCode);
        return new DefaultBuildCacheKey(hashCode);
    }

    private static void log(String type, Object value) {
        LOGGER.debug("Appending {} to cache key: {}", (Object)type, value);
    }

    public BuildCacheKeyBuilder appendToCacheKey(Object value) {
        if (value == null) {
            this.putString("$NULL");
            return this;
        }
        if (value.getClass().isArray()) {
            this.putString("Array");
            int len = Array.getLength(value);
            for (int idx = 0; idx < len; ++idx) {
                this.putInt(idx);
                this.appendToCacheKey(Array.get(value, idx));
            }
            return this;
        }
        if (value instanceof Iterable) {
            this.putString("Iterable");
            int idx = 0;
            for (Object elem : (Iterable)value) {
                this.putInt(idx);
                this.appendToCacheKey(elem);
                ++idx;
            }
            return this;
        }
        if (value instanceof Map) {
            this.putString("Map");
            int idx = 0;
            for (Map.Entry entry : ((Map)value).entrySet()) {
                this.putInt(idx);
                this.appendToCacheKey(entry.getKey());
                this.appendToCacheKey(entry.getValue());
                ++idx;
            }
            return this;
        }
        if (value instanceof Boolean) {
            this.putBoolean((Boolean)value);
        } else if (value instanceof Long) {
            this.putLong((Long)value);
        } else if (value instanceof Integer) {
            this.putInt((Integer)value);
        } else if (value instanceof Short) {
            this.putInt(((Short)value).shortValue());
        } else if (value instanceof Byte) {
            this.putInt(((Byte)value).byteValue());
        } else if (value instanceof Double) {
            this.putDouble((Double)value);
        } else if (value instanceof Float) {
            this.putDouble(((Float)value).floatValue());
        } else if (value instanceof BigInteger) {
            this.putBytes(((BigInteger)value).toByteArray());
        } else if (value instanceof CharSequence) {
            this.putString((CharSequence)value);
        } else if (value instanceof Enum) {
            this.putString(value.getClass().getName());
            this.putString(((Enum)value).name());
        } else {
            byte[] bytes = SerializationUtils.serialize((Serializable)((Serializable)value));
            this.putBytes(bytes);
        }
        return this;
    }

    private static class ByteArrayToStringer {
        private static final char[] HEX_DIGITS = "01234567890abcdef".toCharArray();
        private final byte[] bytes;
        private final int offset;
        private final int length;

        public ByteArrayToStringer(byte[] bytes) {
            this(bytes, 0, bytes.length);
        }

        public ByteArrayToStringer(byte[] bytes, int offset, int length) {
            this.bytes = bytes;
            this.offset = offset;
            this.length = length;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.bytes.length * 3);
            for (int idx = this.offset; idx < this.offset + this.length; ++idx) {
                byte b = this.bytes[idx];
                if (idx > 0) {
                    builder.append(':');
                }
                builder.append(HEX_DIGITS[b >>> 4 & 0xF]);
                builder.append(HEX_DIGITS[b & 0xF]);
            }
            return builder.toString();
        }
    }

    private static class DefaultBuildCacheKey
    implements BuildCacheKey {
        private final HashCode hashCode;

        public DefaultBuildCacheKey(HashCode hashCode) {
            this.hashCode = hashCode;
        }

        public String getHashCode() {
            return this.hashCode.toString();
        }

        public String toString() {
            return this.getHashCode();
        }
    }
}

