/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.incremental.components.NoLookupLocation;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.constants.AnnotationValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValueFactory;
import kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotationDeserializer$WhenMappings;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NotFoundClasses;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;

public final class AnnotationDeserializer {
    private final ConstantValueFactory factory;
    private final ModuleDescriptor module;
    private final NotFoundClasses notFoundClasses;

    private final KotlinBuiltIns getBuiltIns() {
        return this.module.getBuiltIns();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AnnotationDescriptor deserializeAnnotation(@NotNull ProtoBuf.Annotation proto, @NotNull NameResolver nameResolver) {
        ClassConstructorDescriptor constructor;
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        Intrinsics.checkParameterIsNotNull((Object)nameResolver, (String)"nameResolver");
        ClassId classId = nameResolver.getClassId(proto.getId());
        Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"nameResolver.getClassId(proto.id)");
        ClassDescriptor annotationClass = this.resolveClass(classId);
        Map arguments2 = MapsKt.emptyMap();
        if (proto.getArgumentCount() != 0 && !ErrorUtils.isError(annotationClass) && DescriptorUtils.isAnnotationClass(annotationClass) && (constructor = (ClassConstructorDescriptor)CollectionsKt.singleOrNull((Iterable)annotationClass.getConstructors())) != null) {
            void destination$iv$iv;
            void $receiver$iv$iv$iv;
            void $receiver$iv$iv;
            void destination$iv$iv2;
            Collection $receiver$iv$iv2;
            Iterable $receiver$iv;
            Iterable iterable = constructor.getValueParameters();
            int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
            void var8_9 = $receiver$iv;
            Map map2 = new LinkedHashMap(capacity$iv22);
            for (Object element$iv$iv : $receiver$iv$iv2) {
                void it;
                ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)element$iv$iv;
                void var13_14 = destination$iv$iv2;
                Name name2 = it.getName();
                var13_14.put(name2, element$iv$iv);
            }
            void parameterByName = destination$iv$iv2;
            $receiver$iv = proto.getArgumentList();
            Iterable capacity$iv22 = $receiver$iv;
            $receiver$iv$iv2 = new ArrayList();
            destination$iv$iv2 = $receiver$iv$iv;
            Iterator iterator2 = $receiver$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Pair<ValueParameterDescriptor, ConstantValue<?>> pair;
                ProtoBuf.Annotation.Argument it;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                ProtoBuf.Annotation.Argument argument = it = (ProtoBuf.Annotation.Argument)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)argument, (String)"it");
                if (this.resolveArgument(argument, (Map<Name, ? extends ValueParameterDescriptor>)parameterByName, nameResolver) == null) continue;
                Pair<ValueParameterDescriptor, ConstantValue<?>> it$iv$iv = pair;
                destination$iv$iv.add(it$iv$iv);
            }
            arguments2 = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        }
        return new AnnotationDescriptorImpl(annotationClass.getDefaultType(), arguments2, SourceElement.NO_SOURCE);
    }

    private final Pair<ValueParameterDescriptor, ConstantValue<?>> resolveArgument(ProtoBuf.Annotation.Argument proto, Map<Name, ? extends ValueParameterDescriptor> parameterByName, NameResolver nameResolver) {
        ValueParameterDescriptor valueParameterDescriptor = parameterByName.get(nameResolver.getName(proto.getNameId()));
        if (valueParameterDescriptor == null) {
            return null;
        }
        ValueParameterDescriptor parameter = valueParameterDescriptor;
        KotlinType kotlinType = parameter.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"parameter.type");
        ProtoBuf.Annotation.Argument.Value value = proto.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"proto.value");
        return new Pair((Object)parameter, this.resolveValue(kotlinType, value, nameResolver));
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final ConstantValue<?> resolveValue(@NotNull KotlinType expectedType, @NotNull ProtoBuf.Annotation.Argument.Value value, @NotNull NameResolver nameResolver) {
        Intrinsics.checkParameterIsNotNull((Object)expectedType, (String)"expectedType");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)nameResolver, (String)"nameResolver");
        v0 = value.getType();
        if (v0 == null) ** GOTO lbl-1000
        switch (AnnotationDeserializer$WhenMappings.$EnumSwitchMapping$0[v0.ordinal()]) {
            case 1: {
                v1 = this.factory.createByteValue((byte)value.getIntValue());
                break;
            }
            case 2: {
                v1 = this.factory.createCharValue((char)value.getIntValue());
                break;
            }
            case 3: {
                v1 = this.factory.createShortValue((short)value.getIntValue());
                break;
            }
            case 4: {
                v1 = this.factory.createIntValue((int)value.getIntValue());
                break;
            }
            case 5: {
                v1 = this.factory.createLongValue(value.getIntValue());
                break;
            }
            case 6: {
                v1 = this.factory.createFloatValue(value.getFloatValue());
                break;
            }
            case 7: {
                v1 = this.factory.createDoubleValue(value.getDoubleValue());
                break;
            }
            case 8: {
                v1 = this.factory.createBooleanValue(value.getIntValue() != 0L);
                break;
            }
            case 9: {
                v2 = nameResolver.getString(value.getStringValue());
                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"nameResolver.getString(value.stringValue)");
                v1 = this.factory.createStringValue(v2);
                break;
            }
            case 10: {
                var4_4 = "Class literal annotation arguments are not supported yet (" + nameResolver.getClassId(value.getClassId()) + ")";
                throw (Throwable)new IllegalStateException(var4_4.toString());
            }
            case 11: {
                v3 = nameResolver.getClassId(value.getClassId());
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"nameResolver.getClassId(value.classId)");
                v4 = nameResolver.getName(value.getEnumValueId());
                Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"nameResolver.getName(value.enumValueId)");
                v1 = this.resolveEnumValue(v3, v4);
                break;
            }
            case 12: {
                v5 = value.getAnnotation();
                Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"value.annotation");
                v1 = new AnnotationValue(this.deserializeAnnotation(v5, nameResolver));
                break;
            }
            case 13: {
                expectedIsArray = KotlinBuiltIns.isArray(expectedType) != false || KotlinBuiltIns.isPrimitiveArray(expectedType) != false;
                arrayElements = value.getArrayElementList();
                var6_8 = arrayElements;
                if (var6_8.isEmpty() == false) {
                    v6 = (ProtoBuf.Annotation.Argument.Value)CollectionsKt.first(arrayElements);
                    Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"arrayElements.first()");
                    actualElementType = this.resolveArrayElementType(v6, nameResolver);
                    v7 = this.getBuiltIns().getPrimitiveArrayKotlinTypeByPrimitiveKotlinType(actualElementType);
                    if (v7 != null) {
                        v8 = v7;
                    } else {
                        v9 = this.getBuiltIns().getArrayType(Variance.INVARIANT, actualElementType);
                        v8 = v9;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"builtIns.getArrayType(Va\u2026RIANT, actualElementType)");
                    }
                } else if (expectedIsArray) {
                    v8 = expectedType;
                } else {
                    v10 = this.getBuiltIns().getArrayType(Variance.INVARIANT, this.getBuiltIns().getAnyType());
                    v8 = v10;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"builtIns.getArrayType(Va\u2026T, builtIns.getAnyType())");
                }
                actualArrayType = v8;
                expectedElementType = this.getBuiltIns().getArrayElementType(expectedIsArray != false ? expectedType : actualArrayType);
                var8_10 = arrayElements;
                var9_11 = this.factory;
                var10_12 = $receiver$iv;
                var11_13 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    var14_16 = (ProtoBuf.Annotation.Argument.Value)item$iv$iv;
                    var15_17 = destination$iv$iv;
                    v11 = expectedElementType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v11, (String)"expectedElementType");
                    v12 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"it");
                    var16_18 = this.resolveValue(v11, (ProtoBuf.Annotation.Argument.Value)v12, nameResolver);
                    var15_17.add(var16_18);
                }
                var15_17 = (List)destination$iv$iv;
                v1 = var9_11.createArrayValue(var15_17, actualArrayType);
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                var4_6 = "Unsupported annotation argument type: " + value.getType() + " (expected " + expectedType + ")";
                throw (Throwable)new IllegalStateException(var4_6.toString());
            }
        }
        result = v1;
        if (TypeUtilsKt.isSubtypeOf(result.getType(), expectedType)) {
            return result;
        }
        return this.factory.createErrorValue("Unexpected argument value");
    }

    private final ConstantValue<?> resolveEnumValue(ClassId enumClassId, Name enumEntryName) {
        ClassifierDescriptor enumEntry;
        ClassDescriptor enumClass = this.resolveClass(enumClassId);
        if (Intrinsics.areEqual((Object)((Object)enumClass.getKind()), (Object)((Object)ClassKind.ENUM_CLASS)) && (enumEntry = enumClass.getUnsubstitutedInnerClassesScope().getContributedClassifier(enumEntryName, NoLookupLocation.FROM_DESERIALIZATION)) instanceof ClassDescriptor) {
            return this.factory.createEnumValue((ClassDescriptor)enumEntry);
        }
        return this.factory.createErrorValue("Unresolved enum entry: " + enumClassId + "." + enumEntryName);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final SimpleType resolveArrayElementType(ProtoBuf.Annotation.Argument.Value value, NameResolver nameResolver) {
        KotlinBuiltIns kotlinBuiltIns = this.getBuiltIns();
        KotlinBuiltIns kotlinBuiltIns2 = kotlinBuiltIns;
        ProtoBuf.Annotation.Argument.Value.Type type2 = value.getType();
        if (type2 != null) {
            switch (AnnotationDeserializer$WhenMappings.$EnumSwitchMapping$1[type2.ordinal()]) {
                case 1: {
                    void $receiver;
                    SimpleType simpleType2 = $receiver.getByteType();
                    SimpleType simpleType3 = simpleType2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"getByteType()");
                    return simpleType3;
                }
                case 2: {
                    void $receiver;
                    SimpleType simpleType4 = $receiver.getCharType();
                    SimpleType simpleType3 = simpleType4;
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType4, (String)"getCharType()");
                    return simpleType3;
                }
                case 3: {
                    void $receiver;
                    SimpleType simpleType5 = $receiver.getShortType();
                    SimpleType simpleType3 = simpleType5;
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType5, (String)"getShortType()");
                    return simpleType3;
                }
                case 4: {
                    void $receiver;
                    SimpleType simpleType6 = $receiver.getIntType();
                    SimpleType simpleType3 = simpleType6;
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType6, (String)"getIntType()");
                    return simpleType3;
                }
                case 5: {
                    void $receiver;
                    SimpleType simpleType7 = $receiver.getLongType();
                    SimpleType simpleType3 = simpleType7;
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType7, (String)"getLongType()");
                    return simpleType3;
                }
                case 6: {
                    void $receiver;
                    SimpleType simpleType8 = $receiver.getFloatType();
                    SimpleType simpleType3 = simpleType8;
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType8, (String)"getFloatType()");
                    return simpleType3;
                }
                case 7: {
                    void $receiver;
                    SimpleType simpleType9 = $receiver.getDoubleType();
                    SimpleType simpleType3 = simpleType9;
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType9, (String)"getDoubleType()");
                    return simpleType3;
                }
                case 8: {
                    void $receiver;
                    SimpleType simpleType10 = $receiver.getBooleanType();
                    SimpleType simpleType3 = simpleType10;
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType10, (String)"getBooleanType()");
                    return simpleType3;
                }
                case 9: {
                    void $receiver;
                    SimpleType simpleType11 = $receiver.getStringType();
                    SimpleType simpleType3 = simpleType11;
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType11, (String)"getStringType()");
                    return simpleType3;
                }
                case 10: {
                    String string = "Arrays of class literals are not supported yet";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                case 11: {
                    ClassId classId = nameResolver.getClassId(value.getClassId());
                    Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"nameResolver.getClassId(value.classId)");
                    SimpleType simpleType12 = this.resolveClass(classId).getDefaultType();
                    SimpleType simpleType3 = simpleType12;
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType12, (String)"resolveClass(nameResolve\u2026lue.classId)).defaultType");
                    return simpleType3;
                }
                case 12: {
                    ClassId classId = nameResolver.getClassId(value.getAnnotation().getId());
                    Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"nameResolver.getClassId(value.annotation.id)");
                    SimpleType simpleType13 = this.resolveClass(classId).getDefaultType();
                    SimpleType simpleType3 = simpleType13;
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType13, (String)"resolveClass(nameResolve\u2026notation.id)).defaultType");
                    return simpleType3;
                }
                case 13: {
                    String string = "Array of arrays is impossible";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
            }
        }
        String string = "Unknown type: " + value.getType();
        throw (Throwable)new IllegalStateException(string.toString());
    }

    private final ClassDescriptor resolveClass(ClassId classId) {
        return FindClassInModuleKt.findNonGenericClassAcrossDependencies(this.module, classId, this.notFoundClasses);
    }

    public AnnotationDeserializer(@NotNull ModuleDescriptor module, @NotNull NotFoundClasses notFoundClasses) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)notFoundClasses, (String)"notFoundClasses");
        this.module = module;
        this.notFoundClasses = notFoundClasses;
        this.factory = new ConstantValueFactory(this.getBuiltIns());
    }
}

