/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.applet;

import java.applet.Applet;
import org.jmol.api.Interface;
import org.jmol.applet.AppletWrapper;
import org.jmol.applet.TickerThread;
import org.jmol.applet.WrappedApplet;
import org.jmol.util.Logger;

class WrappedAppletLoader
extends Thread {
    private Applet applet;
    private boolean isSigned;

    WrappedAppletLoader(Applet applet, boolean isSigned) {
        this.applet = applet;
        this.isSigned = isSigned;
    }

    @Override
    public void run() {
        long startTime = System.currentTimeMillis();
        if (Logger.debugging) {
            Logger.debug("WrappedAppletLoader.run(org.jmol.applet.Jmol)");
        }
        TickerThread tickerThread = new TickerThread(this.applet);
        tickerThread.start();
        try {
            WrappedApplet jmol = ((AppletWrapper)this.applet).wrappedApplet = (WrappedApplet)Interface.getOption("applet.Jmol", null, null);
            jmol.setApplet(this.applet, this.isSigned);
        }
        catch (Exception e) {
            Logger.errorEx("Could not instantiate applet", e);
        }
        long loadTimeSeconds = (System.currentTimeMillis() - startTime + 500L) / 1000L;
        if (Logger.debugging) {
            Logger.debug("applet load time = " + loadTimeSeconds + " seconds");
        }
        tickerThread.keepRunning = false;
        tickerThread.interrupt();
        this.applet.repaint();
    }
}

