/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.SessionSaveAsAction;
import org.openstreetmap.josm.actions.UploadAction;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.io.AbstractIOTask;
import org.openstreetmap.josm.gui.io.AbstractUploadDialog;
import org.openstreetmap.josm.gui.io.SaveLayerInfo;
import org.openstreetmap.josm.gui.io.SaveLayerTask;
import org.openstreetmap.josm.gui.io.SaveLayersModel;
import org.openstreetmap.josm.gui.io.SaveLayersTable;
import org.openstreetmap.josm.gui.io.UploadAndSaveProgressRenderer;
import org.openstreetmap.josm.gui.io.UploadOrSaveState;
import org.openstreetmap.josm.gui.layer.AbstractModifiableLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.progress.SwingRenderingProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.UserCancelException;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.WindowGeometry;

public class SaveLayersDialog
extends JDialog
implements TableModelListener {
    private final SaveLayersModel model = new SaveLayersModel();
    private UserAction action = UserAction.CANCEL;
    private final UploadAndSaveProgressRenderer pnlUploadLayers = new UploadAndSaveProgressRenderer();
    private final SaveAndProceedAction saveAndProceedAction = new SaveAndProceedAction();
    private final SaveSessionAction saveSessionAction = new SaveSessionAction();
    private final DiscardAndProceedAction discardAndProceedAction = new DiscardAndProceedAction();
    private final CancelAction cancelAction = new CancelAction();
    private transient SaveAndUploadTask saveAndUploadTask;
    private final JButton saveAndProceedActionButton = new JButton(this.saveAndProceedAction);

    public static boolean saveUnsavedModifications(Iterable<? extends Layer> iterable, Reason reason) {
        if (!GraphicsEnvironment.isHeadless()) {
            SaveLayersDialog saveLayersDialog = new SaveLayersDialog(Main.parent);
            ArrayList<AbstractModifiableLayer> arrayList = new ArrayList<AbstractModifiableLayer>();
            for (Layer layer : iterable) {
                AbstractModifiableLayer abstractModifiableLayer;
                if (!(layer instanceof AbstractModifiableLayer) || !(abstractModifiableLayer = (AbstractModifiableLayer)layer).isModified() || (abstractModifiableLayer.isSavable() || abstractModifiableLayer.isUploadable()) && !abstractModifiableLayer.requiresSaveToFile() && (!abstractModifiableLayer.requiresUploadToServer() || abstractModifiableLayer.isUploadDiscouraged())) continue;
                arrayList.add(abstractModifiableLayer);
            }
            saveLayersDialog.prepareForSavingAndUpdatingLayers(reason);
            if (!arrayList.isEmpty()) {
                saveLayersDialog.getModel().populate(arrayList);
                saveLayersDialog.setVisible(true);
                switch (saveLayersDialog.getUserAction()) {
                    case PROCEED: {
                        return true;
                    }
                }
                return false;
            }
        }
        return true;
    }

    public SaveLayersDialog(Component component) {
        super((Window)GuiHelper.getFrameForComponent(component), Dialog.ModalityType.DOCUMENT_MODAL);
        this.build();
    }

    protected void build() {
        WindowGeometry windowGeometry = WindowGeometry.centerOnScreen(new Dimension(650, 300));
        windowGeometry.applySafe(this);
        this.getContentPane().setLayout(new BorderLayout());
        SaveLayersTable saveLayersTable = new SaveLayersTable(this.model);
        JScrollPane jScrollPane = new JScrollPane(saveLayersTable);
        this.model.addPropertyChangeListener(saveLayersTable);
        saveLayersTable.getModel().addTableModelListener(this);
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.getContentPane().add((Component)this.buildButtonRow(), "South");
        this.addWindowListener(new WindowClosingAdapter());
        this.setDefaultCloseOperation(2);
    }

    protected JPanel buildButtonRow() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.model.addPropertyChangeListener(this.saveAndProceedAction);
        jPanel.add((Component)this.saveAndProceedActionButton, GBC.std(0, 0).insets(5, 5, 0, 0).fill(2));
        jPanel.add((Component)new JButton(this.saveSessionAction), GBC.std(1, 0).insets(5, 5, 5, 0).fill(2));
        this.model.addPropertyChangeListener(this.discardAndProceedAction);
        jPanel.add((Component)new JButton(this.discardAndProceedAction), GBC.std(0, 1).insets(5, 5, 0, 5).fill(2));
        jPanel.add((Component)new JButton(this.cancelAction), GBC.std(1, 1).insets(5, 5, 5, 5).fill(2));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.pnlUploadLayers, "Center");
        this.model.addPropertyChangeListener(this.pnlUploadLayers);
        jPanel2.add((Component)jPanel, "South");
        return jPanel2;
    }

    public void prepareForSavingAndUpdatingLayers(Reason reason) {
        switch (reason) {
            case EXIT: {
                this.setTitle(I18n.tr("Unsaved changes - Save/Upload before exiting?", new Object[0]));
                break;
            }
            case DELETE: {
                this.setTitle(I18n.tr("Unsaved changes - Save/Upload before deleting?", new Object[0]));
                break;
            }
            case RESTART: {
                this.setTitle(I18n.tr("Unsaved changes - Save/Upload before restarting?", new Object[0]));
            }
        }
        this.saveAndProceedAction.initForReason(reason);
        this.discardAndProceedAction.initForReason(reason);
    }

    public UserAction getUserAction() {
        return this.action;
    }

    public SaveLayersModel getModel() {
        return this.model;
    }

    protected void launchSafeAndUploadTask() {
        SwingRenderingProgressMonitor swingRenderingProgressMonitor = new SwingRenderingProgressMonitor(this.pnlUploadLayers);
        swingRenderingProgressMonitor.beginTask(I18n.tr("Uploading and saving modified layers ...", new Object[0]));
        this.saveAndUploadTask = new SaveAndUploadTask(this.model, swingRenderingProgressMonitor);
        new Thread((Runnable)this.saveAndUploadTask, this.saveAndUploadTask.getClass().getName()).start();
    }

    protected void cancelSafeAndUploadTask() {
        if (this.saveAndUploadTask != null) {
            this.saveAndUploadTask.cancel();
        }
        this.model.setMode(SaveLayersModel.Mode.EDITING_DATA);
    }

    private static void warn(String string, List<SaveLayerInfo> list, String string2) {
        LayerListWarningMessagePanel layerListWarningMessagePanel = new LayerListWarningMessagePanel(string, list);
        if (!GraphicsEnvironment.isHeadless()) {
            JOptionPane.showConfirmDialog(Main.parent, layerListWarningMessagePanel, string2, -1, 2);
        }
    }

    protected static void warnLayersWithConflictsAndUploadRequest(List<SaveLayerInfo> list) {
        SaveLayersDialog.warn(I18n.trn("<html>{0} layer has unresolved conflicts.<br>Either resolve them first or discard the modifications.<br>Layer with conflicts:</html>", "<html>{0} layers have unresolved conflicts.<br>Either resolve them first or discard the modifications.<br>Layers with conflicts:</html>", list.size(), list.size()), list, I18n.tr("Unsaved data and conflicts", new Object[0]));
    }

    protected static void warnLayersWithoutFilesAndSaveRequest(List<SaveLayerInfo> list) {
        SaveLayersDialog.warn(I18n.trn("<html>{0} layer needs saving but has no associated file.<br>Either select a file for this layer or discard the changes.<br>Layer without a file:</html>", "<html>{0} layers need saving but have no associated file.<br>Either select a file for each of them or discard the changes.<br>Layers without a file:</html>", list.size(), list.size()), list, I18n.tr("Unsaved data and missing associated file", new Object[0]));
    }

    protected static void warnLayersWithIllegalFilesAndSaveRequest(List<SaveLayerInfo> list) {
        SaveLayersDialog.warn(I18n.trn("<html>{0} layer needs saving but has an associated file<br>which cannot be written.<br>Either select another file for this layer or discard the changes.<br>Layer with a non-writable file:</html>", "<html>{0} layers need saving but have associated files<br>which cannot be written.<br>Either select another file for each of them or discard the changes.<br>Layers with non-writable files:</html>", list.size(), list.size()), list, I18n.tr("Unsaved data non-writable files", new Object[0]));
    }

    static boolean confirmSaveLayerInfosOK(SaveLayersModel saveLayersModel) {
        List<SaveLayerInfo> list = saveLayersModel.getLayersWithConflictsAndUploadRequest();
        if (!list.isEmpty()) {
            SaveLayersDialog.warnLayersWithConflictsAndUploadRequest(list);
            return false;
        }
        list = saveLayersModel.getLayersWithoutFilesAndSaveRequest();
        if (!list.isEmpty()) {
            SaveLayersDialog.warnLayersWithoutFilesAndSaveRequest(list);
            return false;
        }
        list = saveLayersModel.getLayersWithIllegalFilesAndSaveRequest();
        if (!list.isEmpty()) {
            SaveLayersDialog.warnLayersWithIllegalFilesAndSaveRequest(list);
            return false;
        }
        return true;
    }

    protected void setUserAction(UserAction userAction) {
        this.action = userAction;
    }

    public void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        boolean bl;
        boolean bl2 = bl = this.model.getLayersToSave().isEmpty() && this.model.getLayersToUpload().isEmpty();
        if (this.saveAndProceedActionButton != null) {
            this.saveAndProceedActionButton.setEnabled(!bl);
        }
        this.saveAndProceedAction.redrawIcon();
    }

    protected class SaveAndUploadTask
    implements Runnable {
        private final SaveLayersModel model;
        private final ProgressMonitor monitor;
        private final ExecutorService worker;
        private boolean canceled;
        private Future<?> currentFuture;
        private AbstractIOTask currentTask;

        public SaveAndUploadTask(SaveLayersModel saveLayersModel, ProgressMonitor progressMonitor) {
            this.model = saveLayersModel;
            this.monitor = progressMonitor;
            this.worker = Executors.newSingleThreadExecutor(Utils.newThreadFactory(this.getClass() + "-%d", 5));
        }

        protected void uploadLayers(List<SaveLayerInfo> list) {
            for (SaveLayerInfo saveLayerInfo : list) {
                AbstractModifiableLayer abstractModifiableLayer = saveLayerInfo.getLayer();
                if (this.canceled) {
                    this.model.setUploadState(abstractModifiableLayer, UploadOrSaveState.CANCELED);
                    continue;
                }
                this.monitor.subTask(I18n.tr("Preparing layer ''{0}'' for upload ...", saveLayerInfo.getName()));
                if (!UploadAction.checkPreUploadConditions(abstractModifiableLayer)) {
                    this.model.setUploadState(abstractModifiableLayer, UploadOrSaveState.FAILED);
                    continue;
                }
                AbstractUploadDialog abstractUploadDialog = abstractModifiableLayer.getUploadDialog();
                if (abstractUploadDialog != null) {
                    abstractUploadDialog.setVisible(true);
                    if (abstractUploadDialog.isCanceled()) {
                        this.model.setUploadState(abstractModifiableLayer, UploadOrSaveState.CANCELED);
                        continue;
                    }
                    abstractUploadDialog.rememberUserInput();
                }
                this.currentTask = abstractModifiableLayer.createUploadTask(this.monitor);
                if (this.currentTask == null) {
                    this.model.setUploadState(abstractModifiableLayer, UploadOrSaveState.FAILED);
                    continue;
                }
                this.currentFuture = this.worker.submit(this.currentTask);
                try {
                    this.currentFuture.get();
                }
                catch (CancellationException cancellationException) {
                    Main.trace(cancellationException);
                    this.model.setUploadState(abstractModifiableLayer, UploadOrSaveState.CANCELED);
                }
                catch (InterruptedException | ExecutionException exception) {
                    Main.error(exception);
                    this.model.setUploadState(abstractModifiableLayer, UploadOrSaveState.FAILED);
                    ExceptionDialogUtil.explainException(exception);
                }
                if (this.currentTask.isCanceled()) {
                    this.model.setUploadState(abstractModifiableLayer, UploadOrSaveState.CANCELED);
                } else if (this.currentTask.isFailed()) {
                    Main.error(this.currentTask.getLastException());
                    ExceptionDialogUtil.explainException(this.currentTask.getLastException());
                    this.model.setUploadState(abstractModifiableLayer, UploadOrSaveState.FAILED);
                } else {
                    this.model.setUploadState(abstractModifiableLayer, UploadOrSaveState.OK);
                }
                this.currentTask = null;
                this.currentFuture = null;
            }
        }

        protected void saveLayers(List<SaveLayerInfo> list) {
            for (SaveLayerInfo saveLayerInfo : list) {
                if (this.canceled) {
                    this.model.setSaveState(saveLayerInfo.getLayer(), UploadOrSaveState.CANCELED);
                    continue;
                }
                if (saveLayerInfo.isDoCheckSaveConditions()) {
                    if (!saveLayerInfo.getLayer().checkSaveConditions()) continue;
                    saveLayerInfo.setDoCheckSaveConditions(false);
                }
                this.currentTask = new SaveLayerTask(saveLayerInfo, this.monitor);
                this.currentFuture = this.worker.submit(this.currentTask);
                try {
                    this.currentFuture.get();
                }
                catch (CancellationException cancellationException) {
                    Main.trace(cancellationException);
                    this.model.setSaveState(saveLayerInfo.getLayer(), UploadOrSaveState.CANCELED);
                }
                catch (InterruptedException | ExecutionException exception) {
                    Main.error(exception);
                    this.model.setSaveState(saveLayerInfo.getLayer(), UploadOrSaveState.FAILED);
                    ExceptionDialogUtil.explainException(exception);
                }
                if (this.currentTask.isCanceled()) {
                    this.model.setSaveState(saveLayerInfo.getLayer(), UploadOrSaveState.CANCELED);
                } else if (this.currentTask.isFailed()) {
                    if (this.currentTask.getLastException() != null) {
                        Main.error(this.currentTask.getLastException());
                        ExceptionDialogUtil.explainException(this.currentTask.getLastException());
                    }
                    this.model.setSaveState(saveLayerInfo.getLayer(), UploadOrSaveState.FAILED);
                } else {
                    this.model.setSaveState(saveLayerInfo.getLayer(), UploadOrSaveState.OK);
                }
                this.currentTask = null;
                this.currentFuture = null;
            }
        }

        protected void warnBecauseOfUnsavedData() {
            int n = this.model.getNumCancel() + this.model.getNumFailed();
            if (n == 0) {
                return;
            }
            Main.warn(n + " problems occured during upload/save");
            String string = I18n.trn("<html>An upload and/or save operation of one layer with modifications<br>was canceled or has failed.</html>", "<html>Upload and/or save operations of {0} layers with modifications<br>were canceled or have failed.</html>", n, n);
            JOptionPane.showMessageDialog(Main.parent, string, I18n.tr("Incomplete upload and/or save", new Object[0]), 2);
        }

        @Override
        public void run() {
            GuiHelper.runInEDTAndWait(() -> {
                List<SaveLayerInfo> list;
                this.model.setMode(SaveLayersModel.Mode.UPLOADING_AND_SAVING);
                List<SaveLayerInfo> list2 = this.model.getLayersToUpload();
                if (!list2.isEmpty()) {
                    this.uploadLayers(list2);
                }
                if (!(list = this.model.getLayersToSave()).isEmpty()) {
                    this.saveLayers(list);
                }
                this.model.setMode(SaveLayersModel.Mode.EDITING_DATA);
                if (this.model.hasUnsavedData()) {
                    this.warnBecauseOfUnsavedData();
                    this.model.setMode(SaveLayersModel.Mode.EDITING_DATA);
                    if (this.canceled) {
                        SaveLayersDialog.this.setUserAction(UserAction.CANCEL);
                        SaveLayersDialog.this.closeDialog();
                    }
                } else {
                    SaveLayersDialog.this.setUserAction(UserAction.PROCEED);
                    SaveLayersDialog.this.closeDialog();
                }
            });
            this.worker.shutdownNow();
        }

        public void cancel() {
            if (this.currentTask != null) {
                this.currentTask.cancel();
            }
            this.worker.shutdown();
            this.canceled = true;
        }
    }

    final class SaveAndProceedAction
    extends AbstractAction
    implements PropertyChangeListener {
        private static final int ICON_SIZE = 24;
        private static final String BASE_ICON = "BASE_ICON";
        private final transient Image save = this.getImage("save", false);
        private final transient Image upld = this.getImage("upload", false);
        private final transient Image saveDis = this.getImage("save", true);
        private final transient Image upldDis = this.getImage("upload", true);

        SaveAndProceedAction() {
            this.initForReason(Reason.EXIT);
        }

        Image getImage(String string, boolean bl) {
            ImageIcon imageIcon = new ImageProvider(string).setDisabled(bl).get();
            return imageIcon != null ? imageIcon.getImage() : null;
        }

        public void initForReason(Reason reason) {
            switch (reason) {
                case EXIT: {
                    this.putValue("Name", I18n.tr("Perform actions before exiting", new Object[0]));
                    this.putValue("ShortDescription", I18n.tr("Exit JOSM with saving. Unsaved changes are uploaded and/or saved.", new Object[0]));
                    this.putValue(BASE_ICON, ImageProvider.get("exit"));
                    break;
                }
                case RESTART: {
                    this.putValue("Name", I18n.tr("Perform actions before restarting", new Object[0]));
                    this.putValue("ShortDescription", I18n.tr("Restart JOSM with saving. Unsaved changes are uploaded and/or saved.", new Object[0]));
                    this.putValue(BASE_ICON, ImageProvider.get("restart"));
                    break;
                }
                case DELETE: {
                    this.putValue("Name", I18n.tr("Perform actions before deleting", new Object[0]));
                    this.putValue("ShortDescription", I18n.tr("Save/Upload layers before deleting. Unsaved changes are not lost.", new Object[0]));
                    this.putValue(BASE_ICON, ImageProvider.get("dialogs", "delete"));
                }
            }
            this.redrawIcon();
        }

        public void redrawIcon() {
            Image image = ((ImageIcon)this.getValue(BASE_ICON)).getImage();
            BufferedImage bufferedImage = new BufferedImage(72, 24, 6);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(SaveLayersDialog.this.model.getLayersToUpload().isEmpty() ? this.upldDis : this.upld, 0, 0, 24, 24, null);
            graphics2D.drawImage(SaveLayersDialog.this.model.getLayersToSave().isEmpty() ? this.saveDis : this.save, 24, 0, 24, 24, null);
            graphics2D.drawImage(image, 48, 0, 24, 24, null);
            this.putValue("SmallIcon", new ImageIcon(bufferedImage));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!SaveLayersDialog.confirmSaveLayerInfosOK(SaveLayersDialog.this.model)) {
                return;
            }
            SaveLayersDialog.this.launchSafeAndUploadTask();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(SaveLayersModel.MODE_PROP)) {
                SaveLayersModel.Mode mode = (SaveLayersModel.Mode)((Object)propertyChangeEvent.getNewValue());
                switch (mode) {
                    case EDITING_DATA: {
                        this.setEnabled(true);
                        break;
                    }
                    case UPLOADING_AND_SAVING: {
                        this.setEnabled(false);
                    }
                }
            }
        }
    }

    class SaveSessionAction
    extends SessionSaveAsAction {
        SaveSessionAction() {
            super(false, false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                this.saveSession();
                SaveLayersDialog.this.setUserAction(UserAction.PROCEED);
                SaveLayersDialog.this.closeDialog();
            }
            catch (UserCancelException userCancelException) {
                Main.trace(userCancelException);
            }
        }
    }

    class DiscardAndProceedAction
    extends AbstractAction
    implements PropertyChangeListener {
        DiscardAndProceedAction() {
            this.initForReason(Reason.EXIT);
        }

        public void initForReason(Reason reason) {
            switch (reason) {
                case EXIT: {
                    this.putValue("Name", I18n.tr("Exit now!", new Object[0]));
                    this.putValue("ShortDescription", I18n.tr("Exit JOSM without saving. Unsaved changes are lost.", new Object[0]));
                    this.putValue("SmallIcon", ImageProvider.get("exit"));
                    break;
                }
                case RESTART: {
                    this.putValue("Name", I18n.tr("Restart now!", new Object[0]));
                    this.putValue("ShortDescription", I18n.tr("Restart JOSM without saving. Unsaved changes are lost.", new Object[0]));
                    this.putValue("SmallIcon", ImageProvider.get("restart"));
                    break;
                }
                case DELETE: {
                    this.putValue("Name", I18n.tr("Delete now!", new Object[0]));
                    this.putValue("ShortDescription", I18n.tr("Delete layers without saving. Unsaved changes are lost.", new Object[0]));
                    this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SaveLayersDialog.this.setUserAction(UserAction.PROCEED);
            SaveLayersDialog.this.closeDialog();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(SaveLayersModel.MODE_PROP)) {
                SaveLayersModel.Mode mode = (SaveLayersModel.Mode)((Object)propertyChangeEvent.getNewValue());
                switch (mode) {
                    case EDITING_DATA: {
                        this.setEnabled(true);
                        break;
                    }
                    case UPLOADING_AND_SAVING: {
                        this.setEnabled(false);
                    }
                }
            }
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", I18n.tr("Cancel", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Close this dialog and resume editing in JOSM", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("cancel"));
            InputMapUtils.addEscapeAction(SaveLayersDialog.this.getRootPane(), this);
        }

        protected void cancelWhenInEditingModel() {
            SaveLayersDialog.this.setUserAction(UserAction.CANCEL);
            SaveLayersDialog.this.closeDialog();
        }

        public void cancel() {
            switch (SaveLayersDialog.this.model.getMode()) {
                case EDITING_DATA: {
                    this.cancelWhenInEditingModel();
                    break;
                }
                case UPLOADING_AND_SAVING: {
                    SaveLayersDialog.this.cancelSafeAndUploadTask();
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.cancel();
        }
    }

    class WindowClosingAdapter
    extends WindowAdapter {
        WindowClosingAdapter() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            SaveLayersDialog.this.cancelAction.cancel();
        }
    }

    private static class LayerListWarningMessagePanel
    extends JPanel {
        private final JLabel lblMessage = new JLabel();
        private final JList<SaveLayerInfo> lstLayers = new JList();

        LayerListWarningMessagePanel(String string, List<SaveLayerInfo> list) {
            super(new GridBagLayout());
            this.build();
            this.lblMessage.setText(string);
            this.lstLayers.setListData((SaveLayerInfo[])list.toArray(new SaveLayerInfo[list.size()]));
        }

        protected void build() {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            this.add((Component)this.lblMessage, gridBagConstraints);
            this.lblMessage.setHorizontalAlignment(2);
            this.lstLayers.setCellRenderer(new LayerCellRenderer());
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.add(this.lstLayers, gridBagConstraints);
        }

        static final class LayerCellRenderer
        implements ListCellRenderer<SaveLayerInfo> {
            private final DefaultListCellRenderer def = new DefaultListCellRenderer();

            LayerCellRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList<? extends SaveLayerInfo> jList, SaveLayerInfo saveLayerInfo, int n, boolean bl, boolean bl2) {
                this.def.setIcon(saveLayerInfo.getLayer().getIcon());
                this.def.setText(saveLayerInfo.getName());
                return this.def;
            }
        }
    }

    private static enum UserAction {
        PROCEED,
        CANCEL;

    }

    public static enum Reason {
        DELETE,
        EXIT,
        RESTART;

    }
}

