/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.imagery;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openstreetmap.josm.gui.layer.ImageProcessor;
import org.openstreetmap.josm.gui.layer.imagery.ColorfulImageProcessor;
import org.openstreetmap.josm.gui.layer.imagery.GammaImageProcessor;
import org.openstreetmap.josm.gui.layer.imagery.SharpenImageProcessor;

public class ImageryFilterSettings {
    protected GammaImageProcessor gammaImageProcessor = new GammaImageProcessor();
    protected SharpenImageProcessor sharpenImageProcessor = new SharpenImageProcessor();
    protected ColorfulImageProcessor collorfulnessImageProcessor = new ColorfulImageProcessor();
    private final List<FilterChangeListener> filterChangeListeners = new CopyOnWriteArrayList<FilterChangeListener>();

    public double getGamma() {
        return this.gammaImageProcessor.getGamma();
    }

    public void setGamma(double d) {
        this.gammaImageProcessor.setGamma(d);
        this.fireListeners();
    }

    public double getSharpenLevel() {
        return this.sharpenImageProcessor.getSharpenLevel();
    }

    public void setSharpenLevel(double d) {
        this.sharpenImageProcessor.setSharpenLevel((float)d);
        this.fireListeners();
    }

    public double getColorfulness() {
        return this.collorfulnessImageProcessor.getColorfulness();
    }

    public void setColorfulness(double d) {
        this.collorfulnessImageProcessor.setColorfulness(d);
        this.fireListeners();
    }

    public List<ImageProcessor> getProcessors() {
        return Arrays.asList(this.collorfulnessImageProcessor, this.gammaImageProcessor, this.sharpenImageProcessor);
    }

    public void addFilterChangeListener(FilterChangeListener filterChangeListener) {
        this.filterChangeListeners.add(filterChangeListener);
    }

    public void removeFilterChangeListener(FilterChangeListener filterChangeListener) {
        this.filterChangeListeners.remove(filterChangeListener);
    }

    private void fireListeners() {
        for (FilterChangeListener filterChangeListener : this.filterChangeListeners) {
            filterChangeListener.filterChanged();
        }
    }

    @FunctionalInterface
    public static interface FilterChangeListener {
        public void filterChanged();
    }
}

