/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.markerlayer;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.Extensions;
import org.openstreetmap.josm.data.gpx.GpxConstants;
import org.openstreetmap.josm.data.gpx.GpxLink;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.preferences.CachedProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.markerlayer.AudioMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.ImageMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerProducers;
import org.openstreetmap.josm.gui.layer.markerlayer.WebMarker;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.template_engine.ParseError;
import org.openstreetmap.josm.tools.template_engine.TemplateEngineDataProvider;
import org.openstreetmap.josm.tools.template_engine.TemplateEntry;
import org.openstreetmap.josm.tools.template_engine.TemplateParser;

public class Marker
implements TemplateEngineDataProvider {
    public static final List<MarkerProducers> markerProducers = new LinkedList<MarkerProducers>();
    public static final String MARKER_OFFSET = "waypointOffset";
    public static final String MARKER_FORMATTED_OFFSET = "formattedWaypointOffset";
    public static final String LABEL_PATTERN_AUTO = "?{ '{name} ({desc})' | '{name} ({cmt})' | '{name}' | '{desc}' | '{cmt}' }";
    public static final String LABEL_PATTERN_NAME = "{name}";
    public static final String LABEL_PATTERN_DESC = "{desc}";
    private final DateFormat timeFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private final TemplateEngineDataProvider dataProvider;
    private final String text;
    protected final ImageIcon symbol;
    private BufferedImage redSymbol;
    public final MarkerLayer parentLayer;
    public double time;
    public double offset;
    private String cachedText;
    private int textVersion = -1;
    private CachedLatLon coor;
    private boolean erroneous;

    private static URL uriToUrl(String string, File file) {
        URL uRL;
        block3: {
            uRL = null;
            if (string != null) {
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    if (file == null) break block3;
                    uRL = Utils.fileToURL(new File(file.getParentFile(), string));
                }
            }
        }
        return uRL;
    }

    public static Collection<Marker> createMarkers(WayPoint wayPoint, File file, MarkerLayer markerLayer, double d, double d2) {
        for (MarkerProducers markerProducers : Marker.markerProducers) {
            Collection<Marker> collection = markerProducers.createMarkers(wayPoint, file, markerLayer, d, d2);
            if (collection == null) continue;
            return collection;
        }
        return null;
    }

    public Marker(LatLon latLon, TemplateEngineDataProvider templateEngineDataProvider, String string, MarkerLayer markerLayer, double d, double d2) {
        this(latLon, templateEngineDataProvider, null, string, markerLayer, d, d2);
    }

    public Marker(LatLon latLon, String string, String string2, MarkerLayer markerLayer, double d, double d2) {
        this(latLon, null, string, string2, markerLayer, d, d2);
    }

    private Marker(LatLon latLon, TemplateEngineDataProvider templateEngineDataProvider, String string, String string2, MarkerLayer markerLayer, double d, double d2) {
        this.timeFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.setCoor(latLon);
        this.offset = d2;
        this.time = d;
        this.symbol = string2 != null ? ImageProvider.getIfAvailable("markers", string2) : null;
        this.parentLayer = markerLayer;
        this.dataProvider = templateEngineDataProvider;
        this.text = string;
    }

    public WayPoint convertToWayPoint() {
        WayPoint wayPoint = new WayPoint(this.getCoor());
        wayPoint.put("time", this.timeFormatter.format(new Date(Math.round(this.time * 1000.0))));
        if (this.text != null) {
            wayPoint.addExtension("text", this.text);
        } else if (this.dataProvider != null) {
            for (String string : this.dataProvider.getTemplateKeys()) {
                Object object = this.dataProvider.getTemplateValue(string, false);
                if (object == null || !GpxConstants.WPT_KEYS.contains(string)) continue;
                wayPoint.put(string, object);
            }
        }
        return wayPoint;
    }

    public final void setCoor(LatLon latLon) {
        this.coor = new CachedLatLon(latLon);
    }

    public final LatLon getCoor() {
        return this.coor;
    }

    public final void setEastNorth(EastNorth eastNorth) {
        this.coor = new CachedLatLon(eastNorth);
    }

    public final EastNorth getEastNorth() {
        return this.coor.getEastNorth();
    }

    public boolean containsPoint(Point point) {
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void paint(Graphics graphics, MapView mapView, boolean bl, boolean bl2) {
        Point point = mapView.getPoint(this.getEastNorth());
        if (this.symbol != null && bl2) {
            this.paintIcon(mapView, graphics, point.x - this.symbol.getIconWidth() / 2, point.y - this.symbol.getIconHeight() / 2);
        } else {
            graphics.drawLine(point.x - 2, point.y - 2, point.x + 2, point.y + 2);
            graphics.drawLine(point.x + 2, point.y - 2, point.x - 2, point.y + 2);
        }
        String string = this.getText();
        if (string != null && bl2) {
            graphics.drawString(string, point.x + 4, point.y + 2);
        }
    }

    protected void paintIcon(MapView mapView, Graphics graphics, int n, int n2) {
        if (!this.erroneous) {
            this.symbol.paintIcon(mapView, graphics, n, n2);
        } else {
            if (this.redSymbol == null) {
                int n3 = this.symbol.getIconWidth();
                int n4 = this.symbol.getIconHeight();
                this.redSymbol = new BufferedImage(n3, n4, 2);
                Graphics2D graphics2D = this.redSymbol.createGraphics();
                graphics2D.drawImage(this.symbol.getImage(), 0, 0, null);
                graphics2D.setColor(Color.RED);
                graphics2D.setComposite(AlphaComposite.getInstance(10, 0.666f));
                graphics2D.fillRect(0, 0, n3, n4);
                graphics2D.dispose();
            }
            graphics.drawImage(this.redSymbol, n, n2, mapView);
        }
    }

    protected TemplateEntryProperty getTextTemplate() {
        return TemplateEntryProperty.forMarker(this.parentLayer.getName());
    }

    public String getText() {
        if (this.text != null) {
            return this.text;
        }
        TemplateEntryProperty templateEntryProperty = this.getTextTemplate();
        if (templateEntryProperty.getUpdateCount() != this.textVersion) {
            TemplateEntry templateEntry = (TemplateEntry)templateEntryProperty.get();
            StringBuilder stringBuilder = new StringBuilder();
            templateEntry.appendText(stringBuilder, this);
            this.cachedText = stringBuilder.toString();
            this.textVersion = templateEntryProperty.getUpdateCount();
        }
        return this.cachedText;
    }

    @Override
    public Collection<String> getTemplateKeys() {
        Collection<String> collection = this.dataProvider != null ? this.dataProvider.getTemplateKeys() : new ArrayList<String>();
        collection.add(MARKER_FORMATTED_OFFSET);
        collection.add(MARKER_OFFSET);
        return collection;
    }

    private String formatOffset() {
        int n = (int)(this.offset + 0.5);
        if (n < 60) {
            return Integer.toString(n);
        }
        if (n < 3600) {
            return String.format("%d:%02d", n / 60, n % 60);
        }
        return String.format("%d:%02d:%02d", n / 3600, n % 3600 / 60, n % 60);
    }

    @Override
    public Object getTemplateValue(String string, boolean bl) {
        if (MARKER_FORMATTED_OFFSET.equals(string)) {
            return this.formatOffset();
        }
        if (MARKER_OFFSET.equals(string)) {
            return this.offset;
        }
        if (this.dataProvider != null) {
            return this.dataProvider.getTemplateValue(string, bl);
        }
        return null;
    }

    @Override
    public boolean evaluateCondition(SearchCompiler.Match match) {
        throw new UnsupportedOperationException();
    }

    public final boolean isErroneous() {
        return this.erroneous;
    }

    public final void setErroneous(boolean bl) {
        this.erroneous = bl;
        if (!bl) {
            this.redSymbol = null;
        }
    }

    static {
        markerProducers.add((wayPoint, file, markerLayer, d, d2) -> {
            Object object;
            Object object2;
            String string = null;
            Collection collection = wayPoint.getCollection("meta.links");
            if (collection != null && (object2 = collection.iterator()).hasNext()) {
                object = (GpxLink)object2.next();
                string = ((GpxLink)object).uri;
            }
            object = (object2 = Marker.uriToUrl(string, file)) == null ? "" : ((URL)object2).toString();
            String string2 = wayPoint.getString("symbol");
            if (string2 == null) {
                string2 = wayPoint.getString("sym");
            }
            Marker marker = new Marker(wayPoint.getCoor(), wayPoint, string2, markerLayer, d, d2);
            if (object2 == null) {
                return Collections.singleton(marker);
            }
            if (((String)object).endsWith(".wav")) {
                AudioMarker audioMarker = new AudioMarker(wayPoint.getCoor(), (TemplateEngineDataProvider)wayPoint, (URL)object2, markerLayer, d, d2);
                Extensions extensions = (Extensions)wayPoint.get("meta.extensions");
                if (extensions != null && extensions.containsKey("offset")) {
                    try {
                        audioMarker.syncOffset = Double.parseDouble((String)extensions.get("sync-offset"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        Main.warn(numberFormatException);
                    }
                }
                return Arrays.asList(marker, audioMarker);
            }
            if (((String)object).endsWith(".png") || ((String)object).endsWith(".jpg") || ((String)object).endsWith(".jpeg") || ((String)object).endsWith(".gif")) {
                return Arrays.asList(marker, new ImageMarker(wayPoint.getCoor(), (URL)object2, markerLayer, d, d2));
            }
            return Arrays.asList(marker, new WebMarker(wayPoint.getCoor(), (URL)object2, markerLayer, d, d2));
        });
    }

    public static final class TemplateEntryProperty
    extends CachedProperty<TemplateEntry> {
        private static final Map<String, TemplateEntryProperty> CACHE = new HashMap<String, TemplateEntryProperty>();
        private static final IntegerProperty PROP_LABEL = new IntegerProperty("draw.rawgps.layer.wpt", 0);
        private final TemplateEntryProperty parent;

        private static String getDefaultLabelPattern() {
            switch (PROP_LABEL.get()) {
                case 1: {
                    return Marker.LABEL_PATTERN_NAME;
                }
                case 2: {
                    return Marker.LABEL_PATTERN_DESC;
                }
                case 0: 
                case 3: {
                    return Marker.LABEL_PATTERN_AUTO;
                }
            }
            return "";
        }

        public static TemplateEntryProperty forMarker(String string) {
            TemplateEntryProperty templateEntryProperty;
            String string2 = "draw.rawgps.layer.wpt.pattern";
            if (string != null) {
                string2 = string2 + '.' + string;
            }
            if ((templateEntryProperty = CACHE.get(string2)) == null) {
                String string3 = string == null ? TemplateEntryProperty.getDefaultLabelPattern() : "";
                TemplateEntryProperty templateEntryProperty2 = string == null ? null : TemplateEntryProperty.forMarker(null);
                templateEntryProperty = new TemplateEntryProperty(string2, string3, templateEntryProperty2);
                CACHE.put(string2, templateEntryProperty);
            }
            return templateEntryProperty;
        }

        public static TemplateEntryProperty forAudioMarker(String string) {
            TemplateEntryProperty templateEntryProperty;
            String string2 = "draw.rawgps.layer.audiowpt.pattern";
            if (string != null) {
                string2 = string2 + '.' + string;
            }
            if ((templateEntryProperty = CACHE.get(string2)) == null) {
                String string3 = string == null ? "?{ '{name}' | '{desc}' | '{formattedWaypointOffset}' }" : "";
                TemplateEntryProperty templateEntryProperty2 = string == null ? null : TemplateEntryProperty.forAudioMarker(null);
                templateEntryProperty = new TemplateEntryProperty(string2, string3, templateEntryProperty2);
                CACHE.put(string2, templateEntryProperty);
            }
            return templateEntryProperty;
        }

        private TemplateEntryProperty(String string, String string2, TemplateEntryProperty templateEntryProperty) {
            super(string, string2);
            this.parent = templateEntryProperty;
            this.updateValue();
        }

        @Override
        protected TemplateEntry fromString(String string) {
            try {
                return new TemplateParser(string).parse();
            }
            catch (ParseError parseError) {
                Main.debug(parseError);
                Main.warn("Unable to parse template engine pattern ''{0}'' for property {1}. Using default (''{2}'') instead", string, this.getKey(), super.getDefaultValueAsString());
                return (TemplateEntry)this.getDefaultValue();
            }
        }

        @Override
        public String getDefaultValueAsString() {
            if (this.parent == null) {
                return super.getDefaultValueAsString();
            }
            return this.parent.getAsString();
        }

        @Override
        public void preferenceChanged(Preferences.PreferenceChangeEvent preferenceChangeEvent) {
            if (preferenceChangeEvent.getKey().equals(this.key) || this.parent != null && preferenceChangeEvent.getKey().equals(this.parent.getKey())) {
                this.updateValue();
            }
        }
    }
}

