/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSetMerger;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.OsmServerObjectReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class OsmServerBackreferenceReader
extends OsmServerReader {
    private long id;
    private OsmPrimitiveType primitiveType;
    private boolean readFull;

    public OsmServerBackreferenceReader(OsmPrimitive osmPrimitive) {
        CheckParameterUtil.ensureValidPrimitiveId(osmPrimitive, "primitive");
        this.id = osmPrimitive.getId();
        this.primitiveType = OsmPrimitiveType.from(osmPrimitive);
        this.readFull = false;
    }

    public OsmServerBackreferenceReader(long l, OsmPrimitiveType osmPrimitiveType) {
        if (l <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' > 0 expected. Got ''{1}''.", "id", l));
        }
        CheckParameterUtil.ensureParameterNotNull((Object)osmPrimitiveType, "type");
        this.id = l;
        this.primitiveType = osmPrimitiveType;
        this.readFull = false;
    }

    public OsmServerBackreferenceReader(OsmPrimitive osmPrimitive, boolean bl) {
        this(osmPrimitive);
        this.readFull = bl;
    }

    public OsmServerBackreferenceReader(long l, OsmPrimitiveType osmPrimitiveType, boolean bl) {
        this(l, osmPrimitiveType);
        this.readFull = bl;
    }

    public boolean isReadFull() {
        return this.readFull;
    }

    public void setReadFull(boolean bl) {
        this.readFull = bl;
    }

    /*
     * Loose catch block
     */
    private DataSet getReferringPrimitives(ProgressMonitor progressMonitor, String string, String string2) throws OsmTransferException {
        progressMonitor.beginTask(null, 2);
        try {
            DataSet dataSet;
            Throwable throwable;
            InputStream inputStream;
            block27: {
                block28: {
                    block24: {
                        DataSet dataSet2;
                        block25: {
                            block26: {
                                progressMonitor.subTask(I18n.tr("Contacting OSM Server...", new Object[0]));
                                StringBuilder stringBuilder = new StringBuilder();
                                stringBuilder.append(this.primitiveType.getAPIName()).append('/').append(this.id).append(string);
                                inputStream = this.getInputStream(stringBuilder.toString(), progressMonitor.createSubTaskMonitor(1, true));
                                throwable = null;
                                if (inputStream != null) break block24;
                                dataSet2 = null;
                                if (inputStream == null) break block25;
                                if (throwable == null) break block26;
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block25;
                            }
                            inputStream.close();
                        }
                        return dataSet2;
                    }
                    progressMonitor.subTask(string2);
                    dataSet = OsmReader.parseDataSet(inputStream, progressMonitor.createSubTaskMonitor(1, true));
                    if (inputStream == null) break block27;
                    if (throwable == null) break block28;
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    break block27;
                }
                inputStream.close();
            }
            return dataSet;
            catch (Throwable throwable4) {
                try {
                    try {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        if (inputStream != null) {
                            if (throwable != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                            } else {
                                inputStream.close();
                            }
                        }
                        throw throwable5;
                    }
                }
                catch (OsmTransferException osmTransferException) {
                    throw osmTransferException;
                }
                catch (IOException | IllegalDataException exception) {
                    if (this.cancel) {
                        inputStream = null;
                        return inputStream;
                    }
                    throw new OsmTransferException(exception);
                }
            }
        }
        finally {
            progressMonitor.finishTask();
            this.activeConnection = null;
        }
    }

    protected DataSet getReferringWays(ProgressMonitor progressMonitor) throws OsmTransferException {
        return this.getReferringPrimitives(progressMonitor, "/ways", I18n.tr("Downloading referring ways ...", new Object[0]));
    }

    protected DataSet getReferringRelations(ProgressMonitor progressMonitor) throws OsmTransferException {
        return this.getReferringPrimitives(progressMonitor, "/relations", I18n.tr("Downloading referring relations ...", new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataSet readIncompletePrimitives(DataSet dataSet, ProgressMonitor progressMonitor) throws OsmTransferException {
        progressMonitor.beginTask(null, 2);
        try {
            ArrayList<Relation> arrayList;
            Object object;
            Object object2;
            ArrayList<Way> arrayList2 = new ArrayList<Way>(dataSet.getWays());
            if (this.isReadFull() || this.primitiveType.equals((Object)OsmPrimitiveType.NODE)) {
                for (Way object3 : arrayList2) {
                    if (object3.isNew() || !object3.hasIncompleteNodes()) continue;
                    OsmServerObjectReader osmServerObjectReader = new OsmServerObjectReader(object3.getId(), OsmPrimitiveType.from(object3), true);
                    object2 = osmServerObjectReader.parseOsm(progressMonitor.createSubTaskMonitor(1, false));
                    object = new DataSetMerger(dataSet, (DataSet)object2);
                    ((DataSetMerger)object).merge();
                }
            }
            if (this.isReadFull()) {
                arrayList = new ArrayList<Relation>(dataSet.getRelations());
                for (Relation relation : arrayList) {
                    if (relation.isNew() || !relation.hasIncompleteMembers()) continue;
                    object2 = new OsmServerObjectReader(relation.getId(), OsmPrimitiveType.from(relation), true);
                    object = ((OsmServerObjectReader)object2).parseOsm(progressMonitor.createSubTaskMonitor(1, false));
                    DataSetMerger dataSetMerger = new DataSetMerger(dataSet, (DataSet)object);
                    dataSetMerger.merge();
                }
            }
            arrayList = dataSet;
            return arrayList;
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        try {
            DataSetMerger dataSetMerger;
            DataSet dataSet;
            progressMonitor.beginTask(null, 3);
            DataSet dataSet2 = new DataSet();
            if (this.primitiveType.equals((Object)OsmPrimitiveType.NODE)) {
                dataSet = this.getReferringWays(progressMonitor.createSubTaskMonitor(1, false));
                dataSetMerger = new DataSetMerger(dataSet2, dataSet);
                dataSetMerger.merge();
                dataSet2 = dataSetMerger.getTargetDataSet();
            }
            dataSet = this.getReferringRelations(progressMonitor.createSubTaskMonitor(1, false));
            dataSetMerger = new DataSetMerger(dataSet2, dataSet);
            dataSetMerger.merge();
            dataSet2 = dataSetMerger.getTargetDataSet();
            if (dataSet2 != null) {
                this.readIncompletePrimitives(dataSet2, progressMonitor.createSubTaskMonitor(1, false));
                dataSet2.deleteInvisible();
            }
            DataSet dataSet3 = dataSet2;
            return dataSet3;
        }
        finally {
            progressMonitor.finishTask();
        }
    }
}

