/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.modules;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.JvmSourceRoot;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.utils.Printer;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002Jl\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u000bH\u0002J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000fH\u0002J\u0018\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u000bH\u0002J$\u0010 \u001a\u00020\u001b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0016H\u0002J\u0016\u0010\"\u001a\u00020\u001b2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/modules/KotlinModuleXmlBuilder;", "", "()V", "done", "", "p", "Lorg/jetbrains/kotlin/utils/Printer;", "xml", "Ljava/lang/StringBuilder;", "addModule", "moduleName", "", "outputDir", "sourceFiles", "", "Ljava/io/File;", "javaSourceRoots", "Lorg/jetbrains/kotlin/build/JvmSourceRoot;", "classpathRoots", "targetTypeId", "isTests", "directoriesToFilterOut", "", "friendDirs", "asText", "", "closeTag", "", "tag", "getEscapedPath", "sourceFile", "openTag", "processClasspath", "files", "processJavaSourceRoots", "roots", "kotlin-build-common"})
public final class KotlinModuleXmlBuilder {
    private final StringBuilder xml = new StringBuilder();
    private final Printer p = new Printer((Appendable)this.xml);
    private boolean done;

    @NotNull
    public final KotlinModuleXmlBuilder addModule(@NotNull String moduleName, @NotNull String outputDir2, @NotNull Iterable<? extends File> sourceFiles, @NotNull Iterable<JvmSourceRoot> javaSourceRoots, @NotNull Iterable<? extends File> classpathRoots, @NotNull String targetTypeId, boolean isTests, @NotNull Set<? extends File> directoriesToFilterOut, @NotNull Iterable<? extends File> friendDirs) {
        Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
        Intrinsics.checkParameterIsNotNull((Object)outputDir2, (String)"outputDir");
        Intrinsics.checkParameterIsNotNull(sourceFiles, (String)"sourceFiles");
        Intrinsics.checkParameterIsNotNull(javaSourceRoots, (String)"javaSourceRoots");
        Intrinsics.checkParameterIsNotNull(classpathRoots, (String)"classpathRoots");
        Intrinsics.checkParameterIsNotNull((Object)targetTypeId, (String)"targetTypeId");
        Intrinsics.checkParameterIsNotNull(directoriesToFilterOut, (String)"directoriesToFilterOut");
        Intrinsics.checkParameterIsNotNull(friendDirs, (String)"friendDirs");
        boolean bl = !this.done;
        if (_Assertions.ENABLED && !bl) {
            String string = "Already done";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.p.println(new Object[]{"<!-- Module script for " + (isTests ? "tests" : "production") + " -->"});
        this.p.println(new Object[]{"<", "module", " ", "name", "=\"", StringUtil.escapeXml((String)moduleName), "\" ", "type", "=\"", StringUtil.escapeXml((String)targetTypeId), "\" ", "outputDir", "=\"", this.getEscapedPath(new File(outputDir2)), "\">"});
        this.p.pushIndent();
        for (File file : friendDirs) {
            this.p.println(new Object[]{"<", "friendDir", " ", "path", "=\"", this.getEscapedPath(file), "\"/>"});
        }
        for (File file : sourceFiles) {
            this.p.println(new Object[]{"<", "sources", " ", "path", "=\"", this.getEscapedPath(file), "\"/>"});
        }
        this.processJavaSourceRoots(javaSourceRoots);
        this.processClasspath(classpathRoots, directoriesToFilterOut);
        this.closeTag(this.p, "module");
        return this;
    }

    private final void processClasspath(Iterable<? extends File> files, Set<? extends File> directoriesToFilterOut) {
        this.p.println(new Object[]{"<!-- Classpath -->"});
        for (File file : files) {
            boolean isOutput;
            boolean bl = isOutput = directoriesToFilterOut.contains(file) && !IncrementalCompilation.isEnabled();
            if (isOutput) {
                this.p.println(new Object[]{"<!-- Output directory, commented out -->"});
                this.p.println(new Object[]{"<!-- "});
                this.p.pushIndent();
            }
            this.p.println(new Object[]{"<", "classpath", " ", "path", "=\"", this.getEscapedPath(file), "\"/>"});
            if (!isOutput) continue;
            this.p.popIndent();
            this.p.println(new Object[]{"-->"});
        }
    }

    private final void processJavaSourceRoots(Iterable<JvmSourceRoot> roots) {
        this.p.println(new Object[]{"<!-- Java source roots -->"});
        for (JvmSourceRoot root : roots) {
            this.p.print(new Object[]{"<"});
            this.p.printWithNoIndent(new Object[]{"javaSourceRoots", " ", "path", "=\"", this.getEscapedPath(root.getFile()), "\""});
            if (root.getPackagePrefix() != null) {
                this.p.printWithNoIndent(new Object[]{" ", "packagePrefix", "=\"", root.getPackagePrefix(), "\""});
            }
            this.p.printWithNoIndent(new Object[]{"/>"});
            this.p.println(new Object[0]);
        }
    }

    @NotNull
    public final CharSequence asText() {
        if (!this.done) {
            this.closeTag(this.p, "modules");
            this.done = true;
        }
        return this.xml;
    }

    private final void openTag(Printer p, String tag) {
        p.println(new Object[]{"<" + tag + ">"});
        p.pushIndent();
    }

    private final void closeTag(Printer p, String tag) {
        p.popIndent();
        p.println(new Object[]{"</" + tag + ">"});
    }

    private final String getEscapedPath(File sourceFile) {
        String string = StringUtil.escapeXml((String)FileUtil.toSystemIndependentName((String)sourceFile.getPath()));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"escapeXml(toSystemIndepe\u2026entName(sourceFile.path))");
        return string;
    }

    public KotlinModuleXmlBuilder() {
        this.openTag(this.p, "modules");
    }
}

