/* pantheon-files-core.vapi generated by valac 0.34.4, do not modify. */

[CCode (cprefix = "Marlin", lower_case_cprefix = "marlin_")]
namespace Marlin {
	namespace Plugins {
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public abstract class Base {
			public Gtk.Widget window;
			public Base ();
			public virtual void context_menu (Gtk.Widget? widget, GLib.List<weak GOF.File> files);
			public virtual void directory_loaded (void* data);
			public void interface_loaded (Gtk.Widget? widget);
			public virtual void ui (Gtk.UIManager? widget);
			public virtual void update_file_info (GOF.File file);
			public virtual void update_sidebar (Gtk.Widget widget);
		}
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public abstract class AbstractSidebar : Gtk.ScrolledWindow {
		public enum Column {
			NAME,
			URI,
			DRIVE,
			VOLUME,
			MOUNT,
			ROW_TYPE,
			ICON,
			INDEX,
			CAN_EJECT,
			NO_EJECT,
			BOOKMARK,
			IS_CATEGORY,
			NOT_CATEGORY,
			TOOLTIP,
			EJECT_ICON,
			SHOW_SPINNER,
			SHOW_EJECT,
			SPINNER_PULSE,
			FREE_SPACE,
			DISK_SIZE,
			PLUGIN_CALLBACK,
			COUNT
		}
		protected Gtk.Box content_box;
		protected Gtk.TreeRowReference network_category_reference;
		protected Gtk.TreeStore store;
		public AbstractSidebar ();
		public void add_extra_item (Gtk.TreeRowReference category, string text, string tooltip, GLib.Icon? icon, Marlin.PluginCallbackFunc? cb);
		public void add_extra_network_item (string text, string tooltip, GLib.Icon? icon, Marlin.PluginCallbackFunc? cb);
		protected abstract Gtk.TreeIter add_place (Marlin.PlaceType place_type, Gtk.TreeIter? parent, string name, GLib.Icon? icon, string? uri, GLib.Drive? drive, GLib.Volume? volume, GLib.Mount? mount, uint index, string? tooltip = null);
		protected void init ();
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class Bookmark {
		public static GLib.CompareFunc<Marlin.Bookmark> compare_uris;
		public static GLib.CompareFunc<Marlin.Bookmark> compare_with;
		public Marlin.Bookmark copy ();
		public Bookmark.from_uri (string uri, string? label = null);
		public unowned GLib.Icon get_icon ();
		public unowned GLib.File get_location ();
		public string get_parse_name ();
		public string get_uri ();
		public bool uri_known_not_to_exist ();
		public GOF.File gof_file { get; private set; }
		public string label { get; set; }
		public signal void contents_changed ();
		public signal void deleted ();
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class BookmarkList : GLib.Object {
		public bool contains (Marlin.Bookmark bm);
		public void delete_item_at (uint index);
		public void delete_items_with_uri (string uri);
		public static Marlin.BookmarkList get_instance ();
		public void insert_uri (string uri, uint index, string? label = null);
		public void insert_uri_at_end (string uri, string? label = null);
		public void insert_uris (GLib.List<string> uris, uint index);
		public void insert_uris_at_end (GLib.List<string> uris);
		public unowned Marlin.Bookmark? item_at (uint index);
		public uint length ();
		public void move_item (uint index, uint destination);
		public GLib.List<Marlin.Bookmark> list { get; private set; }
		public signal void contents_changed ();
		public signal void deleted ();
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class DndHandler : GLib.Object {
		public DndHandler ();
		public static string data_to_string (uchar[] cdata);
		public bool dnd_perform (Gtk.Widget widget, GOF.File drop_target, GLib.List<GLib.File> drop_file_list, Gdk.DragAction action);
		public Gdk.DragAction? drag_drop_action_ask (Gtk.Widget dest_widget, Gtk.ApplicationWindow win, Gdk.DragAction possible_actions);
		public string? get_source_filename (Gdk.DragContext context);
		public bool handle_file_drag_actions (Gtk.Widget dest_widget, Gtk.ApplicationWindow win, Gdk.DragContext context, GOF.File drop_target, GLib.List<GLib.File> drop_file_list, Gdk.DragAction possible_actions, Gdk.DragAction suggested_action, uint32 timestamp);
		public bool handle_netscape_url (Gdk.DragContext context, GOF.File drop_target, Gtk.SelectionData selection);
		public bool handle_xdnddirectsave (Gdk.DragContext context, GOF.File drop_target, Gtk.SelectionData selection);
		public void on_choice (GLib.Variant? param);
		public static bool selection_data_is_uri_list (Gtk.SelectionData selection_data, uint info, out string? text);
		public static void set_selection_data_from_file_list (Gtk.SelectionData selection_data, GLib.List<GOF.File> file_list, string? prefix = "");
		public void set_source_uri (Gdk.DragContext context, string uri);
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class PluginManager : GLib.Object {
		[Version (deprecated = true, deprecated_since = "0.2", replacement = "Marlin.PluginManager.menuitem_references")]
		public GLib.List<Gtk.Widget>? menus;
		public PluginManager (string plugin_dir);
		public void directory_loaded (void* path);
		public Gee.List<string> get_available_plugins ();
		public void hook_context_menu (Gtk.Widget menu, GLib.List<weak GOF.File> files);
		public void interface_loaded (Gtk.Widget win);
		public void load_plugins ();
		public void ui (Gtk.UIManager data);
		public void update_file_info (GOF.File file);
		public void update_sidebar (Gtk.Widget widget);
		public Gee.List<Gtk.Widget> menuitem_references { get; private set; }
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public enum IconSize {
		SMALLEST,
		SMALLER,
		SMALL,
		NORMAL,
		LARGE,
		LARGER,
		HUGE,
		HUGER,
		LARGEST
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public enum OpenFlag {
		DEFAULT,
		NEW_ROOT,
		NEW_TAB,
		NEW_WINDOW
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public enum PlaceType {
		BUILT_IN,
		MOUNTED_VOLUME,
		BOOKMARK,
		BOOKMARKS_CATEGORY,
		PERSONAL_CATEGORY,
		STORAGE_CATEGORY,
		NETWORK_CATEGORY,
		PLUGIN_ITEM
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public enum TargetType {
		STRING,
		TEXT_URI_LIST,
		XDND_DIRECT_SAVE0,
		NETSCAPE_URL
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public enum ViewMode {
		ICON,
		LIST,
		MILLER_COLUMNS,
		CURRENT,
		PREFERRED,
		INVALID
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public enum ZoomLevel {
		SMALLEST,
		SMALLER,
		SMALL,
		NORMAL,
		LARGE,
		LARGER,
		HUGE,
		HUGER,
		LARGEST,
		N_LEVELS
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public delegate void PluginCallbackFunc (Gtk.Widget widget);
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string AFP_URI;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string DAVS_URI;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string DAV_URI;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string FTP_URI;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string MTP_URI;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string NETWORK_URI;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string RECENT_URI;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string ROOT_FS_URI;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string SFTP_URI;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string SMB_URI;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string TRASH_URI;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public static Marlin.ZoomLevel zoom_level_get_nearest_from_value (int size);
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public static Marlin.IconSize zoom_level_to_icon_size (Marlin.ZoomLevel zoom_level);
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public static Gtk.IconSize zoom_level_to_stock_icon_size (Marlin.ZoomLevel zoom_level);
}
[CCode (cprefix = "GOF", lower_case_cprefix = "gof_", ref_function = "gof_file_ref", unref_function = "gof_file_unref")]
namespace GOF {
	namespace Directory {
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public class Async : GLib.Object {
			public enum State {
				NOT_LOADED,
				LOADING,
				LOADED
			}
			public delegate void GOFFileLoadedFunc (GOF.File file);
			public GOF.File file;
			public uint files_count;
			public int icon_size;
			public GLib.File location;
			public string longest_file_name;
			public bool network_available;
			public bool permission_denied;
			public GLib.File? selected_file;
			public bool track_longest_name;
			public bool uri_contain_keypath_icons;
			public void block_monitor ();
			public static GOF.Directory.Async? cache_lookup (GLib.File? file);
			public static GOF.Directory.Async? cache_lookup_parent (GLib.File file);
			public void cancel ();
			public void cancel_thumbnailing ();
			public async bool check_network ();
			public GOF.File file_cache_find_or_insert (GLib.File file, bool update_hash = false);
			public void file_hash_add_file (GOF.File gof);
			public GOF.File? file_hash_lookup_location (GLib.File? location);
			public static GOF.Directory.Async from_file (GOF.File gof);
			public static GOF.Directory.Async from_gfile (GLib.File file);
			public GLib.File get_parent ();
			public unowned GLib.List<GOF.File>? get_sorted_dirs ();
			public bool has_parent ();
			public void init (GOF.Directory.Async.GOFFileLoadedFunc? file_loaded_func = null);
			public bool is_empty ();
			public bool is_loaded ();
			public bool is_loading ();
			public void load_hiddens ();
			public static void notify_files_added (GLib.List<GLib.File> files);
			public static void notify_files_changed (GLib.List<GLib.File> files);
			public static void notify_files_moved (GLib.List<GLib.Array<GLib.File>> files);
			public static void notify_files_removed (GLib.List<GLib.File> files);
			public bool purge_dir_from_cache ();
			public void queue_load_thumbnails (int size);
			public void reload ();
			public bool remove_dir_from_cache ();
			public static void remove_file_from_cache (GOF.File gof);
			public void unblock_monitor ();
			public void update_desktop_files ();
			public void update_files ();
			public bool can_load { get; private set; }
			public bool can_open_files { get; private set; }
			public bool can_stream_files { get; private set; }
			public bool freeze_update { get; set; }
			public bool has_mounts { get; private set; }
			public bool has_trash_dirs { get; private set; }
			public bool is_cancelled { get; }
			public bool is_local { get; private set; }
			public bool is_network { get; private set; }
			public bool is_no_info { get; private set; }
			public bool is_recent { get; private set; }
			public bool is_trash { get; private set; }
			public string scheme { get; private set; }
			public GOF.Directory.Async.State state { get; private set; }
			public signal void done_loading ();
			public signal void file_added (GOF.File? file);
			public signal void file_changed (GOF.File file);
			public signal void file_deleted (GOF.File file);
			public signal void file_loaded (GOF.File file);
			public signal void icon_changed (GOF.File file);
			public signal void need_reload (bool original_request);
			public signal void thumbs_loaded ();
		}
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public abstract class AbstractSlot : GLib.Object {
		protected Gtk.Box content_box;
		protected Gtk.Box extra_location_widgets;
		protected int slot_number;
		protected int width;
		public AbstractSlot ();
		public void add_extra_widget (Gtk.Widget widget);
		public abstract void cancel ();
		public abstract void close ();
		public virtual Gtk.Widget get_content_box ();
		public abstract unowned GOF.AbstractSlot? get_current_slot ();
		public virtual bool get_realized ();
		public virtual string? get_root_uri ();
		public abstract unowned GLib.List<weak GOF.File>? get_selected_files ();
		public virtual string? get_tip_uri ();
		public abstract void grab_focus ();
		protected void init ();
		public abstract void initialize_directory ();
		public abstract GLib.FileInfo? lookup_file_info (GLib.File loc);
		protected abstract void make_view ();
		public abstract void reload (bool non_local_only = false);
		public abstract void select_first_for_empty_selection ();
		public abstract void select_glib_files (GLib.List<GLib.File> locations, GLib.File? focus_location);
		public abstract void set_active_state (bool set_active, bool animate = true);
		public virtual bool set_all_selected (bool all_selected);
		public abstract void user_path_change_request (GLib.File loc, bool allow_mode_change, bool make_root);
		public virtual void zoom_in ();
		public virtual void zoom_normal ();
		public virtual void zoom_out ();
		public bool can_create { get; }
		public GOF.Directory.Async? directory { get; protected set; }
		public GOF.File file { get; }
		public virtual bool is_frozen { get; set; }
		public GLib.File location { get; }
		public virtual bool locked_focus { get; }
		public string uri { get; }
		public signal void active (bool scroll = true, bool animate = true);
		public signal void inactive ();
		public signal void path_changed (bool change_mode_to_icons = true);
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class CallWhenReady : GLib.Object {
		public delegate void call_when_ready_func (GLib.List<GOF.File> files);
		public GLib.List<GOF.File> files;
		public CallWhenReady (GLib.List<GOF.File> _files, GOF.CallWhenReady.call_when_ready_func? _f = null);
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class Preferences : GLib.Object {
		public bool pref_confirm_trash;
		public string pref_date_format;
		public bool pref_force_icon_size;
		public bool pref_interpret_desktop_files;
		public bool pref_show_hidden_files;
		public const string TAGS_COLORS[10];
		public Preferences ();
		public static GOF.Preferences get_default ();
		public bool confirm_trash { get; set; }
		public string date_format { get; set; }
		public bool force_icon_size { get; set; }
		public bool interpret_desktop_files { get; set; }
		public bool show_hidden_files { get; set; }
		public bool show_remote_thumbnails { get; set; }
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public static GOF.Preferences? preferences;
}
namespace PF {
	namespace FileUtils {
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public delegate void RenameCallbackFunc (GLib.File old_location, GLib.File? new_location, GLib.Error? error);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static string? escape_uri (string uri, bool allow_utf8 = true);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static GLib.File? get_file_for_path (string? path);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static string get_formatted_date_time (GLib.DateTime dt, string format = "locale");
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static string get_formatted_time_attribute_from_info (GLib.FileInfo info, string attr, string format = "locale");
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static string get_parent_path_from_path (string path);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static string get_smb_share_from_uri (string uri);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static bool path_has_parent (string new_path);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static void restore_files_from_trash (GLib.List<GOF.File> files, Gtk.Widget? widget);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static string sanitize_path (string? p, string? cp = null);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static void set_file_display_name (GLib.File old_location, string new_name, PF.FileUtils.RenameCallbackFunc? f);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static void split_protocol_from_path (string path, out string protocol, out string new_path);
	}
	namespace Sound {
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public const string DELETE;
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public const string EMPTY_TRASH;
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public const string THEME;
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class SoundManager : GLib.Object {
		public static unowned PF.SoundManager get_instance ();
		public void play_delete_sound ();
		public void play_empty_trash_sound ();
		public void play_sound (string pf_sound_id);
	}
}
[CCode (cheader_filename = "pantheon-files-core.h")]
public static Marlin.PluginManager plugins;
