/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.common;

public class ThreadPool {
    private Thread[] pool = null;
    private final String threadsBaseName;

    public ThreadPool(int n) {
        this(n, null);
    }

    public ThreadPool(int n, String string) {
        this.pool = new Thread[n];
        this.threadsBaseName = string;
    }

    public synchronized Thread getFreeThreadAndRun(Runnable runnable) {
        for (int i = 0; i < this.pool.length; ++i) {
            if (this.pool[i] != null && this.pool[i].isAlive()) continue;
            this.pool[i] = new Thread(runnable);
            if (this.threadsBaseName != null) {
                this.pool[i].setName(this.threadsBaseName + i);
            }
            this.pool[i].setDaemon(true);
            this.pool[i].start();
            return this.pool[i];
        }
        return null;
    }

    public void waitAllThreadComplete(int n) {
        for (int i = 0; i < this.pool.length; ++i) {
            if (this.pool[i] == null || !this.pool[i].isAlive()) continue;
            try {
                this.pool[i].join(n);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public boolean isAllThreadComplete() {
        for (int i = 0; i < this.pool.length; ++i) {
            if (this.pool[i] == null || !this.pool[i].isAlive()) continue;
            return false;
        }
        return true;
    }
}

