/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.db.paros;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.DbUtils;
import org.parosproxy.paros.db.RecordSessionUrl;
import org.parosproxy.paros.db.TableSessionUrl;
import org.parosproxy.paros.db.paros.ParosAbstractTable;

public class ParosTableSessionUrl
extends ParosAbstractTable
implements TableSessionUrl {
    private static final String TABLE_NAME = "SESSION_URL";
    private static final String URLID = "URLID";
    private static final String TYPE = "TYPE";
    private static final String URL = "URL";
    private PreparedStatement psRead = null;
    private PreparedStatement psInsert = null;
    private CallableStatement psGetIdLastInsert = null;
    private PreparedStatement psGetAlluRLSForType = null;
    private PreparedStatement psDeleteUrls = null;
    private PreparedStatement psDeleteAllUrlsForType = null;

    @Override
    protected void reconnect(Connection connection) throws DatabaseException {
        try {
            if (!DbUtils.hasTable(connection, TABLE_NAME)) {
                DbUtils.executeAndClose(connection.prepareStatement("CREATE cached TABLE SESSION_URL (urlid bigint generated by default as identity (start with 1), type int not null, url varchar(8192) default '')"));
            }
            this.psRead = connection.prepareStatement("SELECT * FROM SESSION_URL WHERE URLID = ?");
            this.psInsert = connection.prepareStatement("INSERT INTO SESSION_URL (TYPE,URL) VALUES (?, ?)");
            this.psGetIdLastInsert = connection.prepareCall("CALL IDENTITY();");
            this.psDeleteUrls = connection.prepareStatement("DELETE FROM SESSION_URL WHERE TYPE = ? AND URL = ?");
            this.psDeleteAllUrlsForType = connection.prepareStatement("DELETE FROM SESSION_URL WHERE TYPE = ?");
            this.psGetAlluRLSForType = connection.prepareStatement("SELECT * FROM SESSION_URL WHERE TYPE = ?");
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized RecordSessionUrl read(long l) throws DatabaseException {
        try {
            this.psRead.setLong(1, l);
            try (ResultSet resultSet = this.psRead.executeQuery();){
                RecordSessionUrl recordSessionUrl = this.build(resultSet);
                return recordSessionUrl;
            }
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public synchronized RecordSessionUrl insert(int n, String string) throws DatabaseException {
        try {
            long l;
            this.psInsert.setInt(1, n);
            this.psInsert.setString(2, string);
            this.psInsert.executeUpdate();
            try (ResultSet resultSet = this.psGetIdLastInsert.executeQuery();){
                resultSet.next();
                l = resultSet.getLong(1);
            }
            return this.read(l);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public synchronized void delete(int n, String string) throws DatabaseException {
        try {
            this.psDeleteUrls.setInt(1, n);
            this.psDeleteUrls.setString(2, string);
            this.psDeleteUrls.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public synchronized void deleteAllUrlsForType(int n) throws DatabaseException {
        try {
            this.psDeleteAllUrlsForType.setInt(1, n);
            this.psDeleteAllUrlsForType.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized List<RecordSessionUrl> getUrlsForType(int n) throws DatabaseException {
        try {
            this.psGetAlluRLSForType.setInt(1, n);
            try (ResultSet resultSet = this.psGetAlluRLSForType.executeQuery();){
                ArrayList<RecordSessionUrl> arrayList = new ArrayList<RecordSessionUrl>();
                while (resultSet.next()) {
                    arrayList.add(new RecordSessionUrl(resultSet.getLong(URLID), resultSet.getInt(TYPE), resultSet.getString(URL)));
                }
                ArrayList<RecordSessionUrl> arrayList2 = arrayList;
                return arrayList2;
            }
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    private RecordSessionUrl build(ResultSet resultSet) throws DatabaseException {
        try {
            RecordSessionUrl recordSessionUrl = null;
            if (resultSet.next()) {
                recordSessionUrl = new RecordSessionUrl(resultSet.getLong(URLID), resultSet.getInt(TYPE), resultSet.getString(URL));
            }
            return recordSessionUrl;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public void setUrls(int n, List<String> list) throws DatabaseException {
        this.deleteAllUrlsForType(n);
        for (String string : list) {
            this.insert(n, string);
        }
    }
}

