/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.brk;

import net.sf.json.JSONObject;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.brk.ExtensionBreak;

public class BreakAPI
extends ApiImplementor {
    private static final String PREFIX = "break";
    private static final String ACTION_BREAK = "break";
    private static final String ACTION_BREAK_ON_ID = "breakOnId";
    private static final String ACTION_ADD_HTTP_BREAK_POINT = "addHttpBreakpoint";
    private static final String ACTION_REM_HTTP_BREAK_POINT = "removeHttpBreakpoint";
    private static final String PARAM_STRING = "string";
    private static final String PARAM_LOCATION = "location";
    private static final String PARAM_MATCH = "match";
    private static final String PARAM_INVERSE = "inverse";
    private static final String PARAM_IGNORECASE = "ignorecase";
    private static final String PARAM_KEY = "key";
    private static final String PARAM_SCOPE = "scope";
    private static final String PARAM_STATE = "state";
    private static final String PARAM_TYPE = "type";
    private static final String VALUE_TYPE_HTTP_ALL = "http-all";
    private static final String VALUE_TYPE_HTTP_REQUESTS = "http-requests";
    private static final String VALUE_TYPE_HTTP_RESPONSES = "http-responses";
    private ExtensionBreak extension = null;

    public BreakAPI(ExtensionBreak extensionBreak) {
        this.extension = extensionBreak;
        this.addApiAction(new ApiAction("break", new String[]{PARAM_TYPE, PARAM_SCOPE, PARAM_STATE}));
        this.addApiAction(new ApiAction(ACTION_ADD_HTTP_BREAK_POINT, new String[]{PARAM_STRING, PARAM_LOCATION, PARAM_MATCH, PARAM_INVERSE, PARAM_IGNORECASE}));
        this.addApiAction(new ApiAction(ACTION_REM_HTTP_BREAK_POINT, new String[]{PARAM_STRING, PARAM_LOCATION, PARAM_MATCH, PARAM_INVERSE, PARAM_IGNORECASE}));
    }

    @Override
    public String getPrefix() {
        return "break";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ApiResponse handleApiAction(String string, JSONObject jSONObject) throws ApiException {
        if ("break".equals(string)) {
            String string2 = jSONObject.getString(PARAM_TYPE).toLowerCase();
            if (string2.equals(VALUE_TYPE_HTTP_ALL)) {
                this.extension.setBreakAllRequests(jSONObject.getBoolean(PARAM_STATE));
                this.extension.setBreakAllResponses(jSONObject.getBoolean(PARAM_STATE));
                return ApiResponseElement.OK;
            } else if (string2.equals(VALUE_TYPE_HTTP_REQUESTS)) {
                this.extension.setBreakAllRequests(jSONObject.getBoolean(PARAM_STATE));
                return ApiResponseElement.OK;
            } else {
                if (!string2.equals(VALUE_TYPE_HTTP_RESPONSES)) throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "type not in [http-all,http-requests,http-responses]");
                this.extension.setBreakAllResponses(jSONObject.getBoolean(PARAM_STATE));
            }
            return ApiResponseElement.OK;
        }
        if (ACTION_BREAK_ON_ID.equals(string)) {
            this.extension.setBreakOnId(jSONObject.getString(PARAM_KEY), jSONObject.getString(PARAM_STATE).toLowerCase().equals("on"));
            return ApiResponseElement.OK;
        }
        if (ACTION_ADD_HTTP_BREAK_POINT.equals(string)) {
            try {
                this.extension.addHttpBreakpoint(jSONObject.getString(PARAM_STRING), jSONObject.getString(PARAM_LOCATION), jSONObject.getString(PARAM_MATCH), jSONObject.getBoolean(PARAM_INVERSE), jSONObject.getBoolean(PARAM_IGNORECASE));
                return ApiResponseElement.OK;
            }
            catch (Exception exception) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, exception.getMessage());
            }
        }
        if (!ACTION_REM_HTTP_BREAK_POINT.equals(string)) throw new ApiException(ApiException.Type.BAD_ACTION);
        try {
            this.extension.removeHttpBreakpoint(jSONObject.getString(PARAM_STRING), jSONObject.getString(PARAM_LOCATION), jSONObject.getString(PARAM_MATCH), jSONObject.getBoolean(PARAM_INVERSE), jSONObject.getBoolean(PARAM_IGNORECASE));
            return ApiResponseElement.OK;
        }
        catch (Exception exception) {
            throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, exception.getMessage());
        }
    }
}

