/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.io.jts;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import org.locationtech.spatial4j.context.SpatialContextFactory;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import org.locationtech.spatial4j.io.PolyshapeWriter;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;

public class JtsPolyshapeWriter
extends PolyshapeWriter {
    protected final JtsSpatialContext ctx;

    public JtsPolyshapeWriter(JtsSpatialContext ctx, SpatialContextFactory factory) {
        super(ctx, factory);
        this.ctx = ctx;
    }

    protected void write(PolyshapeWriter.Encoder output, CoordinateSequence coordseq) throws IOException {
        int dim = coordseq.getDimension();
        for (int i = 0; i < coordseq.size(); ++i) {
            output.write(coordseq.getOrdinate(i, 0), coordseq.getOrdinate(i, 1));
        }
    }

    protected void write(PolyshapeWriter.Encoder output, Coordinate[] coord) throws IOException {
        for (int i = 0; i < coord.length; ++i) {
            output.write(coord[i].x, coord[i].y);
        }
    }

    protected void write(PolyshapeWriter.Encoder output, Polygon p) throws IOException {
        output.write('2');
        this.write(output, p.getExteriorRing().getCoordinateSequence());
        for (int i = 0; i < p.getNumInteriorRing(); ++i) {
            output.startRing();
            this.write(output, p.getInteriorRingN(i).getCoordinateSequence());
        }
    }

    public void write(PolyshapeWriter.Encoder output, Geometry geom) throws IOException {
        if (geom instanceof Point) {
            Point v = (Point)geom;
            output.write('0');
            this.write(output, v.getCoordinateSequence());
            return;
        }
        if (geom instanceof Polygon) {
            this.write(output, (Polygon)geom);
            return;
        }
        if (geom instanceof LineString) {
            LineString v = (LineString)geom;
            output.write('1');
            this.write(output, v.getCoordinateSequence());
            return;
        }
        if (geom instanceof MultiPoint) {
            MultiPoint v = (MultiPoint)geom;
            output.write('3');
            this.write(output, v.getCoordinates());
            return;
        }
        if (geom instanceof GeometryCollection) {
            GeometryCollection v = (GeometryCollection)geom;
            for (int i = 0; i < v.getNumGeometries(); ++i) {
                if (i > 0) {
                    output.seperator();
                }
                this.write(output, v.getGeometryN(i));
            }
        } else {
            throw new UnsupportedOperationException("unknown: " + geom);
        }
    }

    @Override
    public void write(PolyshapeWriter.Encoder enc, Shape shape) throws IOException {
        if (shape == null) {
            throw new NullPointerException("Shape can not be null");
        }
        if (shape instanceof JtsGeometry) {
            this.write(enc, ((JtsGeometry)shape).getGeom());
            return;
        }
        super.write(enc, shape);
    }
}

