/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.queries.TermsQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.DocValuesIndexFieldData;
import org.elasticsearch.index.fielddata.plain.PagedBytesIndexFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TextFieldMapper;
import org.elasticsearch.index.query.QueryShardContext;

public class TypeFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_type";
    public static final String CONTENT_TYPE = "_type";

    private TypeFieldMapper(Settings indexSettings, MappedFieldType existing) {
        this(existing == null ? TypeFieldMapper.defaultFieldType(indexSettings) : existing.clone(), indexSettings);
    }

    private TypeFieldMapper(MappedFieldType fieldType, Settings indexSettings) {
        super("_type", fieldType, TypeFieldMapper.defaultFieldType(indexSettings), indexSettings);
    }

    private static MappedFieldType defaultFieldType(Settings indexSettings) {
        MappedFieldType defaultFieldType = Defaults.FIELD_TYPE.clone();
        Version indexCreated = Version.indexCreated(indexSettings);
        if (indexCreated.before(Version.V_2_1_0)) {
            ((TypeFieldType)defaultFieldType).setFielddata(true);
        } else {
            defaultFieldType.setHasDocValues(true);
        }
        return defaultFieldType;
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
    }

    @Override
    public Mapper parse(ParseContext context) throws IOException {
        return null;
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        if (this.fieldType().indexOptions() == IndexOptions.NONE && !this.fieldType().stored()) {
            return;
        }
        fields.add((IndexableField)new Field(this.fieldType().name(), context.sourceToParse().type(), (FieldType)this.fieldType()));
        if (this.fieldType().hasDocValues()) {
            fields.add((IndexableField)new SortedSetDocValuesField(this.fieldType().name(), new BytesRef((CharSequence)context.sourceToParse().type())));
        }
    }

    @Override
    protected String contentType() {
        return "_type";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder;
    }

    @Override
    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
    }

    public static class TypesQuery
    extends Query {
        private static final int BOOLEAN_REWRITE_TERM_COUNT_THRESHOLD = 16;
        private final BytesRef[] types;

        public TypesQuery(BytesRef ... types) {
            if (types == null) {
                throw new NullPointerException("types cannot be null.");
            }
            if (types.length == 0) {
                throw new IllegalArgumentException("types must contains at least one value.");
            }
            this.types = types;
        }

        public BytesRef[] getTerms() {
            return this.types;
        }

        public Query rewrite(IndexReader reader) throws IOException {
            int threshold = Math.min(16, BooleanQuery.getMaxClauseCount());
            if (this.types.length <= threshold) {
                HashSet<BytesRef> uniqueTypes = new HashSet<BytesRef>();
                BooleanQuery.Builder bq = new BooleanQuery.Builder();
                int totalDocFreq = 0;
                for (BytesRef type : this.types) {
                    if (!uniqueTypes.add(type)) continue;
                    Term term = new Term("_type", type);
                    TermContext context = TermContext.build((IndexReaderContext)reader.getContext(), (Term)term);
                    if (context.docFreq() == 0) continue;
                    if ((totalDocFreq += context.docFreq()) >= reader.maxDoc()) {
                        assert (totalDocFreq == reader.maxDoc());
                        return new MatchAllDocsQuery();
                    }
                    bq.add((Query)new TermQuery(term, context), BooleanClause.Occur.SHOULD);
                }
                return new ConstantScoreQuery((Query)bq.build());
            }
            return new TermsQuery("_type", this.types);
        }

        public boolean equals(Object obj) {
            if (!this.sameClassAs(obj)) {
                return false;
            }
            TypesQuery that = (TypesQuery)((Object)obj);
            return Arrays.equals(this.types, that.types);
        }

        public int hashCode() {
            return 31 * this.classHash() + Arrays.hashCode(this.types);
        }

        public String toString(String field) {
            StringBuilder builder = new StringBuilder();
            for (BytesRef type : this.types) {
                if (builder.length() > 0) {
                    builder.append(' ');
                }
                builder.append(new Term("_type", type).toString());
            }
            return builder.toString();
        }
    }

    static final class TypeFieldType
    extends StringFieldType {
        private boolean fielddata;

        public TypeFieldType() {
            this.fielddata = false;
        }

        protected TypeFieldType(TypeFieldType ref) {
            super(ref);
            this.fielddata = ref.fielddata;
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            TypeFieldType that = (TypeFieldType)((Object)o);
            return this.fielddata == that.fielddata;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.fielddata);
        }

        @Override
        public MappedFieldType clone() {
            return new TypeFieldType(this);
        }

        @Override
        public String typeName() {
            return "_type";
        }

        public boolean fielddata() {
            return this.fielddata;
        }

        public void setFielddata(boolean fielddata) {
            this.checkIfFrozen();
            this.fielddata = fielddata;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder() {
            if (this.hasDocValues()) {
                return new DocValuesIndexFieldData.Builder();
            }
            assert (this.indexOptions() != IndexOptions.NONE);
            if (this.fielddata) {
                return new PagedBytesIndexFieldData.Builder(TextFieldMapper.Defaults.FIELDDATA_MIN_FREQUENCY, TextFieldMapper.Defaults.FIELDDATA_MAX_FREQUENCY, TextFieldMapper.Defaults.FIELDDATA_MIN_SEGMENT_SIZE);
            }
            return super.fielddataBuilder();
        }

        @Override
        public Query termQuery(Object value, @Nullable QueryShardContext context) {
            if (this.indexOptions() == IndexOptions.NONE) {
                throw new AssertionError();
            }
            return new TypesQuery(this.indexedValueForSearch(value));
        }

        @Override
        public void checkCompatibility(MappedFieldType other, List<String> conflicts, boolean strict) {
            super.checkCompatibility(other, conflicts, strict);
            TypeFieldType otherType = (TypeFieldType)other;
            if (strict && this.fielddata() != otherType.fielddata()) {
                conflicts.add("mapper [" + this.name() + "] is used by multiple types. Set update_all_types to true to update [fielddata] across all types.");
            }
        }
    }

    public static class TypeParser
    implements MetadataFieldMapper.TypeParser {
        @Override
        public MetadataFieldMapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            throw new MapperParsingException("_type is not configurable");
        }

        @Override
        public MetadataFieldMapper getDefault(MappedFieldType fieldType, Mapper.TypeParser.ParserContext context) {
            Settings indexSettings = context.mapperService().getIndexSettings().getSettings();
            return new TypeFieldMapper(indexSettings, fieldType);
        }
    }

    public static class Defaults {
        public static final String NAME = "_type";
        public static final MappedFieldType FIELD_TYPE = new TypeFieldType();

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setName("_type");
            FIELD_TYPE.freeze();
        }
    }
}

