/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.index.engine.Engine;

public interface IndexingOperationListener {
    default public Engine.Index preIndex(Engine.Index operation) {
        return operation;
    }

    default public void postIndex(Engine.Index index, boolean created) {
    }

    default public void postIndex(Engine.Index index, Exception ex) {
    }

    default public Engine.Delete preDelete(Engine.Delete delete) {
        return delete;
    }

    default public void postDelete(Engine.Delete delete) {
    }

    default public void postDelete(Engine.Delete delete, Exception ex) {
    }

    public static final class CompositeListener
    implements IndexingOperationListener {
        private final List<IndexingOperationListener> listeners;
        private final Logger logger;

        public CompositeListener(List<IndexingOperationListener> listeners, Logger logger) {
            this.listeners = listeners;
            this.logger = logger;
        }

        @Override
        public Engine.Index preIndex(Engine.Index operation) {
            assert (operation != null);
            for (IndexingOperationListener listener : this.listeners) {
                try {
                    listener.preIndex(operation);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("preIndex listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
            return operation;
        }

        @Override
        public void postIndex(Engine.Index index, boolean created) {
            assert (index != null);
            for (IndexingOperationListener listener : this.listeners) {
                try {
                    listener.postIndex(index, created);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("postIndex listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        @Override
        public void postIndex(Engine.Index index, Exception ex) {
            assert (index != null && ex != null);
            for (IndexingOperationListener listener : this.listeners) {
                try {
                    listener.postIndex(index, ex);
                }
                catch (Exception inner) {
                    inner.addSuppressed(ex);
                    this.logger.warn(() -> new ParameterizedMessage("postIndex listener [{}] failed", (Object)listener), (Throwable)inner);
                }
            }
        }

        @Override
        public Engine.Delete preDelete(Engine.Delete delete) {
            assert (delete != null);
            for (IndexingOperationListener listener : this.listeners) {
                try {
                    listener.preDelete(delete);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("preDelete listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
            return delete;
        }

        @Override
        public void postDelete(Engine.Delete delete) {
            assert (delete != null);
            for (IndexingOperationListener listener : this.listeners) {
                try {
                    listener.postDelete(delete);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("postDelete listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        @Override
        public void postDelete(Engine.Delete delete, Exception ex) {
            assert (delete != null && ex != null);
            for (IndexingOperationListener listener : this.listeners) {
                try {
                    listener.postDelete(delete, ex);
                }
                catch (Exception inner) {
                    inner.addSuppressed(ex);
                    this.logger.warn(() -> new ParameterizedMessage("postDelete listener [{}] failed", (Object)listener), (Throwable)inner);
                }
            }
        }
    }
}

