/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.hyphenation;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.io.InternalResourceResolver;
import org.apache.fop.hyphenation.Hyphenation;
import org.apache.fop.hyphenation.HyphenationException;
import org.apache.fop.hyphenation.HyphenationTree;
import org.apache.fop.hyphenation.HyphenationTreeCache;
import org.xml.sax.InputSource;

public final class Hyphenator {
    private static final Log log = LogFactory.getLog(Hyphenator.class);
    private static HyphenationTreeCache hTreeCache;
    private static boolean statisticsDump;

    private Hyphenator() {
    }

    public static synchronized HyphenationTreeCache getHyphenationTreeCache() {
        if (hTreeCache == null) {
            hTreeCache = new HyphenationTreeCache();
        }
        return hTreeCache;
    }

    public static synchronized void clearHyphenationTreeCache() {
        hTreeCache = new HyphenationTreeCache();
    }

    public static HyphenationTree getHyphenationTree(String lang, String country, InternalResourceResolver resolver, Map hyphPatNames) {
        String llKey;
        String llccKey = HyphenationTreeCache.constructLlccKey(lang, country);
        HyphenationTreeCache cache = Hyphenator.getHyphenationTreeCache();
        if (cache.isMissing(llccKey)) {
            return null;
        }
        HyphenationTree hTree = Hyphenator.getHyphenationTree2(lang, country, resolver, hyphPatNames);
        if (hTree == null && country != null && !country.equals("none") && !cache.isMissing(llKey = HyphenationTreeCache.constructLlccKey(lang, null))) {
            hTree = Hyphenator.getHyphenationTree2(lang, null, resolver, hyphPatNames);
            if (hTree != null && log.isDebugEnabled()) {
                log.debug((Object)("Couldn't find hyphenation pattern for lang=\"" + lang + "\",country=\"" + country + "\"." + " Using general language pattern " + "for lang=\"" + lang + "\" instead."));
            }
            if (hTree == null) {
                cache.noteMissing(llKey);
            } else {
                cache.cache(llccKey, hTree);
            }
        }
        if (hTree == null) {
            cache.noteMissing(llccKey);
            log.error((Object)("Couldn't find hyphenation pattern for lang=\"" + lang + "\"" + (country != null && !country.equals("none") ? ",country=\"" + country + "\"" : "") + "."));
        }
        return hTree;
    }

    public static HyphenationTree getHyphenationTree2(String lang, String country, InternalResourceResolver resourceResolver, Map hyphPatNames) {
        String llccKey = HyphenationTreeCache.constructLlccKey(lang, country);
        HyphenationTreeCache cache = Hyphenator.getHyphenationTreeCache();
        HyphenationTree hTree = Hyphenator.getHyphenationTreeCache().getHyphenationTree(lang, country);
        if (hTree != null) {
            return hTree;
        }
        String key = HyphenationTreeCache.constructUserKey(lang, country, hyphPatNames);
        if (key == null) {
            key = llccKey;
        }
        if (resourceResolver != null) {
            hTree = Hyphenator.getUserHyphenationTree(key, resourceResolver);
        }
        if (hTree == null) {
            hTree = Hyphenator.getFopHyphenationTree(key);
        }
        if (hTree != null) {
            cache.cache(llccKey, hTree);
        }
        return hTree;
    }

    private static InputStream getResourceStream(String key) {
        InputStream is = null;
        try {
            Method getCCL = Thread.class.getMethod("getContextClassLoader", new Class[0]);
            if (getCCL != null) {
                ClassLoader contextClassLoader = (ClassLoader)getCCL.invoke((Object)Thread.currentThread(), new Object[0]);
                is = contextClassLoader.getResourceAsStream("hyph/" + key + ".hyp");
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        if (is == null) {
            is = Hyphenator.class.getResourceAsStream("/hyph/" + key + ".hyp");
        }
        return is;
    }

    private static HyphenationTree readHyphenationTree(InputStream in) {
        HyphenationTree hTree = null;
        try {
            ObjectInputStream ois = new ObjectInputStream(in);
            hTree = (HyphenationTree)ois.readObject();
        }
        catch (IOException ioe) {
            log.error((Object)"I/O error while loading precompiled hyphenation pattern file", (Throwable)ioe);
        }
        catch (ClassNotFoundException cnfe) {
            log.error((Object)"Error while reading hyphenation object from file", (Throwable)cnfe);
        }
        return hTree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HyphenationTree getFopHyphenationTree(String key) {
        HyphenationTree hTree = null;
        InputStream ois = null;
        InputStream is = null;
        try {
            is = Hyphenator.getResourceStream(key);
            if (is == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Couldn't find precompiled hyphenation pattern " + key + " in resources"));
                }
                HyphenationTree hyphenationTree = null;
                return hyphenationTree;
            }
            hTree = Hyphenator.readHyphenationTree(is);
        }
        finally {
            IOUtils.closeQuietly(ois);
        }
        return hTree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HyphenationTree getUserHyphenationTree(String key, InternalResourceResolver resourceResolver) {
        HyphenationTree hTree = null;
        String name = key + ".hyp";
        try {
            InputStream in = Hyphenator.getHyphenationTreeStream(name, resourceResolver);
            try {
                hTree = Hyphenator.readHyphenationTree(in);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
            return hTree;
        }
        catch (IOException ioe) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("I/O problem while trying to load " + name), (Throwable)ioe);
            }
            name = key + ".xml";
            hTree = new HyphenationTree();
            try {
                InputStream in = Hyphenator.getHyphenationTreeStream(name, resourceResolver);
                try {
                    InputSource src = new InputSource(in);
                    src.setSystemId(name);
                    hTree.loadPatterns(src);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)in);
                }
                if (statisticsDump) {
                    System.out.println("Stats: ");
                    hTree.printStats();
                }
                return hTree;
            }
            catch (HyphenationException ex) {
                log.error((Object)("Can't load user patterns from XML file " + name + ": " + ex.getMessage()));
                return null;
            }
            catch (IOException ioe2) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("I/O problem while trying to load " + name), (Throwable)ioe2);
                }
                return null;
            }
        }
    }

    private static InputStream getHyphenationTreeStream(String name, InternalResourceResolver resourceResolver) throws IOException {
        try {
            return new BufferedInputStream((InputStream)resourceResolver.getResource(name));
        }
        catch (URISyntaxException use) {
            log.debug((Object)("An exception was thrown while attempting to load " + name), (Throwable)use);
            return null;
        }
    }

    public static Hyphenation hyphenate(String lang, String country, InternalResourceResolver resourceResolver, Map hyphPatNames, String word, int leftMin, int rightMin) {
        HyphenationTree hTree = Hyphenator.getHyphenationTree(lang, country, resourceResolver, hyphPatNames);
        if (hTree == null) {
            return null;
        }
        return hTree.hyphenate(word, leftMin, rightMin);
    }
}

