/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pcl.fonts.truetype;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.fop.fonts.truetype.GlyfTable;
import org.apache.fop.fonts.truetype.OFDirTabEntry;
import org.apache.fop.fonts.truetype.OFMtxEntry;
import org.apache.fop.fonts.truetype.OFTableName;
import org.apache.fop.fonts.truetype.TTFFile;
import org.apache.fop.render.pcl.fonts.PCLCharacterDefinition;
import org.apache.fop.render.pcl.fonts.PCLCharacterWriter;
import org.apache.fop.render.pcl.fonts.PCLSoftFont;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PCLTTFCharacterWriter
extends PCLCharacterWriter {
    private List<OFMtxEntry> mtx;
    private OFDirTabEntry tabEntry;

    public PCLTTFCharacterWriter(PCLSoftFont softFont) throws IOException {
        super(softFont);
        softFont.setMtxCharIndexes(this.scanMtxCharacters());
    }

    @Override
    public byte[] writeCharacterDefinitions(String text) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (char ch : text.toCharArray()) {
            char character = ch;
            if (this.font.hasPreviouslyWritten(character)) continue;
            PCLCharacterDefinition pclChar = this.getCharacterDefinition(ch);
            this.writePCLCharacter(baos, pclChar);
            List<PCLCharacterDefinition> compositeGlyphs = pclChar.getCompositeGlyphs();
            for (PCLCharacterDefinition composite : compositeGlyphs) {
                this.writePCLCharacter(baos, composite);
            }
        }
        return baos.toByteArray();
    }

    private void writePCLCharacter(ByteArrayOutputStream baos, PCLCharacterDefinition pclChar) throws IOException {
        baos.write(pclChar.getCharacterCommand());
        baos.write(pclChar.getCharacterDefinitionCommand());
        baos.write(pclChar.getData());
    }

    private Map<Integer, Integer> scanMtxCharacters() throws IOException {
        HashMap<Integer, Integer> charMtxOffsets = new HashMap<Integer, Integer>();
        List<OFMtxEntry> mtx = this.openFont.getMtx();
        OFTableName glyfTag = OFTableName.GLYF;
        if (this.openFont.seekTab(this.fontReader, glyfTag, 0L)) {
            for (int i = 1; i < mtx.size(); ++i) {
                OFMtxEntry entry = mtx.get(i);
                int charCode = 0;
                charCode = entry.getUnicodeIndex().size() > 0 ? ((Integer)entry.getUnicodeIndex().get(0)).intValue() : entry.getIndex();
                charMtxOffsets.put(charCode, i);
            }
        }
        return charMtxOffsets;
    }

    private PCLCharacterDefinition getCharacterDefinition(int unicode) throws IOException {
        if (this.mtx == null) {
            this.mtx = this.openFont.getMtx();
            this.tabEntry = this.openFont.getDirectoryEntry(OFTableName.GLYF);
        }
        if (this.openFont.seekTab(this.fontReader, OFTableName.GLYF, 0L)) {
            int charIndex = this.font.getMtxCharIndex(unicode);
            if (charIndex == 0) {
                charIndex = this.font.getCmapGlyphIndex(unicode);
            }
            HashMap<Integer, Integer> subsetGlyphs = new HashMap<Integer, Integer>();
            subsetGlyphs.put(charIndex, 1);
            byte[] glyphData = this.getGlyphData(charIndex);
            this.font.writeCharacter(unicode);
            PCLCharacterDefinition newChar = new PCLCharacterDefinition(this.font.getCharCode((char)unicode), PCLCharacterDefinition.PCLCharacterFormat.TrueType, PCLCharacterDefinition.PCLCharacterClass.TrueType, glyphData, this.pclByteWriter, false);
            GlyfTable glyfTable = new GlyfTable(this.fontReader, this.mtx.toArray(new OFMtxEntry[this.mtx.size()]), this.tabEntry, subsetGlyphs);
            if (glyfTable.isComposite(charIndex)) {
                Set<Integer> composites = glyfTable.retrieveComposedGlyphs(charIndex);
                for (Integer compositeIndex : composites) {
                    byte[] compositeData = this.getGlyphData(compositeIndex);
                    newChar.addCompositeGlyph(new PCLCharacterDefinition(compositeIndex, PCLCharacterDefinition.PCLCharacterFormat.TrueType, PCLCharacterDefinition.PCLCharacterClass.TrueType, compositeData, this.pclByteWriter, true));
                }
            }
            return newChar;
        }
        return null;
    }

    private byte[] getGlyphData(int charIndex) throws IOException {
        OFMtxEntry entry = this.mtx.get(charIndex);
        int nextOffset = 0;
        if (charIndex < this.mtx.size() - 1) {
            OFMtxEntry nextEntry = this.mtx.get(charIndex + 1);
            nextOffset = (int)nextEntry.getOffset();
        } else {
            nextOffset = (int)((TTFFile)this.openFont).getLastGlyfLocation();
        }
        int glyphOffset = (int)entry.getOffset();
        int glyphLength = nextOffset - glyphOffset;
        byte[] glyphData = new byte[]{};
        if (glyphLength > 0) {
            glyphData = this.fontReader.getBytes((int)this.tabEntry.getOffset() + glyphOffset, glyphLength);
        }
        return glyphData;
    }
}

