/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.tasks;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.internal.tasks.CacheableTaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.TaskOutputFilePropertySpec;
import org.gradle.caching.internal.tasks.TaskOutputPacker;
import org.gradle.caching.internal.tasks.origin.TaskOutputOriginReader;
import org.gradle.caching.internal.tasks.origin.TaskOutputOriginWriter;

public class OutputPreparingTaskOutputPacker
implements TaskOutputPacker {
    private final TaskOutputPacker delegate;

    public OutputPreparingTaskOutputPacker(TaskOutputPacker delegate) {
        this.delegate = delegate;
    }

    public void pack(TaskOutputsInternal taskOutputs, OutputStream output, TaskOutputOriginWriter writeOrigin) {
        this.delegate.pack(taskOutputs, output, writeOrigin);
    }

    public void unpack(TaskOutputsInternal taskOutputs, InputStream input, TaskOutputOriginReader readOrigin) {
        block6: for (TaskOutputFilePropertySpec propertySpec : taskOutputs.getFileProperties()) {
            CacheableTaskOutputFilePropertySpec property = (CacheableTaskOutputFilePropertySpec)propertySpec;
            File output = property.getOutputFile();
            if (output == null) continue;
            try {
                switch (property.getOutputType()) {
                    case DIRECTORY: {
                        OutputPreparingTaskOutputPacker.makeDirectory(output);
                        FileUtils.cleanDirectory((File)output);
                        break;
                    }
                    case FILE: {
                        if (OutputPreparingTaskOutputPacker.makeDirectory(output.getParentFile()) || !output.exists()) continue block6;
                        FileUtils.forceDelete((File)output);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException((Throwable)e);
            }
        }
        this.delegate.unpack(taskOutputs, input, readOrigin);
    }

    private static boolean makeDirectory(File output) throws IOException {
        if (output.isDirectory()) {
            return false;
        }
        if (output.isFile()) {
            FileUtils.forceDelete((File)output);
        }
        FileUtils.forceMkdir((File)output);
        return true;
    }
}

