/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.exec;

import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.event.ListenerBroadcast;
import org.gradle.internal.event.ListenerManager;
import org.gradle.launcher.daemon.server.api.DaemonCommandAction;
import org.gradle.launcher.daemon.server.api.DaemonCommandExecution;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationListener;

public class WatchForDisconnection
implements DaemonCommandAction {
    private static final Logger LOGGER = Logging.getLogger(WatchForDisconnection.class);
    private final ListenerBroadcast<DaemonExpirationListener> listenerBroadcast;
    public static final String EXPIRATION_REASON = "client disconnected";

    public WatchForDisconnection(ListenerManager listenerManager) {
        this.listenerBroadcast = listenerManager.createAnonymousBroadcaster(DaemonExpirationListener.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(final DaemonCommandExecution execution) {
        execution.getConnection().onDisconnect(new Runnable(){

            public void run() {
                LOGGER.warn("thread {}: client disconnection detected, canceling the build", (Object)Thread.currentThread().getId());
                execution.getDaemonStateControl().requestCancel();
            }
        });
        try {
            execution.proceed();
        }
        finally {
            execution.getConnection().onDisconnect(null);
        }
    }
}

