/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

import org.apache.xerces.util.AugmentationsImpl;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;

public class XMLAttributesImpl
implements XMLAttributes,
AttributeList,
Attributes {
    protected boolean fNamespaces = true;
    protected int fLength;
    protected Attribute[] fAttributes = new Attribute[4];
    protected Augmentations[] fAugmentations = new AugmentationsImpl[4];

    public XMLAttributesImpl() {
        int n = 0;
        while (n < this.fAttributes.length) {
            this.fAttributes[n] = new Attribute();
            this.fAugmentations[n] = new AugmentationsImpl();
            ++n;
        }
    }

    public void setNamespaces(boolean bl) {
        this.fNamespaces = bl;
    }

    public int addAttribute(QName qName, String string, String string2) {
        Attribute[] attributeArray;
        int n;
        int n2 = n = qName.uri != null && !qName.uri.equals("") ? this.getIndex(qName.uri, qName.localpart) : this.getIndex(qName.rawname);
        if (n == -1) {
            n = this.fLength;
            if (this.fLength++ == this.fAttributes.length) {
                attributeArray = new Attribute[this.fAttributes.length + 4];
                AugmentationsImpl[] augmentationsImplArray = new AugmentationsImpl[this.fAttributes.length + 4];
                System.arraycopy(this.fAttributes, 0, attributeArray, 0, this.fAttributes.length);
                System.arraycopy(this.fAugmentations, 0, augmentationsImplArray, 0, this.fAttributes.length);
                int n3 = this.fAttributes.length;
                while (n3 < attributeArray.length) {
                    attributeArray[n3] = new Attribute();
                    augmentationsImplArray[n3] = new AugmentationsImpl();
                    ++n3;
                }
                this.fAttributes = attributeArray;
                this.fAugmentations = augmentationsImplArray;
            }
        }
        this.fAugmentations[n].clear();
        attributeArray = this.fAttributes[n];
        attributeArray.name.setValues(qName);
        attributeArray.type = string;
        attributeArray.value = string2;
        attributeArray.nonNormalizedValue = string2;
        attributeArray.specified = false;
        return n;
    }

    public void removeAllAttributes() {
        this.fLength = 0;
    }

    public void removeAttributeAt(int n) {
        if (n < this.fLength - 1) {
            Attribute attribute = this.fAttributes[n];
            Augmentations augmentations = this.fAugmentations[n];
            System.arraycopy(this.fAttributes, n + 1, this.fAttributes, n, this.fLength - n - 1);
            System.arraycopy(this.fAugmentations, n + 1, this.fAugmentations, n, this.fLength - n - 1);
            this.fAttributes[this.fLength - 1] = attribute;
            this.fAugmentations[this.fLength - 1] = augmentations;
        }
        --this.fLength;
    }

    public void setName(int n, QName qName) {
        this.fAttributes[n].name.setValues(qName);
    }

    public void getName(int n, QName qName) {
        qName.setValues(this.fAttributes[n].name);
    }

    public void setType(int n, String string) {
        this.fAttributes[n].type = string;
    }

    public void setValue(int n, String string) {
        Attribute attribute = this.fAttributes[n];
        attribute.value = string;
        attribute.nonNormalizedValue = string;
    }

    public void setNonNormalizedValue(int n, String string) {
        if (string == null) {
            string = this.fAttributes[n].value;
        }
        this.fAttributes[n].nonNormalizedValue = string;
    }

    public String getNonNormalizedValue(int n) {
        String string = this.fAttributes[n].nonNormalizedValue;
        return string;
    }

    public void setSpecified(int n, boolean bl) {
        this.fAttributes[n].specified = bl;
    }

    public boolean isSpecified(int n) {
        return this.fAttributes[n].specified;
    }

    public int getLength() {
        return this.fLength;
    }

    public String getType(int n) {
        if (n < 0 || n >= this.fLength) {
            return null;
        }
        String string = this.fAttributes[n].type;
        if (string.indexOf(40) == 0 && string.lastIndexOf(41) == string.length() - 1) {
            return "NMTOKEN";
        }
        return string;
    }

    public String getType(String string) {
        int n = this.getIndex(string);
        return n != -1 ? this.fAttributes[n].type : null;
    }

    public String getValue(int n) {
        if (n < 0 || n >= this.fLength) {
            return null;
        }
        return this.fAttributes[n].value;
    }

    public String getValue(String string) {
        int n = this.getIndex(string);
        return n != -1 ? this.fAttributes[n].value : null;
    }

    public String getName(int n) {
        if (n < 0 || n >= this.fLength) {
            return null;
        }
        return this.fAttributes[n].name.rawname;
    }

    public int getIndex(String string) {
        int n = 0;
        while (n < this.fLength) {
            Attribute attribute = this.fAttributes[n];
            if (attribute.name.rawname != null && attribute.name.rawname.equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getIndex(String string, String string2) {
        int n = 0;
        while (n < this.fLength) {
            Attribute attribute = this.fAttributes[n];
            if (attribute.name.localpart != null && attribute.name.localpart.equals(string2) && (string == attribute.name.uri || string != null && attribute.name.uri != null && attribute.name.uri.equals(string))) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public String getLocalName(int n) {
        if (!this.fNamespaces) {
            return "";
        }
        if (n < 0 || n >= this.fLength) {
            return null;
        }
        return this.fAttributes[n].name.localpart;
    }

    public String getQName(int n) {
        if (n < 0 || n >= this.fLength) {
            return null;
        }
        String string = this.fAttributes[n].name.rawname;
        return string != null ? string : "";
    }

    public String getType(String string, String string2) {
        if (!this.fNamespaces) {
            return null;
        }
        int n = this.getIndex(string, string2);
        return n != -1 ? this.getType(n) : null;
    }

    public String getPrefix(int n) {
        if (n < 0 || n >= this.fLength) {
            return null;
        }
        String string = this.fAttributes[n].name.prefix;
        return string != null ? string : "";
    }

    public String getURI(int n) {
        if (n < 0 || n >= this.fLength) {
            return null;
        }
        String string = this.fAttributes[n].name.uri;
        return string;
    }

    public String getValue(String string, String string2) {
        int n = this.getIndex(string, string2);
        return n != -1 ? this.getValue(n) : null;
    }

    public Augmentations getAugmentations(String string, String string2) {
        int n = this.getIndex(string, string2);
        return n != -1 ? this.fAugmentations[n] : null;
    }

    public Augmentations getAugmentations(String string) {
        int n = this.getIndex(string);
        return n != -1 ? this.fAugmentations[n] : null;
    }

    public Augmentations getAugmentations(int n) {
        if (n < 0 || n >= this.fLength) {
            return null;
        }
        return this.fAugmentations[n];
    }

    static class Attribute {
        public QName name = new QName();
        public String type;
        public String value;
        public String nonNormalizedValue;
        public boolean specified;

        Attribute() {
        }
    }
}

