/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed;

import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.ScriptingContainer;
import org.jruby.util.ClassesLoader;
import org.jruby.util.UriLikePathHelper;

public class IsolatedScriptingContainer
extends ScriptingContainer {
    private static final String URI_CLASSLOADER = "uri:classloader:/";

    public IsolatedScriptingContainer() {
        this(LocalContextScope.SINGLETON);
    }

    public IsolatedScriptingContainer(LocalContextScope scope, LocalVariableBehavior behavior) {
        this(scope, behavior, true);
    }

    public IsolatedScriptingContainer(LocalContextScope scope) {
        this(scope, LocalVariableBehavior.TRANSIENT);
    }

    public IsolatedScriptingContainer(LocalVariableBehavior behavior) {
        this(LocalContextScope.SINGLETON, behavior);
    }

    public IsolatedScriptingContainer(LocalContextScope scope, LocalVariableBehavior behavior, boolean lazy) {
        super(scope, behavior, lazy);
        LinkedList<String> loadPaths = new LinkedList<String>();
        loadPaths.add(URI_CLASSLOADER);
        this.setLoadPaths(loadPaths);
        UriLikePathHelper uriPath = new UriLikePathHelper(new ClassesLoader(this.getClassLoader()));
        URL url = uriPath.getResource("/.jrubydir");
        if (url != null) {
            this.setCurrentDirectory(URI_CLASSLOADER);
        }
        this.setEnvironment(null);
        this.getProvider().getRubyInstanceConfig().setClassloaderDelegate(false);
    }

    @Override
    public void setEnvironment(Map environment) {
        if (!(environment != null && environment.containsKey("GEM_PATH") && environment.containsKey("GEM_HOME") && environment.containsKey("JARS_HOME"))) {
            HashMap<String, String> env;
            HashMap<String, String> hashMap = env = environment == null ? new HashMap<String, String>() : new HashMap(environment);
            if (!env.containsKey("GEM_PATH")) {
                env.put("GEM_PATH", URI_CLASSLOADER);
            }
            if (!env.containsKey("GEM_HOME")) {
                env.put("GEM_HOME", URI_CLASSLOADER);
            }
            if (!env.containsKey("JARS_HOME")) {
                env.put("JARS_HOME", "uri:classloader:/jars");
            }
            super.setEnvironment(env);
        } else {
            super.setEnvironment(environment);
        }
    }
}

