/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import java.util.Arrays;
import org.jruby.truffle.core.array.ArrayMirror;
import org.jruby.truffle.core.array.ArrayUtils;
import org.jruby.truffle.core.array.BasicArrayMirror;

class LongArrayMirror
extends BasicArrayMirror {
    private final long[] array;

    public LongArrayMirror(long[] array) {
        this.array = array;
    }

    @Override
    public int getLength() {
        return this.array.length;
    }

    @Override
    public Object get(int index) {
        return this.array[index];
    }

    @Override
    public void set(int index, Object value) {
        this.array[index] = value instanceof Integer ? (long)((Integer)value).intValue() : (Long)value;
    }

    @Override
    public ArrayMirror copyArrayAndMirror() {
        return new LongArrayMirror((long[])this.array.clone());
    }

    @Override
    public ArrayMirror copyArrayAndMirror(int newLength) {
        return new LongArrayMirror(Arrays.copyOf(this.array, newLength));
    }

    @Override
    public void copyTo(ArrayMirror destination, int sourceStart, int destinationStart, int count) {
        for (int i = 0; i < count; ++i) {
            destination.set(destinationStart + i, this.array[sourceStart + i]);
        }
    }

    @Override
    public void copyTo(Object[] destination, int sourceStart, int destinationStart, int count) {
        for (int n = 0; n < count; ++n) {
            destination[destinationStart + n] = this.array[sourceStart + n];
        }
    }

    @Override
    public ArrayMirror extractRange(int start, int end) {
        return new LongArrayMirror(ArrayUtils.extractRange(this.array, start, end));
    }

    @Override
    public Object getArray() {
        return this.array;
    }
}

