/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.unpack;

import com.oracle.truffle.api.nodes.Node;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.format.SharedTreeBuilder;
import org.jruby.truffle.core.format.control.AdvanceSourcePositionNode;
import org.jruby.truffle.core.format.control.ReverseSourcePositionNode;
import org.jruby.truffle.core.format.control.SequenceNode;
import org.jruby.truffle.core.format.control.SetSourcePositionNode;
import org.jruby.truffle.core.format.convert.BytesToInteger16BigNodeGen;
import org.jruby.truffle.core.format.convert.BytesToInteger16LittleNodeGen;
import org.jruby.truffle.core.format.convert.BytesToInteger32BigNodeGen;
import org.jruby.truffle.core.format.convert.BytesToInteger32LittleNodeGen;
import org.jruby.truffle.core.format.convert.BytesToInteger64BigNodeGen;
import org.jruby.truffle.core.format.convert.BytesToInteger64LittleNodeGen;
import org.jruby.truffle.core.format.convert.ReinterpretAsUnsignedNodeGen;
import org.jruby.truffle.core.format.convert.ReinterpretByteAsIntegerNodeGen;
import org.jruby.truffle.core.format.convert.ReinterpretIntegerAsFloatNodeGen;
import org.jruby.truffle.core.format.convert.ReinterpretLongAsDoubleNodeGen;
import org.jruby.truffle.core.format.pack.SimplePackListener;
import org.jruby.truffle.core.format.read.SourceNode;
import org.jruby.truffle.core.format.read.bytes.ReadBERNodeGen;
import org.jruby.truffle.core.format.read.bytes.ReadBase64StringNodeGen;
import org.jruby.truffle.core.format.read.bytes.ReadBinaryStringNode;
import org.jruby.truffle.core.format.read.bytes.ReadBinaryStringNodeGen;
import org.jruby.truffle.core.format.read.bytes.ReadBitStringNodeGen;
import org.jruby.truffle.core.format.read.bytes.ReadByteNodeGen;
import org.jruby.truffle.core.format.read.bytes.ReadBytesNode;
import org.jruby.truffle.core.format.read.bytes.ReadBytesNodeGen;
import org.jruby.truffle.core.format.read.bytes.ReadHexStringNodeGen;
import org.jruby.truffle.core.format.read.bytes.ReadMIMEStringNodeGen;
import org.jruby.truffle.core.format.read.bytes.ReadUTF8CharacterNodeGen;
import org.jruby.truffle.core.format.read.bytes.ReadUUStringNodeGen;
import org.jruby.truffle.core.format.write.OutputNode;
import org.jruby.truffle.core.format.write.array.WriteValueNode;
import org.jruby.truffle.core.format.write.array.WriteValueNodeGen;
import org.jruby.truffle.language.control.RaiseException;

public class SimpleUnpackTreeBuilder
implements SimplePackListener {
    private final RubyContext context;
    private final Node currentNode;
    private final SharedTreeBuilder sharedTreeBuilder;
    private final Deque<List<FormatNode>> sequenceStack = new ArrayDeque<List<FormatNode>>();

    public SimpleUnpackTreeBuilder(RubyContext context, Node currentNode) {
        this.context = context;
        this.currentNode = currentNode;
        this.sharedTreeBuilder = new SharedTreeBuilder(context);
        this.pushSequence();
    }

    public void enterSequence() {
        this.pushSequence();
    }

    public void exitSequence() {
        List<FormatNode> sequence = this.sequenceStack.pop();
        this.appendNode(new SequenceNode(sequence.toArray(new FormatNode[sequence.size()])));
    }

    @Override
    public void integer(int size, boolean signed, ByteOrder byteOrder, int count) {
        if (size == 8) {
            if (signed) {
                this.appendNode(this.sharedTreeBuilder.applyCount(count, WriteValueNodeGen.create(new OutputNode(), ReinterpretByteAsIntegerNodeGen.create(true, ReadByteNodeGen.create(new SourceNode())))));
            } else {
                this.appendNode(this.sharedTreeBuilder.applyCount(count, WriteValueNodeGen.create(new OutputNode(), ReinterpretByteAsIntegerNodeGen.create(false, ReadByteNodeGen.create(new SourceNode())))));
            }
        } else {
            this.appendIntegerNode(size, byteOrder, count, signed);
        }
    }

    @Override
    public void floatingPoint(int size, ByteOrder byteOrder, int count) {
        this.appendFloatNode(size, byteOrder, count);
    }

    @Override
    public void utf8Character(int count) {
        this.appendNode(this.sharedTreeBuilder.applyCount(count, WriteValueNodeGen.create(new OutputNode(), ReadUTF8CharacterNodeGen.create(new SourceNode()))));
    }

    @Override
    public void berInteger(int count) {
        this.appendNode(this.sharedTreeBuilder.applyCount(count, WriteValueNodeGen.create(new OutputNode(), ReadBERNodeGen.create(new SourceNode()))));
    }

    @Override
    public void binaryStringSpacePadded(int count) {
        SourceNode source = new SourceNode();
        ReadBinaryStringNode readNode = count == -1 ? ReadBinaryStringNodeGen.create(false, false, 1, true, true, false, source) : (count == -2 ? ReadBinaryStringNodeGen.create(true, false, -1, true, true, false, source) : ReadBinaryStringNodeGen.create(false, false, count, true, true, false, source));
        this.appendNode(WriteValueNodeGen.create(new OutputNode(), readNode));
    }

    @Override
    public void binaryStringNullPadded(int count) {
        SourceNode source = new SourceNode();
        ReadBinaryStringNode readNode = count == -1 ? ReadBinaryStringNodeGen.create(false, false, 1, false, false, false, source) : (count == -2 ? ReadBinaryStringNodeGen.create(true, false, -1, false, false, false, source) : ReadBinaryStringNodeGen.create(false, false, count, false, false, false, source));
        this.appendNode(WriteValueNodeGen.create(new OutputNode(), readNode));
    }

    @Override
    public void binaryStringNullStar(int count) {
        SourceNode source = new SourceNode();
        ReadBinaryStringNode readNode = count == -1 ? ReadBinaryStringNodeGen.create(false, true, 1, false, true, true, source) : (count == -2 ? ReadBinaryStringNodeGen.create(true, true, -1, false, true, true, source) : ReadBinaryStringNodeGen.create(false, false, count, false, true, true, source));
        this.appendNode(WriteValueNodeGen.create(new OutputNode(), readNode));
    }

    @Override
    public void bitStringMSBFirst(int count) {
        this.bitString(ByteOrder.BIG_ENDIAN, count);
    }

    @Override
    public void bitStringMSBLast(int count) {
        this.bitString(ByteOrder.LITTLE_ENDIAN, count);
    }

    @Override
    public void hexStringHighFirst(int count) {
        this.hexString(ByteOrder.BIG_ENDIAN, count);
    }

    @Override
    public void hexStringLowFirst(int count) {
        this.hexString(ByteOrder.LITTLE_ENDIAN, count);
    }

    @Override
    public void uuString(int count) {
        this.appendNode(WriteValueNodeGen.create(new OutputNode(), ReadUUStringNodeGen.create(new SourceNode())));
    }

    @Override
    public void mimeString(int count) {
        this.appendNode(WriteValueNodeGen.create(new OutputNode(), ReadMIMEStringNodeGen.create(new SourceNode())));
    }

    @Override
    public void base64String(int count) {
        this.appendNode(WriteValueNodeGen.create(new OutputNode(), ReadBase64StringNodeGen.create(new SourceNode())));
    }

    @Override
    public void pointer() {
    }

    @Override
    public void at(int position) {
        if (position == -1) {
            position = 0;
        } else if (position == -2) {
            return;
        }
        this.appendNode(new SetSourcePositionNode(position));
    }

    @Override
    public void back(int count) {
        if (count == -2) {
            this.appendNode(new ReverseSourcePositionNode(true));
        } else if (count == 1) {
            this.appendNode(new ReverseSourcePositionNode(false));
        } else {
            this.appendNode(this.sharedTreeBuilder.applyCount(count, new ReverseSourcePositionNode(false)));
        }
    }

    @Override
    public void nullByte(int count) {
        if (count == -2) {
            this.appendNode(new AdvanceSourcePositionNode(true));
        } else if (count == 1) {
            this.appendNode(new AdvanceSourcePositionNode(false));
        } else {
            this.appendNode(this.sharedTreeBuilder.applyCount(count, new AdvanceSourcePositionNode(false)));
        }
    }

    @Override
    public void startSubSequence() {
        this.pushSequence();
    }

    @Override
    public void finishSubSequence(int count) {
        this.appendNode(this.sharedTreeBuilder.finishSubSequence(this.sequenceStack, count));
    }

    @Override
    public void error(String message) {
        throw new RaiseException(this.context.getCoreExceptions().argumentError(message, this.currentNode));
    }

    public FormatNode getNode() {
        return this.sequenceStack.peek().get(0);
    }

    private void pushSequence() {
        this.sequenceStack.push(new ArrayList());
    }

    private void appendNode(FormatNode node) {
        this.sequenceStack.peek().add(node);
    }

    private boolean consumePartial(int count) {
        return count == -2;
    }

    private void appendIntegerNode(int size, ByteOrder byteOrder, int count, boolean signed) {
        ReadBytesNode readNode = ReadBytesNodeGen.create(size / 8, this.consumePartial(count), new SourceNode());
        FormatNode convertNode = this.createIntegerDecodeNode(size, byteOrder, signed, readNode);
        this.appendNode(this.sharedTreeBuilder.applyCount(count, WriteValueNodeGen.create(new OutputNode(), convertNode)));
    }

    private void appendFloatNode(int size, ByteOrder byteOrder, int count) {
        FormatNode decodeNode;
        FormatNode readNode = this.readBytesAsInteger(size, byteOrder, this.consumePartial(count), true);
        switch (size) {
            case 32: {
                decodeNode = ReinterpretIntegerAsFloatNodeGen.create(readNode);
                break;
            }
            case 64: {
                decodeNode = ReinterpretLongAsDoubleNodeGen.create(readNode);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        WriteValueNode writeNode = WriteValueNodeGen.create(new OutputNode(), decodeNode);
        this.appendNode(this.sharedTreeBuilder.applyCount(count, writeNode));
    }

    private FormatNode readBytesAsInteger(int size, ByteOrder byteOrder, boolean consumePartial, boolean signed) {
        ReadBytesNode readNode = ReadBytesNodeGen.create(size / 8, consumePartial, new SourceNode());
        return this.createIntegerDecodeNode(size, byteOrder, signed, readNode);
    }

    private FormatNode createIntegerDecodeNode(int size, ByteOrder byteOrder, boolean signed, FormatNode readNode) {
        FormatNode decodeNode;
        switch (size) {
            case 16: {
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    decodeNode = BytesToInteger16LittleNodeGen.create(readNode);
                    break;
                }
                decodeNode = BytesToInteger16BigNodeGen.create(readNode);
                break;
            }
            case 32: {
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    decodeNode = BytesToInteger32LittleNodeGen.create(readNode);
                    break;
                }
                decodeNode = BytesToInteger32BigNodeGen.create(readNode);
                break;
            }
            case 64: {
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    decodeNode = BytesToInteger64LittleNodeGen.create(readNode);
                    break;
                }
                decodeNode = BytesToInteger64BigNodeGen.create(readNode);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (!signed) {
            decodeNode = ReinterpretAsUnsignedNodeGen.create(decodeNode);
        }
        return decodeNode;
    }

    private void bitString(ByteOrder byteOrder, int count) {
        SharedTreeBuilder.StarLength starLength = this.sharedTreeBuilder.parseCountContext(count);
        this.appendNode(WriteValueNodeGen.create(new OutputNode(), ReadBitStringNodeGen.create(byteOrder, starLength.isStar(), starLength.getLength(), new SourceNode())));
    }

    private void hexString(ByteOrder byteOrder, int count) {
        SharedTreeBuilder.StarLength starLength = this.sharedTreeBuilder.parseCountContext(count);
        this.appendNode(WriteValueNodeGen.create(new OutputNode(), ReadHexStringNodeGen.create(byteOrder, starLength.isStar(), starLength.getLength(), new SourceNode())));
    }
}

