/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.regexp;

import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.EUCJPEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.string.KCode;

public class RegexpOptions
implements Cloneable {
    private static String WINDOWS31J = "Windows-31J";
    public static final RegexpOptions NULL_OPTIONS = new RegexpOptions(KCode.NONE, true);
    private KCode kcode;
    private boolean fixed;
    private boolean once;
    private boolean extended;
    private boolean multiline;
    private boolean ignorecase;
    private boolean java;
    private boolean encodingNone;
    private boolean kcodeDefault;
    private boolean literal;

    public RegexpOptions() {
        this(KCode.NONE, true);
    }

    public RegexpOptions(KCode kcode, boolean isKCodeDefault) {
        this.kcode = kcode;
        this.kcodeDefault = isKCodeDefault;
        assert (kcode != null) : "kcode must always be set to something";
    }

    public boolean isExtended() {
        return this.extended;
    }

    public void setExtended(boolean extended) {
        this.extended = extended;
    }

    public boolean isIgnorecase() {
        return this.ignorecase;
    }

    public void setIgnorecase(boolean ignorecase) {
        this.ignorecase = ignorecase;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public KCode getKCode() {
        return this.kcode;
    }

    public String getKCodeName() {
        return this.isKcodeDefault() ? null : this.getKCode().name().toLowerCase();
    }

    public void setExplicitKCode(KCode kcode) {
        this.kcode = kcode;
        this.kcodeDefault = false;
    }

    private KCode getExplicitKCode() {
        if (this.kcodeDefault) {
            return null;
        }
        return this.kcode;
    }

    public boolean isKcodeDefault() {
        return this.kcodeDefault;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public void setMultiline(boolean multiline) {
        this.multiline = multiline;
    }

    public boolean isOnce() {
        return this.once;
    }

    public void setOnce(boolean once) {
        this.once = once;
    }

    public boolean isJava() {
        return this.java;
    }

    public void setJava(boolean java) {
        this.java = java;
    }

    public boolean isEncodingNone() {
        return this.encodingNone;
    }

    public void setEncodingNone(boolean encodingNone) {
        this.encodingNone = encodingNone;
    }

    public boolean isLiteral() {
        return this.literal;
    }

    public void setLiteral(boolean literal) {
        this.literal = literal;
    }

    public boolean isEmbeddable() {
        return this.multiline && this.ignorecase && this.extended;
    }

    public Encoding setup(RubyContext runtime) {
        KCode explicitKCode = this.getExplicitKCode();
        if (explicitKCode == KCode.NONE) {
            this.setEncodingNone(true);
            return ASCIIEncoding.INSTANCE;
        }
        if (explicitKCode == KCode.EUC) {
            this.setFixed(true);
            return EUCJPEncoding.INSTANCE;
        }
        if (explicitKCode == KCode.SJIS) {
            this.setFixed(true);
            return Layouts.ENCODING.getEncoding(runtime.getEncodingManager().getRubyEncoding(WINDOWS31J));
        }
        if (explicitKCode == KCode.UTF8) {
            this.setFixed(true);
            return UTF8Encoding.INSTANCE;
        }
        return null;
    }

    public int toEmbeddedOptions() {
        int options = this.toJoniOptions();
        if (this.once) {
            options |= 0x80;
        }
        if (this.literal) {
            options |= 0x100;
        }
        if (this.kcodeDefault) {
            options |= 0x200;
        }
        if (this.fixed) {
            options |= 0x10;
        }
        if (this.encodingNone) {
            options |= 0x20;
        }
        return options;
    }

    public int toJoniOptions() {
        int options = 0;
        if (this.multiline) {
            options |= 4;
        }
        if (this.ignorecase) {
            options |= 1;
        }
        if (this.extended) {
            options |= 2;
        }
        return options;
    }

    public int toOptions() {
        int options = 0;
        if (this.multiline) {
            options |= 4;
        }
        if (this.ignorecase) {
            options |= 1;
        }
        if (this.extended) {
            options |= 2;
        }
        if (this.fixed) {
            options |= 0x10;
        }
        if (this.encodingNone) {
            options |= 0x20;
        }
        return options;
    }

    public static RegexpOptions fromEmbeddedOptions(int embeddedOptions) {
        RegexpOptions options = RegexpOptions.fromJoniOptions(embeddedOptions);
        options.kcodeDefault = (embeddedOptions & 0x200) != 0;
        options.setOnce((embeddedOptions & 0x80) != 0);
        options.setLiteral((embeddedOptions & 0x100) != 0);
        options.setFixed((embeddedOptions & 0x10) != 0);
        options.setEncodingNone((embeddedOptions & 0x20) != 0);
        return options;
    }

    public static RegexpOptions fromJoniOptions(int joniOptions) {
        RegexpOptions options = new RegexpOptions();
        options.setMultiline((joniOptions & 4) != 0);
        options.setIgnorecase((joniOptions & 1) != 0);
        options.setExtended((joniOptions & 2) != 0);
        options.setFixed((joniOptions & 0x10) != 0);
        options.setOnce((joniOptions & 0x80) != 0);
        return options;
    }

    public RegexpOptions withoutOnce() {
        RegexpOptions options = (RegexpOptions)this.clone();
        options.setOnce(false);
        return options;
    }

    public int hashCode() {
        int hash = 7;
        hash = 11 * hash + (this.kcode != null ? this.kcode.hashCode() : 0);
        hash = 11 * hash + (this.fixed ? 1 : 0);
        hash = 11 * hash + (this.once ? 1 : 0);
        hash = 11 * hash + (this.extended ? 1 : 0);
        hash = 11 * hash + (this.multiline ? 1 : 0);
        hash = 11 * hash + (this.ignorecase ? 1 : 0);
        hash = 11 * hash + (this.java ? 1 : 0);
        hash = 11 * hash + (this.encodingNone ? 1 : 0);
        hash = 11 * hash + (this.kcodeDefault ? 1 : 0);
        hash = 11 * hash + (this.literal ? 1 : 0);
        return hash;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException(cnse);
        }
    }

    public boolean equals(Object other) {
        boolean equality;
        if (!(other instanceof RegexpOptions)) {
            return false;
        }
        RegexpOptions o = (RegexpOptions)other;
        boolean bl = equality = o.extended == this.extended && o.fixed == this.fixed && o.ignorecase == this.ignorecase && o.java == this.java && o.multiline == this.multiline;
        if (this.encodingNone || o.encodingNone) {
            return equality && o.kcode == this.kcode;
        }
        return equality && o.encodingNone == this.encodingNone && o.kcode == this.kcode && o.kcodeDefault == this.kcodeDefault;
    }

    public String toString() {
        return "RegexpOptions(kcode: " + (Object)((Object)this.kcode) + (this.encodingNone ? ", encodingNone" : "") + (this.extended ? ", extended" : "") + (this.fixed ? ", fixed" : "") + (this.ignorecase ? ", ignorecase" : "") + (this.java ? ", java" : "") + (this.kcodeDefault ? ", kcodeDefault" : "") + (this.literal ? ", literal" : "") + (this.multiline ? ", multiline" : "") + (this.once ? ", once" : "") + ")";
    }
}

