/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.freehep.application.PrintHelper;

class PrintOptions
extends JPanel {
    private JRadioButton bestFit;
    private ButtonGroup buttonGroup1;
    private JTextField footer;
    private JCheckBox hasFooter;
    private JCheckBox hasHeader;
    private JTextField header;
    private JRadioButton landscape;
    private JCheckBox pageBorder;
    private JRadioButton portrait;
    private JCheckBox scaleUp;
    private PrintHelper helper;

    PrintOptions(PrintHelper helper) {
        this.helper = helper;
        this.initComponents();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        JPanel jPanel2 = new JPanel();
        this.scaleUp = new JCheckBox();
        this.portrait = new JRadioButton();
        this.landscape = new JRadioButton();
        this.bestFit = new JRadioButton();
        JPanel jPanel1 = new JPanel();
        this.pageBorder = new JCheckBox();
        this.hasHeader = new JCheckBox();
        this.header = new JTextField();
        this.hasFooter = new JCheckBox();
        this.footer = new JTextField();
        this.setLayout(new GridBagLayout());
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.setBorder(new TitledBorder("Page Layout"));
        this.scaleUp.setMnemonic('E');
        this.scaleUp.setSelected(this.helper.getScaleUp());
        this.scaleUp.setText("Enlarge to fill page");
        this.scaleUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PrintOptions.this.scaleUpActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)this.scaleUp, gridBagConstraints);
        this.portrait.setMnemonic('P');
        this.portrait.setSelected(this.helper.getOrientation() == 1);
        this.portrait.setText("Portrait");
        this.buttonGroup1.add(this.portrait);
        this.portrait.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PrintOptions.this.portraitActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)this.portrait, gridBagConstraints);
        this.landscape.setMnemonic('L');
        this.landscape.setSelected(this.helper.getOrientation() == 2);
        this.landscape.setText("Landscape");
        this.buttonGroup1.add(this.landscape);
        this.landscape.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PrintOptions.this.landscapeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)this.landscape, gridBagConstraints);
        this.bestFit.setMnemonic('B');
        this.bestFit.setSelected(this.helper.getOrientation() == 0);
        this.bestFit.setText("Best Fit");
        this.buttonGroup1.add(this.bestFit);
        this.bestFit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PrintOptions.this.bestFitActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)this.bestFit, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        this.add((Component)jPanel2, gridBagConstraints);
        jPanel1.setLayout(new GridBagLayout());
        jPanel1.setBorder(new TitledBorder("Page Border"));
        this.pageBorder.setMnemonic('P');
        this.pageBorder.setSelected(this.helper.isDrawBorder());
        this.pageBorder.setText("Page Border");
        this.pageBorder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PrintOptions.this.pageBorderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        jPanel1.add((Component)this.pageBorder, gridBagConstraints);
        this.hasHeader.setMnemonic('H');
        this.hasHeader.setSelected(this.helper.isShowHeader());
        this.hasHeader.setText("Header");
        this.hasHeader.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PrintOptions.this.hasHeaderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        jPanel1.add((Component)this.hasHeader, gridBagConstraints);
        this.header.setColumns(20);
        this.header.setText(this.helper.getHeader());
        this.header.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PrintOptions.this.headerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        jPanel1.add((Component)this.header, gridBagConstraints);
        this.hasFooter.setMnemonic('F');
        this.hasFooter.setSelected(this.helper.isShowFooter());
        this.hasFooter.setText("Footer");
        this.hasFooter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PrintOptions.this.hasFooterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        jPanel1.add((Component)this.hasFooter, gridBagConstraints);
        this.footer.setColumns(20);
        this.footer.setText(this.helper.getFooter());
        this.footer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PrintOptions.this.footerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        jPanel1.add((Component)this.footer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        this.add((Component)jPanel1, gridBagConstraints);
    }

    private void footerActionPerformed(ActionEvent evt) {
        this.helper.setFooter(this.footer.getText());
    }

    private void headerActionPerformed(ActionEvent evt) {
        this.helper.setHeader(this.header.getText());
    }

    private void hasFooterActionPerformed(ActionEvent evt) {
        this.helper.setShowFooter(this.hasFooter.isSelected());
    }

    private void hasHeaderActionPerformed(ActionEvent evt) {
        this.helper.setShowHeader(this.hasHeader.isSelected());
    }

    private void pageBorderActionPerformed(ActionEvent evt) {
        this.helper.setDrawBorder(this.pageBorder.isSelected());
    }

    private void bestFitActionPerformed(ActionEvent evt) {
        this.helper.setOrientation(0);
    }

    private void landscapeActionPerformed(ActionEvent evt) {
        this.helper.setOrientation(2);
    }

    private void portraitActionPerformed(ActionEvent evt) {
        this.helper.setOrientation(1);
    }

    private void scaleUpActionPerformed(ActionEvent evt) {
        this.helper.setScaleUp(this.scaleUp.isSelected());
    }
}

