/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism;

import com.sun.prism.Image;
import com.sun.prism.PixelFormat;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

public class BufferedImageTools {
    public static Image load_INT_ARGB_Raster(Raster raster, boolean bl) {
        assert (raster.getDataBuffer().getDataType() == 3);
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        int[] nArray = bl ? (int[])dataBufferInt.getData().clone() : dataBufferInt.getData();
        return Image.fromIntArgbPreData(nArray, raster.getWidth(), raster.getHeight());
    }

    public static Image load_BYTE_LUMINANCE_Raster(Raster raster, boolean bl) {
        assert (raster.getDataBuffer().getDataType() == 0);
        DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
        byte[] byArray = bl ? (byte[])dataBufferByte.getData().clone() : dataBufferByte.getData();
        return Image.fromByteGrayData(byArray, raster.getWidth(), raster.getHeight());
    }

    public static BufferedImage convertFormat(BufferedImage bufferedImage, int n) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), n);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.drawImage((java.awt.Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static Image importBufferedImage(Object object) {
        assert (object instanceof BufferedImage);
        BufferedImage bufferedImage = (BufferedImage)object;
        switch (bufferedImage.getType()) {
            case 2: 
            case 3: {
                return BufferedImageTools.load_INT_ARGB_Raster(bufferedImage.getRaster(), true);
            }
            case 10: {
                return BufferedImageTools.load_BYTE_LUMINANCE_Raster(bufferedImage.getRaster(), true);
            }
        }
        BufferedImage bufferedImage2 = BufferedImageTools.convertFormat(bufferedImage, 2);
        return BufferedImageTools.load_INT_ARGB_Raster(bufferedImage2.getRaster(), false);
    }

    private static BufferedImage export_INT_ARGB_PRE(Image image) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        assert (bufferedImage.getRaster().getDataBuffer().getDataType() == 3);
        DataBufferInt dataBufferInt = (DataBufferInt)bufferedImage.getRaster().getDataBuffer();
        IntBuffer intBuffer = (IntBuffer)image.getPixelBuffer();
        int n = intBuffer.position();
        intBuffer.rewind();
        intBuffer.get(dataBufferInt.getData());
        intBuffer.position(n);
        return bufferedImage;
    }

    private static BufferedImage export_BYTE_GRAY(Image image) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(), image.getHeight(), 10);
        assert (bufferedImage.getRaster().getDataBuffer().getDataType() == 0);
        DataBufferByte dataBufferByte = (DataBufferByte)bufferedImage.getRaster().getDataBuffer();
        ByteBuffer byteBuffer = (ByteBuffer)image.getPixelBuffer();
        int n = byteBuffer.position();
        byteBuffer.rewind();
        byteBuffer.get(dataBufferByte.getData());
        byteBuffer.position(n);
        return bufferedImage;
    }

    private static BufferedImage export_BYTE_BGRA_PRE(Image image) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        assert (bufferedImage.getRaster().getDataBuffer().getDataType() == 3);
        DataBufferInt dataBufferInt = (DataBufferInt)bufferedImage.getRaster().getDataBuffer();
        ByteBuffer byteBuffer = (ByteBuffer)image.getPixelBuffer();
        int n = byteBuffer.position();
        ByteOrder byteOrder = byteBuffer.order();
        byteBuffer.rewind();
        byteBuffer.order(ByteOrder.nativeOrder());
        byteBuffer.asIntBuffer().get(dataBufferInt.getData());
        byteBuffer.position(n);
        byteBuffer.order(byteOrder);
        return bufferedImage;
    }

    private static BufferedImage export_BYTE_RGB(Image image) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        assert (bufferedImage.getRaster().getDataBuffer().getDataType() == 3);
        DataBufferInt dataBufferInt = (DataBufferInt)bufferedImage.getRaster().getDataBuffer();
        int[] nArray = dataBufferInt.getData();
        ByteBuffer byteBuffer = (ByteBuffer)image.getPixelBuffer();
        for (int i = 0; i != image.getHeight(); ++i) {
            int n = image.getScanlineStride() * i;
            int n2 = image.getWidth() * i;
            for (int j = 0; j != image.getWidth(); ++j) {
                byte by = byteBuffer.get(n);
                byte by2 = byteBuffer.get(n + 1);
                byte by3 = byteBuffer.get(n + 2);
                nArray[n2 + j] = -16777216 + by * 65536 + by2 * 256 + by3;
                n += 3;
            }
        }
        return bufferedImage;
    }

    public static BufferedImage exportBufferedImage(Image image, Object object) {
        int n;
        BufferedImage bufferedImage = null;
        if (image.getPixelFormat() == PixelFormat.INT_ARGB_PRE) {
            bufferedImage = BufferedImageTools.export_INT_ARGB_PRE(image);
        } else if (image.getPixelFormat() == PixelFormat.BYTE_BGRA_PRE) {
            bufferedImage = BufferedImageTools.export_BYTE_BGRA_PRE(image);
        } else if (image.getPixelFormat() == PixelFormat.BYTE_RGB) {
            bufferedImage = BufferedImageTools.export_BYTE_RGB(image);
        } else if (image.getPixelFormat() == PixelFormat.BYTE_GRAY) {
            bufferedImage = BufferedImageTools.export_BYTE_GRAY(image);
        }
        if (bufferedImage != null && object != null && object instanceof BufferedImage && (n = ((BufferedImage)object).getType()) != bufferedImage.getType()) {
            return BufferedImageTools.convertFormat(bufferedImage, n);
        }
        return bufferedImage;
    }
}

