/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class RenameLayerAction
extends AbstractAction {
    private final File file;
    private final transient Layer layer;

    public RenameLayerAction(File file, Layer layer) {
        super(I18n.tr("Rename layer", new Object[0]), ImageProvider.get("dialogs", "edit"));
        this.file = file;
        this.layer = layer;
        this.putValue("help", HelpUtil.ht("/Action/RenameLayer"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Box box = Box.createVerticalBox();
        JosmTextField josmTextField = new JosmTextField(this.layer.getName());
        box.add(josmTextField);
        JCheckBox jCheckBox = new JCheckBox(I18n.tr("Also rename the file", new Object[0]));
        box.add(jCheckBox);
        jCheckBox.setEnabled(this.file != null);
        if (jCheckBox.isEnabled()) {
            jCheckBox.setSelected(Main.pref.getBoolean("layer.rename-file", true));
        }
        InitialValueOptionPane initialValueOptionPane = new InitialValueOptionPane(box, josmTextField);
        JDialog jDialog = initialValueOptionPane.createDialog(Main.parent, I18n.tr("Rename layer", new Object[0]));
        jDialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        jDialog.setVisible(true);
        Object object = initialValueOptionPane.getValue();
        if (object == null || object == JOptionPane.UNINITIALIZED_VALUE || object instanceof Integer && (Integer)object != 0) {
            return;
        }
        String string = josmTextField.getText();
        if (jCheckBox.isEnabled()) {
            Main.pref.put("layer.rename-file", jCheckBox.isSelected());
            if (jCheckBox.isSelected()) {
                File file;
                String string2 = string;
                if (string2.indexOf(47) == -1 && string2.indexOf(92) == -1) {
                    string2 = this.file.getParent() + File.separator + string2;
                }
                String string3 = this.file.getName();
                if (josmTextField.getText().indexOf(46) == -1 && string3.indexOf(46) >= 0) {
                    string2 = string2 + string3.substring(string3.lastIndexOf(46));
                }
                if (!SaveActionBase.confirmOverwrite(file = new File(string2))) {
                    return;
                }
                if (Main.platform.rename(this.file, file)) {
                    this.layer.setAssociatedFile(file);
                    if (!this.layer.isRenamed()) {
                        string = file.getName();
                    }
                } else {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not rename file ''{0}''", this.file.getPath()), I18n.tr("Error", new Object[0]), 0);
                    return;
                }
            }
        }
        this.layer.rename(string);
        Main.parent.repaint();
    }

    static class InitialValueOptionPane
    extends JOptionPane {
        InitialValueOptionPane(Box box, JosmTextField josmTextField) {
            super(box, 3, 2, null, null, josmTextField);
        }

        @Override
        public void selectInitialValue() {
            JosmTextField josmTextField = (JosmTextField)this.getInitialValue();
            josmTextField.requestFocusInWindow();
            josmTextField.selectAll();
        }
    }
}

