/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.methods;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Instrumentable;
import com.oracle.truffle.api.object.DynamicObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.core.kernel.TraceManager;
import org.jruby.truffle.language.LexicalScope;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.Visibility;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.methods.InternalMethod;
import org.jruby.truffle.language.methods.ModuleBodyDefinitionNodeWrapper;
import org.jruby.truffle.language.methods.SharedMethodInfo;

@Instrumentable(factory=ModuleBodyDefinitionNodeWrapper.class)
public class ModuleBodyDefinitionNode
extends RubyNode {
    private final String name;
    private final SharedMethodInfo sharedMethodInfo;
    private final CallTarget callTarget;
    private final boolean captureBlock;
    private final boolean dynamicLexicalScope;
    private final Map<DynamicObject, LexicalScope> lexicalScopes;

    public ModuleBodyDefinitionNode(String name, SharedMethodInfo sharedMethodInfo, CallTarget callTarget, boolean captureBlock, boolean dynamicLexicalScope) {
        this.name = name;
        this.sharedMethodInfo = sharedMethodInfo;
        this.callTarget = callTarget;
        this.captureBlock = captureBlock;
        this.dynamicLexicalScope = dynamicLexicalScope;
        this.lexicalScopes = dynamicLexicalScope ? new ConcurrentHashMap() : null;
    }

    public ModuleBodyDefinitionNode(ModuleBodyDefinitionNode node) {
        this(node.name, node.sharedMethodInfo, node.callTarget, node.captureBlock, node.dynamicLexicalScope);
    }

    public InternalMethod createMethod(VirtualFrame frame, LexicalScope staticLexicalScope, DynamicObject module) {
        DynamicObject capturedBlock = this.captureBlock ? RubyArguments.getBlock(frame) : null;
        LexicalScope parentLexicalScope = RubyArguments.getMethod(frame).getLexicalScope();
        LexicalScope lexicalScope = this.prepareLexicalScope(staticLexicalScope, parentLexicalScope, module);
        return new InternalMethod(this.getContext(), this.sharedMethodInfo, lexicalScope, this.name, module, Visibility.PUBLIC, false, null, this.callTarget, capturedBlock, null);
    }

    @CompilerDirectives.TruffleBoundary
    private LexicalScope prepareLexicalScope(LexicalScope staticLexicalScope, LexicalScope parentLexicalScope, DynamicObject module) {
        staticLexicalScope.unsafeSetLiveModule(module);
        Layouts.MODULE.getFields(staticLexicalScope.getParent().getLiveModule()).addLexicalDependent(module);
        if (!this.dynamicLexicalScope) {
            return staticLexicalScope;
        }
        return this.lexicalScopes.computeIfAbsent(module, m -> new LexicalScope(parentLexicalScope, module));
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.nil();
    }

    @Override
    protected boolean isTaggedWith(Class<?> tag) {
        if (tag == TraceManager.ClassTag.class) {
            return true;
        }
        return super.isTaggedWith(tag);
    }
}

